/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.endpointdiscovery.providers.DefaultEndpointDiscoveryProviderChain;
import software.amazon.awssdk.core.endpointdiscovery.providers.EndpointDiscoveryProviderChain;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.utils.CollectionUtils;

/**
 * Internal base class for {@link DefaultDynamoDbClientBuilder} and {@link DefaultDynamoDbAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
abstract class DefaultDynamoDbBaseClientBuilder<B extends DynamoDbBaseClientBuilder<B, C>, C> extends
        AwsDefaultClientBuilder<B, C> {
    private static final EndpointDiscoveryProviderChain CHAIN = new DefaultEndpointDiscoveryProviderChain();

    protected boolean endpointDiscoveryEnabled = false;

    @Override
    protected final String serviceEndpointPrefix() {
        return "dynamodb";
    }

    @Override
    protected final String serviceName() {
        return "DynamoDb";
    }

    @Override
    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option(SdkAdvancedClientOption.SIGNER, defaultSigner())
                .option(SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, true)
                .option(SdkClientOption.RETRY_POLICY, DynamoDbRetryPolicy.defaultRetryPolicy()));
    }

    @Override
    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List<ExecutionInterceptor> interceptors = interceptorFactory
                .getInterceptors("software/amazon/awssdk/services/dynamodb/execution.interceptors");
        interceptors = CollectionUtils.mergeLists(interceptors, config.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        if (!endpointDiscoveryEnabled) {
            endpointDiscoveryEnabled = CHAIN.resolveEndpointDiscovery();
        }
        return config
                .toBuilder()
                .option(SdkClientOption.ENDPOINT_DISCOVERY_ENABLED, endpointDiscoveryEnabled)
                .option(SdkClientOption.EXECUTION_INTERCEPTORS, interceptors)
                .option(SdkClientOption.RETRY_POLICY,
                        DynamoDbRetryPolicy.addRetryConditions(config.option(SdkClientOption.RETRY_POLICY))).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    @Override
    protected final String signingName() {
        return "dynamodb";
    }
}
