/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillingModeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillingModeSummary> {
    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BillingModeSummary.getter(BillingModeSummary::billingModeAsString)).setter(BillingModeSummary.setter(Builder::billingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TO_PAY_PER_REQUEST_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BillingModeSummary.getter(BillingModeSummary::lastUpdateToPayPerRequestDateTime)).setter(BillingModeSummary.setter(Builder::lastUpdateToPayPerRequestDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateToPayPerRequestDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_MODE_FIELD, LAST_UPDATE_TO_PAY_PER_REQUEST_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String billingMode;
    private final Instant lastUpdateToPayPerRequestDateTime;

    private BillingModeSummary(BuilderImpl builder) {
        this.billingMode = builder.billingMode;
        this.lastUpdateToPayPerRequestDateTime = builder.lastUpdateToPayPerRequestDateTime;
    }

    public BillingMode billingMode() {
        return BillingMode.fromValue(this.billingMode);
    }

    public String billingModeAsString() {
        return this.billingMode;
    }

    public Instant lastUpdateToPayPerRequestDateTime() {
        return this.lastUpdateToPayPerRequestDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateToPayPerRequestDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingModeSummary)) {
            return false;
        }
        BillingModeSummary other = (BillingModeSummary)obj;
        return Objects.equals(this.billingModeAsString(), other.billingModeAsString()) && Objects.equals(this.lastUpdateToPayPerRequestDateTime(), other.lastUpdateToPayPerRequestDateTime());
    }

    public String toString() {
        return ToString.builder((String)"BillingModeSummary").add("BillingMode", (Object)this.billingModeAsString()).add("LastUpdateToPayPerRequestDateTime", (Object)this.lastUpdateToPayPerRequestDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BillingMode": {
                return Optional.ofNullable(clazz.cast(this.billingModeAsString()));
            }
            case "LastUpdateToPayPerRequestDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateToPayPerRequestDateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BillingModeSummary, T> g) {
        return obj -> g.apply((BillingModeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String billingMode;
        private Instant lastUpdateToPayPerRequestDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingModeSummary model) {
            this.billingMode(model.billingMode);
            this.lastUpdateToPayPerRequestDateTime(model.lastUpdateToPayPerRequestDateTime);
        }

        public final String getBillingMode() {
            return this.billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        public final Instant getLastUpdateToPayPerRequestDateTime() {
            return this.lastUpdateToPayPerRequestDateTime;
        }

        @Override
        public final Builder lastUpdateToPayPerRequestDateTime(Instant lastUpdateToPayPerRequestDateTime) {
            this.lastUpdateToPayPerRequestDateTime = lastUpdateToPayPerRequestDateTime;
            return this;
        }

        public final void setLastUpdateToPayPerRequestDateTime(Instant lastUpdateToPayPerRequestDateTime) {
            this.lastUpdateToPayPerRequestDateTime = lastUpdateToPayPerRequestDateTime;
        }

        public BillingModeSummary build() {
            return new BillingModeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillingModeSummary> {
        public Builder billingMode(String var1);

        public Builder billingMode(BillingMode var1);

        public Builder lastUpdateToPayPerRequestDateTime(Instant var1);
    }
}

