/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>ListTables</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTablesResponse extends DynamoDbResponse implements
        ToCopyableBuilder<ListTablesResponse.Builder, ListTablesResponse> {
    private static final SdkField<List<String>> TABLE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TableNames")
            .getter(getter(ListTablesResponse::tableNames))
            .setter(setter(Builder::tableNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_EVALUATED_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastEvaluatedTableName").getter(getter(ListTablesResponse::lastEvaluatedTableName))
            .setter(setter(Builder::lastEvaluatedTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedTableName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAMES_FIELD,
            LAST_EVALUATED_TABLE_NAME_FIELD));

    private final List<String> tableNames;

    private final String lastEvaluatedTableName;

    private ListTablesResponse(BuilderImpl builder) {
        super(builder);
        this.tableNames = builder.tableNames;
        this.lastEvaluatedTableName = builder.lastEvaluatedTableName;
    }

    /**
     * Returns true if the TableNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTableNames() {
        return tableNames != null && !(tableNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the tables associated with the current account at the current endpoint. The maximum size of this
     * array is 100.
     * </p>
     * <p>
     * If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
     * <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and obtain the
     * next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTableNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the tables associated with the current account at the current endpoint. The maximum size of
     *         this array is 100.</p>
     *         <p>
     *         If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
     *         <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and obtain
     *         the next page of results.
     */
    public List<String> tableNames() {
        return tableNames;
    }

    /**
     * <p>
     * The name of the last table in the current page of results. Use this value as the
     * <code>ExclusiveStartTableName</code> in a new request to obtain the next page of results, until all the table
     * names are returned.
     * </p>
     * <p>
     * If you do not receive a <code>LastEvaluatedTableName</code> value in the response, this means that there are no
     * more table names to be retrieved.
     * </p>
     * 
     * @return The name of the last table in the current page of results. Use this value as the
     *         <code>ExclusiveStartTableName</code> in a new request to obtain the next page of results, until all the
     *         table names are returned.</p>
     *         <p>
     *         If you do not receive a <code>LastEvaluatedTableName</code> value in the response, this means that there
     *         are no more table names to be retrieved.
     */
    public String lastEvaluatedTableName() {
        return lastEvaluatedTableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableNames());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedTableName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResponse)) {
            return false;
        }
        ListTablesResponse other = (ListTablesResponse) obj;
        return Objects.equals(tableNames(), other.tableNames())
                && Objects.equals(lastEvaluatedTableName(), other.lastEvaluatedTableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTablesResponse").add("TableNames", tableNames())
                .add("LastEvaluatedTableName", lastEvaluatedTableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableNames":
            return Optional.ofNullable(clazz.cast(tableNames()));
        case "LastEvaluatedTableName":
            return Optional.ofNullable(clazz.cast(lastEvaluatedTableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTablesResponse, T> g) {
        return obj -> g.apply((ListTablesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTablesResponse> {
        /**
         * <p>
         * The names of the tables associated with the current account at the current endpoint. The maximum size of this
         * array is 100.
         * </p>
         * <p>
         * If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
         * <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and obtain the
         * next page of results.
         * </p>
         * 
         * @param tableNames
         *        The names of the tables associated with the current account at the current endpoint. The maximum size
         *        of this array is 100.</p>
         *        <p>
         *        If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
         *        <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and
         *        obtain the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableNames(Collection<String> tableNames);

        /**
         * <p>
         * The names of the tables associated with the current account at the current endpoint. The maximum size of this
         * array is 100.
         * </p>
         * <p>
         * If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
         * <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and obtain the
         * next page of results.
         * </p>
         * 
         * @param tableNames
         *        The names of the tables associated with the current account at the current endpoint. The maximum size
         *        of this array is 100.</p>
         *        <p>
         *        If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the
         *        <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and
         *        obtain the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableNames(String... tableNames);

        /**
         * <p>
         * The name of the last table in the current page of results. Use this value as the
         * <code>ExclusiveStartTableName</code> in a new request to obtain the next page of results, until all the table
         * names are returned.
         * </p>
         * <p>
         * If you do not receive a <code>LastEvaluatedTableName</code> value in the response, this means that there are
         * no more table names to be retrieved.
         * </p>
         * 
         * @param lastEvaluatedTableName
         *        The name of the last table in the current page of results. Use this value as the
         *        <code>ExclusiveStartTableName</code> in a new request to obtain the next page of results, until all
         *        the table names are returned.</p>
         *        <p>
         *        If you do not receive a <code>LastEvaluatedTableName</code> value in the response, this means that
         *        there are no more table names to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedTableName(String lastEvaluatedTableName);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<String> tableNames = DefaultSdkAutoConstructList.getInstance();

        private String lastEvaluatedTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesResponse model) {
            super(model);
            tableNames(model.tableNames);
            lastEvaluatedTableName(model.lastEvaluatedTableName);
        }

        public final Collection<String> getTableNames() {
            return tableNames;
        }

        @Override
        public final Builder tableNames(Collection<String> tableNames) {
            this.tableNames = TableNameListCopier.copy(tableNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableNames(String... tableNames) {
            tableNames(Arrays.asList(tableNames));
            return this;
        }

        public final void setTableNames(Collection<String> tableNames) {
            this.tableNames = TableNameListCopier.copy(tableNames);
        }

        public final String getLastEvaluatedTableName() {
            return lastEvaluatedTableName;
        }

        @Override
        public final Builder lastEvaluatedTableName(String lastEvaluatedTableName) {
            this.lastEvaluatedTableName = lastEvaluatedTableName;
            return this;
        }

        public final void setLastEvaluatedTableName(String lastEvaluatedTableName) {
            this.lastEvaluatedTableName = lastEvaluatedTableName;
        }

        @Override
        public ListTablesResponse build() {
            return new ListTablesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
