/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of the replica.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaDescription.Builder, ReplicaDescription> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(ReplicaDescription::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<String> REPLICA_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicaStatus").getter(getter(ReplicaDescription::replicaStatusAsString))
            .setter(setter(Builder::replicaStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatus").build()).build();

    private static final SdkField<String> REPLICA_STATUS_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicaStatusDescription").getter(getter(ReplicaDescription::replicaStatusDescription))
            .setter(setter(Builder::replicaStatusDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatusDescription").build())
            .build();

    private static final SdkField<String> REPLICA_STATUS_PERCENT_PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicaStatusPercentProgress")
            .getter(getter(ReplicaDescription::replicaStatusPercentProgress))
            .setter(setter(Builder::replicaStatusPercentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatusPercentProgress")
                    .build()).build();

    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSMasterKeyId").getter(getter(ReplicaDescription::kmsMasterKeyId))
            .setter(setter(Builder::kmsMasterKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyId").build()).build();

    private static final SdkField<ProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField
            .<ProvisionedThroughputOverride> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedThroughputOverride")
            .getter(getter(ReplicaDescription::provisionedThroughputOverride))
            .setter(setter(Builder::provisionedThroughputOverride))
            .constructor(ProvisionedThroughputOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride")
                    .build()).build();

    private static final SdkField<List<ReplicaGlobalSecondaryIndexDescription>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<ReplicaGlobalSecondaryIndexDescription>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexes")
            .getter(getter(ReplicaDescription::globalSecondaryIndexes))
            .setter(setter(Builder::globalSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaGlobalSecondaryIndexDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaGlobalSecondaryIndexDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> REPLICA_INACCESSIBLE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReplicaInaccessibleDateTime")
            .getter(getter(ReplicaDescription::replicaInaccessibleDateTime))
            .setter(setter(Builder::replicaInaccessibleDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaInaccessibleDateTime")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            REPLICA_STATUS_FIELD, REPLICA_STATUS_DESCRIPTION_FIELD, REPLICA_STATUS_PERCENT_PROGRESS_FIELD,
            KMS_MASTER_KEY_ID_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD,
            REPLICA_INACCESSIBLE_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final String replicaStatus;

    private final String replicaStatusDescription;

    private final String replicaStatusPercentProgress;

    private final String kmsMasterKeyId;

    private final ProvisionedThroughputOverride provisionedThroughputOverride;

    private final List<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes;

    private final Instant replicaInaccessibleDateTime;

    private ReplicaDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaStatus = builder.replicaStatus;
        this.replicaStatusDescription = builder.replicaStatusDescription;
        this.replicaStatusPercentProgress = builder.replicaStatusPercentProgress;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.replicaInaccessibleDateTime = builder.replicaInaccessibleDateTime;
    }

    /**
     * <p>
     * The name of the Region.
     * </p>
     * 
     * @return The name of the Region.
     */
    public String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The current state of the replica:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The replica is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The replica is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The replica is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The replica is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION_DISABLED</code> - The replica is inaccessible because the AWS Region has been disabled.
     * </p>
     * <note>
     * <p>
     * If the AWS Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the
     * replication group. The replica will not be deleted and replication will stop from and to this region.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaStatus}
     * will return {@link ReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaStatusAsString}.
     * </p>
     * 
     * @return The current state of the replica:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The replica is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The replica is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The replica is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The replica is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGION_DISABLED</code> - The replica is inaccessible because the AWS Region has been disabled.
     *         </p>
     *         <note>
     *         <p>
     *         If the AWS Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the
     *         replication group. The replica will not be deleted and replication will stop from and to this region.
     *         </p>
     *         </note></li>
     * @see ReplicaStatus
     */
    public ReplicaStatus replicaStatus() {
        return ReplicaStatus.fromValue(replicaStatus);
    }

    /**
     * <p>
     * The current state of the replica:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The replica is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The replica is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The replica is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The replica is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION_DISABLED</code> - The replica is inaccessible because the AWS Region has been disabled.
     * </p>
     * <note>
     * <p>
     * If the AWS Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the
     * replication group. The replica will not be deleted and replication will stop from and to this region.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaStatus}
     * will return {@link ReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaStatusAsString}.
     * </p>
     * 
     * @return The current state of the replica:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The replica is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The replica is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The replica is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The replica is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGION_DISABLED</code> - The replica is inaccessible because the AWS Region has been disabled.
     *         </p>
     *         <note>
     *         <p>
     *         If the AWS Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the
     *         replication group. The replica will not be deleted and replication will stop from and to this region.
     *         </p>
     *         </note></li>
     * @see ReplicaStatus
     */
    public String replicaStatusAsString() {
        return replicaStatus;
    }

    /**
     * <p>
     * Detailed information about the replica status.
     * </p>
     * 
     * @return Detailed information about the replica status.
     */
    public String replicaStatusDescription() {
        return replicaStatusDescription;
    }

    /**
     * <p>
     * Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.
     * </p>
     * 
     * @return Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.
     */
    public String replicaStatusPercentProgress() {
        return replicaStatusPercentProgress;
    }

    /**
     * <p>
     * The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS encryption.
     * </p>
     * 
     * @return The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS encryption.
     */
    public String kmsMasterKeyId() {
        return kmsMasterKeyId;
    }

    /**
     * <p>
     * Replica-specific provisioned throughput. If not described, uses the source table's provisioned throughput
     * settings.
     * </p>
     * 
     * @return Replica-specific provisioned throughput. If not described, uses the source table's provisioned throughput
     *         settings.
     */
    public ProvisionedThroughputOverride provisionedThroughputOverride() {
        return provisionedThroughputOverride;
    }

    /**
     * Returns true if the GlobalSecondaryIndexes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasGlobalSecondaryIndexes() {
        return globalSecondaryIndexes != null && !(globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Replica-specific global secondary index settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalSecondaryIndexes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Replica-specific global secondary index settings.
     */
    public List<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    /**
     * <p>
     * The time at which the replica was first detected as inaccessible. To determine cause of inaccessibility check the
     * <code>ReplicaStatus</code> property.
     * </p>
     * 
     * @return The time at which the replica was first detected as inaccessible. To determine cause of inaccessibility
     *         check the <code>ReplicaStatus</code> property.
     */
    public Instant replicaInaccessibleDateTime() {
        return replicaInaccessibleDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(replicaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicaStatusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(replicaStatusPercentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicaInaccessibleDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaDescription)) {
            return false;
        }
        ReplicaDescription other = (ReplicaDescription) obj;
        return Objects.equals(regionName(), other.regionName())
                && Objects.equals(replicaStatusAsString(), other.replicaStatusAsString())
                && Objects.equals(replicaStatusDescription(), other.replicaStatusDescription())
                && Objects.equals(replicaStatusPercentProgress(), other.replicaStatusPercentProgress())
                && Objects.equals(kmsMasterKeyId(), other.kmsMasterKeyId())
                && Objects.equals(provisionedThroughputOverride(), other.provisionedThroughputOverride())
                && hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes()
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes())
                && Objects.equals(replicaInaccessibleDateTime(), other.replicaInaccessibleDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplicaDescription").add("RegionName", regionName())
                .add("ReplicaStatus", replicaStatusAsString()).add("ReplicaStatusDescription", replicaStatusDescription())
                .add("ReplicaStatusPercentProgress", replicaStatusPercentProgress()).add("KMSMasterKeyId", kmsMasterKeyId())
                .add("ProvisionedThroughputOverride", provisionedThroughputOverride())
                .add("GlobalSecondaryIndexes", hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null)
                .add("ReplicaInaccessibleDateTime", replicaInaccessibleDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "ReplicaStatus":
            return Optional.ofNullable(clazz.cast(replicaStatusAsString()));
        case "ReplicaStatusDescription":
            return Optional.ofNullable(clazz.cast(replicaStatusDescription()));
        case "ReplicaStatusPercentProgress":
            return Optional.ofNullable(clazz.cast(replicaStatusPercentProgress()));
        case "KMSMasterKeyId":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyId()));
        case "ProvisionedThroughputOverride":
            return Optional.ofNullable(clazz.cast(provisionedThroughputOverride()));
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        case "ReplicaInaccessibleDateTime":
            return Optional.ofNullable(clazz.cast(replicaInaccessibleDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaDescription, T> g) {
        return obj -> g.apply((ReplicaDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaDescription> {
        /**
         * <p>
         * The name of the Region.
         * </p>
         * 
         * @param regionName
         *        The name of the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The current state of the replica:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The replica is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The replica is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The replica is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The replica is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION_DISABLED</code> - The replica is inaccessible because the AWS Region has been disabled.
         * </p>
         * <note>
         * <p>
         * If the AWS Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the
         * replication group. The replica will not be deleted and replication will stop from and to this region.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param replicaStatus
         *        The current state of the replica:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The replica is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The replica is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The replica is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The replica is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGION_DISABLED</code> - The replica is inaccessible because the AWS Region has been disabled.
         *        </p>
         *        <note>
         *        <p>
         *        If the AWS Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from
         *        the replication group. The replica will not be deleted and replication will stop from and to this
         *        region.
         *        </p>
         *        </note></li>
         * @see ReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaStatus
         */
        Builder replicaStatus(String replicaStatus);

        /**
         * <p>
         * The current state of the replica:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The replica is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The replica is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The replica is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The replica is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION_DISABLED</code> - The replica is inaccessible because the AWS Region has been disabled.
         * </p>
         * <note>
         * <p>
         * If the AWS Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the
         * replication group. The replica will not be deleted and replication will stop from and to this region.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param replicaStatus
         *        The current state of the replica:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The replica is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The replica is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The replica is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The replica is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGION_DISABLED</code> - The replica is inaccessible because the AWS Region has been disabled.
         *        </p>
         *        <note>
         *        <p>
         *        If the AWS Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from
         *        the replication group. The replica will not be deleted and replication will stop from and to this
         *        region.
         *        </p>
         *        </note></li>
         * @see ReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaStatus
         */
        Builder replicaStatus(ReplicaStatus replicaStatus);

        /**
         * <p>
         * Detailed information about the replica status.
         * </p>
         * 
         * @param replicaStatusDescription
         *        Detailed information about the replica status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaStatusDescription(String replicaStatusDescription);

        /**
         * <p>
         * Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.
         * </p>
         * 
         * @param replicaStatusPercentProgress
         *        Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaStatusPercentProgress(String replicaStatusPercentProgress);

        /**
         * <p>
         * The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS encryption.
         * </p>
         * 
         * @param kmsMasterKeyId
         *        The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyId(String kmsMasterKeyId);

        /**
         * <p>
         * Replica-specific provisioned throughput. If not described, uses the source table's provisioned throughput
         * settings.
         * </p>
         * 
         * @param provisionedThroughputOverride
         *        Replica-specific provisioned throughput. If not described, uses the source table's provisioned
         *        throughput settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride);

        /**
         * <p>
         * Replica-specific provisioned throughput. If not described, uses the source table's provisioned throughput
         * settings.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedThroughputOverride.Builder} avoiding
         * the need to create one manually via {@link ProvisionedThroughputOverride#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughputOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedThroughputOverride(ProvisionedThroughputOverride)}
         * .
         * 
         * @param provisionedThroughputOverride
         *        a consumer that will call methods on {@link ProvisionedThroughputOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughputOverride(ProvisionedThroughputOverride)
         */
        default Builder provisionedThroughputOverride(
                Consumer<ProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return provisionedThroughputOverride(ProvisionedThroughputOverride.builder()
                    .applyMutation(provisionedThroughputOverride).build());
        }

        /**
         * <p>
         * Replica-specific global secondary index settings.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        Replica-specific global secondary index settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes);

        /**
         * <p>
         * Replica-specific global secondary index settings.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        Replica-specific global secondary index settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndexDescription... globalSecondaryIndexes);

        /**
         * <p>
         * Replica-specific global secondary index settings.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ReplicaGlobalSecondaryIndexDescription>.Builder} avoiding the need to create one manually via {@link List
         * <ReplicaGlobalSecondaryIndexDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaGlobalSecondaryIndexDescription>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #globalSecondaryIndexes(List<ReplicaGlobalSecondaryIndexDescription>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on {@link List<ReplicaGlobalSecondaryIndexDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(List<ReplicaGlobalSecondaryIndexDescription>)
         */
        Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndexDescription.Builder>... globalSecondaryIndexes);

        /**
         * <p>
         * The time at which the replica was first detected as inaccessible. To determine cause of inaccessibility check
         * the <code>ReplicaStatus</code> property.
         * </p>
         * 
         * @param replicaInaccessibleDateTime
         *        The time at which the replica was first detected as inaccessible. To determine cause of
         *        inaccessibility check the <code>ReplicaStatus</code> property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaInaccessibleDateTime(Instant replicaInaccessibleDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private String replicaStatus;

        private String replicaStatusDescription;

        private String replicaStatusPercentProgress;

        private String kmsMasterKeyId;

        private ProvisionedThroughputOverride provisionedThroughputOverride;

        private List<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private Instant replicaInaccessibleDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaDescription model) {
            regionName(model.regionName);
            replicaStatus(model.replicaStatus);
            replicaStatusDescription(model.replicaStatusDescription);
            replicaStatusPercentProgress(model.replicaStatusPercentProgress);
            kmsMasterKeyId(model.kmsMasterKeyId);
            provisionedThroughputOverride(model.provisionedThroughputOverride);
            globalSecondaryIndexes(model.globalSecondaryIndexes);
            replicaInaccessibleDateTime(model.replicaInaccessibleDateTime);
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getReplicaStatus() {
            return replicaStatus;
        }

        @Override
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        @Override
        public final Builder replicaStatus(ReplicaStatus replicaStatus) {
            this.replicaStatus(replicaStatus == null ? null : replicaStatus.toString());
            return this;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        public final String getReplicaStatusDescription() {
            return replicaStatusDescription;
        }

        @Override
        public final Builder replicaStatusDescription(String replicaStatusDescription) {
            this.replicaStatusDescription = replicaStatusDescription;
            return this;
        }

        public final void setReplicaStatusDescription(String replicaStatusDescription) {
            this.replicaStatusDescription = replicaStatusDescription;
        }

        public final String getReplicaStatusPercentProgress() {
            return replicaStatusPercentProgress;
        }

        @Override
        public final Builder replicaStatusPercentProgress(String replicaStatusPercentProgress) {
            this.replicaStatusPercentProgress = replicaStatusPercentProgress;
            return this;
        }

        public final void setReplicaStatusPercentProgress(String replicaStatusPercentProgress) {
            this.replicaStatusPercentProgress = replicaStatusPercentProgress;
        }

        public final String getKmsMasterKeyId() {
            return kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public final ProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return provisionedThroughputOverride != null ? provisionedThroughputOverride.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build()
                    : null;
        }

        public final Collection<ReplicaGlobalSecondaryIndexDescription.Builder> getGlobalSecondaryIndexes() {
            if (globalSecondaryIndexes instanceof SdkAutoConstructList) {
                return null;
            }
            return globalSecondaryIndexes != null ? globalSecondaryIndexes.stream()
                    .map(ReplicaGlobalSecondaryIndexDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexDescriptionListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndexDescription... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(
                Consumer<ReplicaGlobalSecondaryIndexDescription.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> ReplicaGlobalSecondaryIndexDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexes(
                Collection<ReplicaGlobalSecondaryIndexDescription.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexDescriptionListCopier
                    .copyFromBuilder(globalSecondaryIndexes);
        }

        public final Instant getReplicaInaccessibleDateTime() {
            return replicaInaccessibleDateTime;
        }

        @Override
        public final Builder replicaInaccessibleDateTime(Instant replicaInaccessibleDateTime) {
            this.replicaInaccessibleDateTime = replicaInaccessibleDateTime;
            return this;
        }

        public final void setReplicaInaccessibleDateTime(Instant replicaInaccessibleDateTime) {
            this.replicaInaccessibleDateTime = replicaInaccessibleDateTime;
        }

        @Override
        public ReplicaDescription build() {
            return new ReplicaDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
