/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTableToPointInTimeRequest extends DynamoDbRequest implements
        ToCopyableBuilder<RestoreTableToPointInTimeRequest.Builder, RestoreTableToPointInTimeRequest> {
    private static final SdkField<String> SOURCE_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceTableArn").getter(getter(RestoreTableToPointInTimeRequest::sourceTableArn))
            .setter(setter(Builder::sourceTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableArn").build()).build();

    private static final SdkField<String> SOURCE_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceTableName").getter(getter(RestoreTableToPointInTimeRequest::sourceTableName))
            .setter(setter(Builder::sourceTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableName").build()).build();

    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetTableName").getter(getter(RestoreTableToPointInTimeRequest::targetTableName))
            .setter(setter(Builder::targetTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()).build();

    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_TIME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseLatestRestorableTime").getter(getter(RestoreTableToPointInTimeRequest::useLatestRestorableTime))
            .setter(setter(Builder::useLatestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLatestRestorableTime").build())
            .build();

    private static final SdkField<Instant> RESTORE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RestoreDateTime").getter(getter(RestoreTableToPointInTimeRequest::restoreDateTime))
            .setter(setter(Builder::restoreDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreDateTime").build()).build();

    private static final SdkField<String> BILLING_MODE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingModeOverride").getter(getter(RestoreTableToPointInTimeRequest::billingModeOverrideAsString))
            .setter(setter(Builder::billingModeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingModeOverride").build())
            .build();

    private static final SdkField<List<GlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD = SdkField
            .<List<GlobalSecondaryIndex>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexOverride")
            .getter(getter(RestoreTableToPointInTimeRequest::globalSecondaryIndexOverride))
            .setter(setter(Builder::globalSecondaryIndexOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexOverride")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LocalSecondaryIndex>> LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD = SdkField
            .<List<LocalSecondaryIndex>> builder(MarshallingType.LIST)
            .memberName("LocalSecondaryIndexOverride")
            .getter(getter(RestoreTableToPointInTimeRequest::localSecondaryIndexOverride))
            .setter(setter(Builder::localSecondaryIndexOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexOverride")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedThroughputOverride")
            .getter(getter(RestoreTableToPointInTimeRequest::provisionedThroughputOverride))
            .setter(setter(Builder::provisionedThroughputOverride))
            .constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride")
                    .build()).build();

    private static final SdkField<SSESpecification> SSE_SPECIFICATION_OVERRIDE_FIELD = SdkField
            .<SSESpecification> builder(MarshallingType.SDK_POJO).memberName("SSESpecificationOverride")
            .getter(getter(RestoreTableToPointInTimeRequest::sseSpecificationOverride))
            .setter(setter(Builder::sseSpecificationOverride)).constructor(SSESpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecificationOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TABLE_ARN_FIELD,
            SOURCE_TABLE_NAME_FIELD, TARGET_TABLE_NAME_FIELD, USE_LATEST_RESTORABLE_TIME_FIELD, RESTORE_DATE_TIME_FIELD,
            BILLING_MODE_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD, LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD,
            PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, SSE_SPECIFICATION_OVERRIDE_FIELD));

    private final String sourceTableArn;

    private final String sourceTableName;

    private final String targetTableName;

    private final Boolean useLatestRestorableTime;

    private final Instant restoreDateTime;

    private final String billingModeOverride;

    private final List<GlobalSecondaryIndex> globalSecondaryIndexOverride;

    private final List<LocalSecondaryIndex> localSecondaryIndexOverride;

    private final ProvisionedThroughput provisionedThroughputOverride;

    private final SSESpecification sseSpecificationOverride;

    private RestoreTableToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.sourceTableArn = builder.sourceTableArn;
        this.sourceTableName = builder.sourceTableName;
        this.targetTableName = builder.targetTableName;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.restoreDateTime = builder.restoreDateTime;
        this.billingModeOverride = builder.billingModeOverride;
        this.globalSecondaryIndexOverride = builder.globalSecondaryIndexOverride;
        this.localSecondaryIndexOverride = builder.localSecondaryIndexOverride;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.sseSpecificationOverride = builder.sseSpecificationOverride;
    }

    /**
     * <p>
     * The DynamoDB table that will be restored. This value is an Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The DynamoDB table that will be restored. This value is an Amazon Resource Name (ARN).
     */
    public String sourceTableArn() {
        return sourceTableArn;
    }

    /**
     * <p>
     * Name of the source table that is being restored.
     * </p>
     * 
     * @return Name of the source table that is being restored.
     */
    public String sourceTableName() {
        return sourceTableName;
    }

    /**
     * <p>
     * The name of the new table to which it must be restored to.
     * </p>
     * 
     * @return The name of the new table to which it must be restored to.
     */
    public String targetTableName() {
        return targetTableName;
    }

    /**
     * <p>
     * Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5 minutes
     * before the current time.
     * </p>
     * 
     * @return Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5
     *         minutes before the current time.
     */
    public Boolean useLatestRestorableTime() {
        return useLatestRestorableTime;
    }

    /**
     * <p>
     * Time in the past to restore the table to.
     * </p>
     * 
     * @return Time in the past to restore the table to.
     */
    public Instant restoreDateTime() {
        return restoreDateTime;
    }

    /**
     * <p>
     * The billing mode of the restored table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #billingModeOverride} will return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #billingModeOverrideAsString}.
     * </p>
     * 
     * @return The billing mode of the restored table.
     * @see BillingMode
     */
    public BillingMode billingModeOverride() {
        return BillingMode.fromValue(billingModeOverride);
    }

    /**
     * <p>
     * The billing mode of the restored table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #billingModeOverride} will return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #billingModeOverrideAsString}.
     * </p>
     * 
     * @return The billing mode of the restored table.
     * @see BillingMode
     */
    public String billingModeOverrideAsString() {
        return billingModeOverride;
    }

    /**
     * Returns true if the GlobalSecondaryIndexOverride property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasGlobalSecondaryIndexOverride() {
        return globalSecondaryIndexOverride != null && !(globalSecondaryIndexOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of global secondary indexes for the restored table. The indexes provided should match existing secondary
     * indexes. You can choose to exclude some or all of the indexes at the time of restore.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalSecondaryIndexOverride()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of global secondary indexes for the restored table. The indexes provided should match existing
     *         secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
     */
    public List<GlobalSecondaryIndex> globalSecondaryIndexOverride() {
        return globalSecondaryIndexOverride;
    }

    /**
     * Returns true if the LocalSecondaryIndexOverride property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasLocalSecondaryIndexOverride() {
        return localSecondaryIndexOverride != null && !(localSecondaryIndexOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of local secondary indexes for the restored table. The indexes provided should match existing secondary
     * indexes. You can choose to exclude some or all of the indexes at the time of restore.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLocalSecondaryIndexOverride()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of local secondary indexes for the restored table. The indexes provided should match existing
     *         secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
     */
    public List<LocalSecondaryIndex> localSecondaryIndexOverride() {
        return localSecondaryIndexOverride;
    }

    /**
     * <p>
     * Provisioned throughput settings for the restored table.
     * </p>
     * 
     * @return Provisioned throughput settings for the restored table.
     */
    public ProvisionedThroughput provisionedThroughputOverride() {
        return provisionedThroughputOverride;
    }

    /**
     * <p>
     * The new server-side encryption settings for the restored table.
     * </p>
     * 
     * @return The new server-side encryption settings for the restored table.
     */
    public SSESpecification sseSpecificationOverride() {
        return sseSpecificationOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(restoreDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(billingModeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(globalSecondaryIndexOverride());
        hashCode = 31 * hashCode + Objects.hashCode(localSecondaryIndexOverride());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecificationOverride());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableToPointInTimeRequest)) {
            return false;
        }
        RestoreTableToPointInTimeRequest other = (RestoreTableToPointInTimeRequest) obj;
        return Objects.equals(sourceTableArn(), other.sourceTableArn())
                && Objects.equals(sourceTableName(), other.sourceTableName())
                && Objects.equals(targetTableName(), other.targetTableName())
                && Objects.equals(useLatestRestorableTime(), other.useLatestRestorableTime())
                && Objects.equals(restoreDateTime(), other.restoreDateTime())
                && Objects.equals(billingModeOverrideAsString(), other.billingModeOverrideAsString())
                && Objects.equals(globalSecondaryIndexOverride(), other.globalSecondaryIndexOverride())
                && Objects.equals(localSecondaryIndexOverride(), other.localSecondaryIndexOverride())
                && Objects.equals(provisionedThroughputOverride(), other.provisionedThroughputOverride())
                && Objects.equals(sseSpecificationOverride(), other.sseSpecificationOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RestoreTableToPointInTimeRequest").add("SourceTableArn", sourceTableArn())
                .add("SourceTableName", sourceTableName()).add("TargetTableName", targetTableName())
                .add("UseLatestRestorableTime", useLatestRestorableTime()).add("RestoreDateTime", restoreDateTime())
                .add("BillingModeOverride", billingModeOverrideAsString())
                .add("GlobalSecondaryIndexOverride", globalSecondaryIndexOverride())
                .add("LocalSecondaryIndexOverride", localSecondaryIndexOverride())
                .add("ProvisionedThroughputOverride", provisionedThroughputOverride())
                .add("SSESpecificationOverride", sseSpecificationOverride()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceTableArn":
            return Optional.ofNullable(clazz.cast(sourceTableArn()));
        case "SourceTableName":
            return Optional.ofNullable(clazz.cast(sourceTableName()));
        case "TargetTableName":
            return Optional.ofNullable(clazz.cast(targetTableName()));
        case "UseLatestRestorableTime":
            return Optional.ofNullable(clazz.cast(useLatestRestorableTime()));
        case "RestoreDateTime":
            return Optional.ofNullable(clazz.cast(restoreDateTime()));
        case "BillingModeOverride":
            return Optional.ofNullable(clazz.cast(billingModeOverrideAsString()));
        case "GlobalSecondaryIndexOverride":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexOverride()));
        case "LocalSecondaryIndexOverride":
            return Optional.ofNullable(clazz.cast(localSecondaryIndexOverride()));
        case "ProvisionedThroughputOverride":
            return Optional.ofNullable(clazz.cast(provisionedThroughputOverride()));
        case "SSESpecificationOverride":
            return Optional.ofNullable(clazz.cast(sseSpecificationOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableToPointInTimeRequest, T> g) {
        return obj -> g.apply((RestoreTableToPointInTimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreTableToPointInTimeRequest> {
        /**
         * <p>
         * The DynamoDB table that will be restored. This value is an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param sourceTableArn
         *        The DynamoDB table that will be restored. This value is an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableArn(String sourceTableArn);

        /**
         * <p>
         * Name of the source table that is being restored.
         * </p>
         * 
         * @param sourceTableName
         *        Name of the source table that is being restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableName(String sourceTableName);

        /**
         * <p>
         * The name of the new table to which it must be restored to.
         * </p>
         * 
         * @param targetTableName
         *        The name of the new table to which it must be restored to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTableName(String targetTableName);

        /**
         * <p>
         * Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5 minutes
         * before the current time.
         * </p>
         * 
         * @param useLatestRestorableTime
         *        Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5
         *        minutes before the current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLatestRestorableTime(Boolean useLatestRestorableTime);

        /**
         * <p>
         * Time in the past to restore the table to.
         * </p>
         * 
         * @param restoreDateTime
         *        Time in the past to restore the table to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreDateTime(Instant restoreDateTime);

        /**
         * <p>
         * The billing mode of the restored table.
         * </p>
         * 
         * @param billingModeOverride
         *        The billing mode of the restored table.
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingModeOverride(String billingModeOverride);

        /**
         * <p>
         * The billing mode of the restored table.
         * </p>
         * 
         * @param billingModeOverride
         *        The billing mode of the restored table.
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingModeOverride(BillingMode billingModeOverride);

        /**
         * <p>
         * List of global secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * 
         * @param globalSecondaryIndexOverride
         *        List of global secondary indexes for the restored table. The indexes provided should match existing
         *        secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexOverride(Collection<GlobalSecondaryIndex> globalSecondaryIndexOverride);

        /**
         * <p>
         * List of global secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * 
         * @param globalSecondaryIndexOverride
         *        List of global secondary indexes for the restored table. The indexes provided should match existing
         *        secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexOverride(GlobalSecondaryIndex... globalSecondaryIndexOverride);

        /**
         * <p>
         * List of global secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GlobalSecondaryIndex>.Builder} avoiding the
         * need to create one manually via {@link List<GlobalSecondaryIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlobalSecondaryIndex>.Builder#build()} is called immediately
         * and its result is passed to {@link #globalSecondaryIndexOverride(List<GlobalSecondaryIndex>)}.
         * 
         * @param globalSecondaryIndexOverride
         *        a consumer that will call methods on {@link List<GlobalSecondaryIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexOverride(List<GlobalSecondaryIndex>)
         */
        Builder globalSecondaryIndexOverride(Consumer<GlobalSecondaryIndex.Builder>... globalSecondaryIndexOverride);

        /**
         * <p>
         * List of local secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * 
         * @param localSecondaryIndexOverride
         *        List of local secondary indexes for the restored table. The indexes provided should match existing
         *        secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexOverride(Collection<LocalSecondaryIndex> localSecondaryIndexOverride);

        /**
         * <p>
         * List of local secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * 
         * @param localSecondaryIndexOverride
         *        List of local secondary indexes for the restored table. The indexes provided should match existing
         *        secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexOverride(LocalSecondaryIndex... localSecondaryIndexOverride);

        /**
         * <p>
         * List of local secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LocalSecondaryIndex>.Builder} avoiding the
         * need to create one manually via {@link List<LocalSecondaryIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocalSecondaryIndex>.Builder#build()} is called immediately
         * and its result is passed to {@link #localSecondaryIndexOverride(List<LocalSecondaryIndex>)}.
         * 
         * @param localSecondaryIndexOverride
         *        a consumer that will call methods on {@link List<LocalSecondaryIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localSecondaryIndexOverride(List<LocalSecondaryIndex>)
         */
        Builder localSecondaryIndexOverride(Consumer<LocalSecondaryIndex.Builder>... localSecondaryIndexOverride);

        /**
         * <p>
         * Provisioned throughput settings for the restored table.
         * </p>
         * 
         * @param provisionedThroughputOverride
         *        Provisioned throughput settings for the restored table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputOverride(ProvisionedThroughput provisionedThroughputOverride);

        /**
         * <p>
         * Provisioned throughput settings for the restored table.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding the need
         * to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughputOverride(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughputOverride
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughputOverride(ProvisionedThroughput)
         */
        default Builder provisionedThroughputOverride(Consumer<ProvisionedThroughput.Builder> provisionedThroughputOverride) {
            return provisionedThroughputOverride(ProvisionedThroughput.builder().applyMutation(provisionedThroughputOverride)
                    .build());
        }

        /**
         * <p>
         * The new server-side encryption settings for the restored table.
         * </p>
         * 
         * @param sseSpecificationOverride
         *        The new server-side encryption settings for the restored table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecificationOverride(SSESpecification sseSpecificationOverride);

        /**
         * <p>
         * The new server-side encryption settings for the restored table.
         * </p>
         * This is a convenience that creates an instance of the {@link SSESpecification.Builder} avoiding the need to
         * create one manually via {@link SSESpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link SSESpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #sseSpecificationOverride(SSESpecification)}.
         * 
         * @param sseSpecificationOverride
         *        a consumer that will call methods on {@link SSESpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecificationOverride(SSESpecification)
         */
        default Builder sseSpecificationOverride(Consumer<SSESpecification.Builder> sseSpecificationOverride) {
            return sseSpecificationOverride(SSESpecification.builder().applyMutation(sseSpecificationOverride).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String sourceTableArn;

        private String sourceTableName;

        private String targetTableName;

        private Boolean useLatestRestorableTime;

        private Instant restoreDateTime;

        private String billingModeOverride;

        private List<GlobalSecondaryIndex> globalSecondaryIndexOverride = DefaultSdkAutoConstructList.getInstance();

        private List<LocalSecondaryIndex> localSecondaryIndexOverride = DefaultSdkAutoConstructList.getInstance();

        private ProvisionedThroughput provisionedThroughputOverride;

        private SSESpecification sseSpecificationOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableToPointInTimeRequest model) {
            super(model);
            sourceTableArn(model.sourceTableArn);
            sourceTableName(model.sourceTableName);
            targetTableName(model.targetTableName);
            useLatestRestorableTime(model.useLatestRestorableTime);
            restoreDateTime(model.restoreDateTime);
            billingModeOverride(model.billingModeOverride);
            globalSecondaryIndexOverride(model.globalSecondaryIndexOverride);
            localSecondaryIndexOverride(model.localSecondaryIndexOverride);
            provisionedThroughputOverride(model.provisionedThroughputOverride);
            sseSpecificationOverride(model.sseSpecificationOverride);
        }

        public final String getSourceTableArn() {
            return sourceTableArn;
        }

        @Override
        public final Builder sourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
            return this;
        }

        public final void setSourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
        }

        public final String getSourceTableName() {
            return sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        public final String getTargetTableName() {
            return targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        public final Boolean getUseLatestRestorableTime() {
            return useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        public final Instant getRestoreDateTime() {
            return restoreDateTime;
        }

        @Override
        public final Builder restoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
            return this;
        }

        public final void setRestoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
        }

        public final String getBillingModeOverride() {
            return billingModeOverride;
        }

        @Override
        public final Builder billingModeOverride(String billingModeOverride) {
            this.billingModeOverride = billingModeOverride;
            return this;
        }

        @Override
        public final Builder billingModeOverride(BillingMode billingModeOverride) {
            this.billingModeOverride(billingModeOverride == null ? null : billingModeOverride.toString());
            return this;
        }

        public final void setBillingModeOverride(String billingModeOverride) {
            this.billingModeOverride = billingModeOverride;
        }

        public final Collection<GlobalSecondaryIndex.Builder> getGlobalSecondaryIndexOverride() {
            return globalSecondaryIndexOverride != null ? globalSecondaryIndexOverride.stream()
                    .map(GlobalSecondaryIndex::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexOverride(Collection<GlobalSecondaryIndex> globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexOverride(GlobalSecondaryIndex... globalSecondaryIndexOverride) {
            globalSecondaryIndexOverride(Arrays.asList(globalSecondaryIndexOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexOverride(Consumer<GlobalSecondaryIndex.Builder>... globalSecondaryIndexOverride) {
            globalSecondaryIndexOverride(Stream.of(globalSecondaryIndexOverride)
                    .map(c -> GlobalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexOverride(
                Collection<GlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride = GlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexOverride);
        }

        public final Collection<LocalSecondaryIndex.Builder> getLocalSecondaryIndexOverride() {
            return localSecondaryIndexOverride != null ? localSecondaryIndexOverride.stream().map(LocalSecondaryIndex::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localSecondaryIndexOverride(Collection<LocalSecondaryIndex> localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride = LocalSecondaryIndexListCopier.copy(localSecondaryIndexOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexOverride(LocalSecondaryIndex... localSecondaryIndexOverride) {
            localSecondaryIndexOverride(Arrays.asList(localSecondaryIndexOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexOverride(Consumer<LocalSecondaryIndex.Builder>... localSecondaryIndexOverride) {
            localSecondaryIndexOverride(Stream.of(localSecondaryIndexOverride)
                    .map(c -> LocalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalSecondaryIndexOverride(Collection<LocalSecondaryIndex.BuilderImpl> localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride = LocalSecondaryIndexListCopier.copyFromBuilder(localSecondaryIndexOverride);
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughputOverride() {
            return provisionedThroughputOverride != null ? provisionedThroughputOverride.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughput provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughput.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build()
                    : null;
        }

        public final SSESpecification.Builder getSseSpecificationOverride() {
            return sseSpecificationOverride != null ? sseSpecificationOverride.toBuilder() : null;
        }

        @Override
        public final Builder sseSpecificationOverride(SSESpecification sseSpecificationOverride) {
            this.sseSpecificationOverride = sseSpecificationOverride;
            return this;
        }

        public final void setSseSpecificationOverride(SSESpecification.BuilderImpl sseSpecificationOverride) {
            this.sseSpecificationOverride = sseSpecificationOverride != null ? sseSpecificationOverride.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableToPointInTimeRequest build() {
            return new RestoreTableToPointInTimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
