/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about an export task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportSummary implements SdkPojo, Serializable, ToCopyableBuilder<ExportSummary.Builder, ExportSummary> {
    private static final SdkField<String> EXPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportArn").getter(getter(ExportSummary::exportArn)).setter(setter(Builder::exportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArn").build()).build();

    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportStatus").getter(getter(ExportSummary::exportStatusAsString)).setter(setter(Builder::exportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ARN_FIELD,
            EXPORT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exportArn;

    private final String exportStatus;

    private ExportSummary(BuilderImpl builder) {
        this.exportArn = builder.exportArn;
        this.exportStatus = builder.exportStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the export.
     */
    public String exportArn() {
        return exportArn;
    }

    /**
     * <p>
     * Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
     * @see ExportStatus
     */
    public ExportStatus exportStatus() {
        return ExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
     * @see ExportStatus
     */
    public String exportStatusAsString() {
        return exportStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSummary)) {
            return false;
        }
        ExportSummary other = (ExportSummary) obj;
        return Objects.equals(exportArn(), other.exportArn())
                && Objects.equals(exportStatusAsString(), other.exportStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportSummary").add("ExportArn", exportArn()).add("ExportStatus", exportStatusAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportArn":
            return Optional.ofNullable(clazz.cast(exportArn()));
        case "ExportStatus":
            return Optional.ofNullable(clazz.cast(exportStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportSummary, T> g) {
        return obj -> g.apply((ExportSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the export.
         * </p>
         * 
         * @param exportArn
         *        The Amazon Resource Name (ARN) of the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportArn(String exportArn);

        /**
         * <p>
         * Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
         * </p>
         * 
         * @param exportStatus
         *        Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
         * </p>
         * 
         * @param exportStatus
         *        Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(ExportStatus exportStatus);
    }

    static final class BuilderImpl implements Builder {
        private String exportArn;

        private String exportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSummary model) {
            exportArn(model.exportArn);
            exportStatus(model.exportStatus);
        }

        public final String getExportArn() {
            return exportArn;
        }

        @Override
        public final Builder exportArn(String exportArn) {
            this.exportArn = exportArn;
            return this;
        }

        public final void setExportArn(String exportArn) {
            this.exportArn = exportArn;
        }

        public final String getExportStatus() {
            return exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public ExportSummary build() {
            return new ExportSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
