/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an <code>UpdateItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateItemRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateItemRequest.Builder, UpdateItemRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(UpdateItemRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Map<String, AttributeValue>> KEY_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("Key")
            .getter(getter(UpdateItemRequest::key))
            .setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeValueUpdate>> ATTRIBUTE_UPDATES_FIELD = SdkField
            .<Map<String, AttributeValueUpdate>> builder(MarshallingType.MAP)
            .memberName("AttributeUpdates")
            .getter(getter(UpdateItemRequest::attributeUpdates))
            .setter(setter(Builder::attributeUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValueUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValueUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ExpectedAttributeValue>> EXPECTED_FIELD = SdkField
            .<Map<String, ExpectedAttributeValue>> builder(MarshallingType.MAP)
            .memberName("Expected")
            .getter(getter(UpdateItemRequest::expected))
            .setter(setter(Builder::expected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expected").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ExpectedAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpectedAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONDITIONAL_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionalOperator").getter(getter(UpdateItemRequest::conditionalOperatorAsString))
            .setter(setter(Builder::conditionalOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalOperator").build())
            .build();

    private static final SdkField<String> RETURN_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReturnValues").getter(getter(UpdateItemRequest::returnValuesAsString))
            .setter(setter(Builder::returnValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnValues").build()).build();

    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReturnConsumedCapacity").getter(getter(UpdateItemRequest::returnConsumedCapacityAsString))
            .setter(setter(Builder::returnConsumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build())
            .build();

    private static final SdkField<String> RETURN_ITEM_COLLECTION_METRICS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReturnItemCollectionMetrics")
            .getter(getter(UpdateItemRequest::returnItemCollectionMetricsAsString))
            .setter(setter(Builder::returnItemCollectionMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnItemCollectionMetrics")
                    .build()).build();

    private static final SdkField<String> UPDATE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateExpression").getter(getter(UpdateItemRequest::updateExpression))
            .setter(setter(Builder::updateExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateExpression").build()).build();

    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionExpression").getter(getter(UpdateItemRequest::conditionExpression))
            .setter(setter(Builder::conditionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpression").build())
            .build();

    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ExpressionAttributeNames")
            .getter(getter(UpdateItemRequest::expressionAttributeNames))
            .setter(setter(Builder::expressionAttributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("ExpressionAttributeValues")
            .getter(getter(UpdateItemRequest::expressionAttributeValues))
            .setter(setter(Builder::expressionAttributeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, KEY_FIELD,
            ATTRIBUTE_UPDATES_FIELD, EXPECTED_FIELD, CONDITIONAL_OPERATOR_FIELD, RETURN_VALUES_FIELD,
            RETURN_CONSUMED_CAPACITY_FIELD, RETURN_ITEM_COLLECTION_METRICS_FIELD, UPDATE_EXPRESSION_FIELD,
            CONDITION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD, EXPRESSION_ATTRIBUTE_VALUES_FIELD));

    private final String tableName;

    private final Map<String, AttributeValue> key;

    private final Map<String, AttributeValueUpdate> attributeUpdates;

    private final Map<String, ExpectedAttributeValue> expected;

    private final String conditionalOperator;

    private final String returnValues;

    private final String returnConsumedCapacity;

    private final String returnItemCollectionMetrics;

    private final String updateExpression;

    private final String conditionExpression;

    private final Map<String, String> expressionAttributeNames;

    private final Map<String, AttributeValue> expressionAttributeValues;

    private UpdateItemRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.key = builder.key;
        this.attributeUpdates = builder.attributeUpdates;
        this.expected = builder.expected;
        this.conditionalOperator = builder.conditionalOperator;
        this.returnValues = builder.returnValues;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
        this.updateExpression = builder.updateExpression;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    /**
     * <p>
     * The name of the table containing the item to update.
     * </p>
     * 
     * @return The name of the table containing the item to update.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * Returns true if the Key property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKey() {
        return key != null && !(key instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The primary key of the item to be updated. Each element consists of an attribute name and a value for that
     * attribute.
     * </p>
     * <p>
     * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only
     * need to provide a value for the partition key. For a composite primary key, you must provide values for both the
     * partition key and the sort key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKey()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The primary key of the item to be updated. Each element consists of an attribute name and a value for
     *         that attribute.</p>
     *         <p>
     *         For the primary key, you must provide all of the attributes. For example, with a simple primary key, you
     *         only need to provide a value for the partition key. For a composite primary key, you must provide values
     *         for both the partition key and the sort key.
     */
    public Map<String, AttributeValue> key() {
        return key;
    }

    /**
     * Returns true if the AttributeUpdates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAttributeUpdates() {
        return attributeUpdates != null && !(attributeUpdates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html"
     * >AttributeUpdates</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributeUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html"
     *         >AttributeUpdates</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, AttributeValueUpdate> attributeUpdates() {
        return attributeUpdates;
    }

    /**
     * Returns true if the Expected property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExpected() {
        return expected != null && !(expected instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
     * >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExpected()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
     *         >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, ExpectedAttributeValue> expected() {
        return expected;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conditionalOperator} will return {@link ConditionalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conditionalOperatorAsString}.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     *         >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @see ConditionalOperator
     */
    public ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(conditionalOperator);
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conditionalOperator} will return {@link ConditionalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conditionalOperatorAsString}.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     *         >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @see ConditionalOperator
     */
    public String conditionalOperatorAsString() {
        return conditionalOperator;
    }

    /**
     * <p>
     * Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after they are
     * updated. For <code>UpdateItem</code>, the valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
     * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * There is no additional cost associated with requesting a return value aside from the small network and processing
     * overhead of receiving a larger response. No read capacity units are consumed.
     * </p>
     * <p>
     * The values returned are strongly consistent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #returnValues} will
     * return {@link ReturnValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #returnValuesAsString}.
     * </p>
     * 
     * @return Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after they
     *         are updated. For <code>UpdateItem</code>, the valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>,
     *         then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem
     *         operation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         There is no additional cost associated with requesting a return value aside from the small network and
     *         processing overhead of receiving a larger response. No read capacity units are consumed.
     *         </p>
     *         <p>
     *         The values returned are strongly consistent.
     * @see ReturnValue
     */
    public ReturnValue returnValues() {
        return ReturnValue.fromValue(returnValues);
    }

    /**
     * <p>
     * Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after they are
     * updated. For <code>UpdateItem</code>, the valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
     * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * There is no additional cost associated with requesting a return value aside from the small network and processing
     * overhead of receiving a larger response. No read capacity units are consumed.
     * </p>
     * <p>
     * The values returned are strongly consistent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #returnValues} will
     * return {@link ReturnValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #returnValuesAsString}.
     * </p>
     * 
     * @return Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after they
     *         are updated. For <code>UpdateItem</code>, the valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>,
     *         then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem
     *         operation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         There is no additional cost associated with requesting a return value aside from the small network and
     *         processing overhead of receiving a larger response. No read capacity units are consumed.
     *         </p>
     *         <p>
     *         The values returned are strongly consistent.
     * @see ReturnValue
     */
    public String returnValuesAsString() {
        return returnValues;
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(returnConsumedCapacity);
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public String returnConsumedCapacityAsString() {
        return returnConsumedCapacity;
    }

    /**
     * <p>
     * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
     * statistics about item collections, if any, that were modified during the operation are returned in the response.
     * If set to <code>NONE</code> (the default), no statistics are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnItemCollectionMetrics} will return {@link ReturnItemCollectionMetrics#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #returnItemCollectionMetricsAsString}.
     * </p>
     * 
     * @return Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
     *         includes statistics about item collections, if any, that were modified during the operation are returned
     *         in the response. If set to <code>NONE</code> (the default), no statistics are returned.
     * @see ReturnItemCollectionMetrics
     */
    public ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue(returnItemCollectionMetrics);
    }

    /**
     * <p>
     * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
     * statistics about item collections, if any, that were modified during the operation are returned in the response.
     * If set to <code>NONE</code> (the default), no statistics are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnItemCollectionMetrics} will return {@link ReturnItemCollectionMetrics#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #returnItemCollectionMetricsAsString}.
     * </p>
     * 
     * @return Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
     *         includes statistics about item collections, if any, that were modified during the operation are returned
     *         in the response. If set to <code>NONE</code> (the default), no statistics are returned.
     * @see ReturnItemCollectionMetrics
     */
    public String returnItemCollectionMetricsAsString() {
        return returnItemCollectionMetrics;
    }

    /**
     * <p>
     * An expression that defines one or more attributes to be updated, the action to be performed on them, and new
     * values for them.
     * </p>
     * <p>
     * The following action values are available for <code>UpdateExpression</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SET</code> - Adds one or more attributes and values to an item. If any of these attributes already exist,
     * they are replaced by the new values. You can also use <code>SET</code> to add or subtract from an attribute that
     * is of type Number. For example: <code>SET myNum = myNum + :val</code>
     * </p>
     * <p>
     * <code>SET</code> supports the following functions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>if_not_exists (path, operand)</code> - if the item does not contain an attribute at the specified path,
     * then <code>if_not_exists</code> evaluates to operand; otherwise, it evaluates to path. You can use this function
     * to avoid overwriting an attribute that may already be present in the item.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>list_append (operand, operand)</code> - evaluates to a list with a new element added to it. You can append
     * the new element to the start or the end of the list by reversing the order of the operands.
     * </p>
     * </li>
     * </ul>
     * <p>
     * These function names are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVE</code> - Removes one or more attributes from an item.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADD</code> - Adds the specified value to the item, if the attribute does not already exist. If the
     * attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the existing attribute is a number, and if <code>Value</code> is also a number, then <code>Value</code> is
     * mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is subtracted
     * from the existing attribute.
     * </p>
     * <note>
     * <p>
     * If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist before the
     * update, DynamoDB uses <code>0</code> as the initial value.
     * </p>
     * <p>
     * Similarly, if you use <code>ADD</code> for an existing item to increment or decrement an attribute value that
     * doesn't exist before the update, DynamoDB uses <code>0</code> as the initial value. For example, suppose that the
     * item you want to update doesn't have an attribute named <code>itemcount</code>, but you decide to
     * <code>ADD</code> the number <code>3</code> to this attribute anyway. DynamoDB will create the
     * <code>itemcount</code> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to it.
     * The result will be a new <code>itemcount</code> attribute in the item, with a value of <code>3</code>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * If the existing data type is a set and if <code>Value</code> is also a set, then <code>Value</code> is added to
     * the existing set. For example, if the attribute value is the set <code>[1,2]</code>, and the <code>ADD</code>
     * action specified <code>[3]</code>, then the final attribute value is <code>[1,2,3]</code>. An error occurs if an
     * <code>ADD</code> action is specified for a set attribute and the attribute type specified does not match the
     * existing set type.
     * </p>
     * <p>
     * Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the
     * <code>Value</code> must also be a set of strings.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * The <code>ADD</code> action only supports Number and set data types. In addition, <code>ADD</code> can only be
     * used on top-level attributes, not nested attributes.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>DELETE</code> - Deletes an element from a set.
     * </p>
     * <p>
     * If a set of values is specified, then those values are subtracted from the old set. For example, if the attribute
     * value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specifies <code>[a,c]</code>, then the
     * final attribute value is <code>[b]</code>. Specifying an empty set is an error.
     * </p>
     * <important>
     * <p>
     * The <code>DELETE</code> action only supports set data types. In addition, <code>DELETE</code> can only be used on
     * top-level attributes, not nested attributes.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * You can have many actions in a single expression, such as the following:
     * <code>SET a=:value1, b=:value2 DELETE :value3, :value4, :value5</code>
     * </p>
     * <p>
     * For more information on update expressions, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying
     * Items and Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return An expression that defines one or more attributes to be updated, the action to be performed on them, and
     *         new values for them.</p>
     *         <p>
     *         The following action values are available for <code>UpdateExpression</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SET</code> - Adds one or more attributes and values to an item. If any of these attributes already
     *         exist, they are replaced by the new values. You can also use <code>SET</code> to add or subtract from an
     *         attribute that is of type Number. For example: <code>SET myNum = myNum + :val</code>
     *         </p>
     *         <p>
     *         <code>SET</code> supports the following functions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>if_not_exists (path, operand)</code> - if the item does not contain an attribute at the specified
     *         path, then <code>if_not_exists</code> evaluates to operand; otherwise, it evaluates to path. You can use
     *         this function to avoid overwriting an attribute that may already be present in the item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>list_append (operand, operand)</code> - evaluates to a list with a new element added to it. You can
     *         append the new element to the start or the end of the list by reversing the order of the operands.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         These function names are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVE</code> - Removes one or more attributes from an item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADD</code> - Adds the specified value to the item, if the attribute does not already exist. If the
     *         attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the existing attribute is a number, and if <code>Value</code> is also a number, then
     *         <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a negative
     *         number, then it is subtracted from the existing attribute.
     *         </p>
     *         <note>
     *         <p>
     *         If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist
     *         before the update, DynamoDB uses <code>0</code> as the initial value.
     *         </p>
     *         <p>
     *         Similarly, if you use <code>ADD</code> for an existing item to increment or decrement an attribute value
     *         that doesn't exist before the update, DynamoDB uses <code>0</code> as the initial value. For example,
     *         suppose that the item you want to update doesn't have an attribute named <code>itemcount</code>, but you
     *         decide to <code>ADD</code> the number <code>3</code> to this attribute anyway. DynamoDB will create the
     *         <code>itemcount</code> attribute, set its initial value to <code>0</code>, and finally add <code>3</code>
     *         to it. The result will be a new <code>itemcount</code> attribute in the item, with a value of
     *         <code>3</code>.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         If the existing data type is a set and if <code>Value</code> is also a set, then <code>Value</code> is
     *         added to the existing set. For example, if the attribute value is the set <code>[1,2]</code>, and the
     *         <code>ADD</code> action specified <code>[3]</code>, then the final attribute value is
     *         <code>[1,2,3]</code>. An error occurs if an <code>ADD</code> action is specified for a set attribute and
     *         the attribute type specified does not match the existing set type.
     *         </p>
     *         <p>
     *         Both sets must have the same primitive data type. For example, if the existing data type is a set of
     *         strings, the <code>Value</code> must also be a set of strings.
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         The <code>ADD</code> action only supports Number and set data types. In addition, <code>ADD</code> can
     *         only be used on top-level attributes, not nested attributes.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>DELETE</code> - Deletes an element from a set.
     *         </p>
     *         <p>
     *         If a set of values is specified, then those values are subtracted from the old set. For example, if the
     *         attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specifies
     *         <code>[a,c]</code>, then the final attribute value is <code>[b]</code>. Specifying an empty set is an
     *         error.
     *         </p>
     *         <important>
     *         <p>
     *         The <code>DELETE</code> action only supports set data types. In addition, <code>DELETE</code> can only be
     *         used on top-level attributes, not nested attributes.
     *         </p>
     *         </important></li>
     *         </ul>
     *         <p>
     *         You can have many actions in a single expression, such as the following:
     *         <code>SET a=:value1, b=:value2 DELETE :value3, :value4, :value5</code>
     *         </p>
     *         <p>
     *         For more information on update expressions, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html"
     *         >Modifying Items and Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String updateExpression() {
        return updateExpression;
    }

    /**
     * <p>
     * A condition that must be satisfied in order for a conditional update to succeed.
     * </p>
     * <p>
     * An expression can contain any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
     * </p>
     * <p>
     * These function names are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Logical operators: <code>AND | OR | NOT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about condition expressions, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return A condition that must be satisfied in order for a conditional update to succeed.</p>
     *         <p>
     *         An expression can contain any of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Functions:
     *         <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
     *         </p>
     *         <p>
     *         These function names are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Logical operators: <code>AND | OR | NOT</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about condition expressions, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     *         >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String conditionExpression() {
        return conditionExpression;
    }

    /**
     * Returns true if the ExpressionAttributeNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExpressionAttributeNames() {
        return expressionAttributeNames != null && !(expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To access an attribute whose name conflicts with a DynamoDB reserved word.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a placeholder for repeating occurrences of an attribute name in an expression.
     * </p>
     * </li>
     * <li>
     * <p>
     * To prevent special characters in an attribute name from being misinterpreted in an expression.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following
     * attribute name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Percentile</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For
     * the complete list of reserved words, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.) To work around this, you could specify the following for
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>{"#P":"Percentile"}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You could then use this substitution in an expression, as in this example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#P = :val</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for
     * the actual value at runtime.
     * </p>
     * </note>
     * <p>
     * For more information about expression attribute names, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExpressionAttributeNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more substitution tokens for attribute names in an expression. The following are some use cases
     *         for using <code>ExpressionAttributeNames</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To access an attribute whose name conflicts with a DynamoDB reserved word.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a placeholder for repeating occurrences of an attribute name in an expression.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To prevent special characters in an attribute name from being misinterpreted in an expression.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
     *         following attribute name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Percentile</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
     *         expression. (For the complete list of reserved words, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
     *         Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.) To work around this, you could specify the
     *         following for <code>ExpressionAttributeNames</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>{"#P":"Percentile"}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You could then use this substitution in an expression, as in this example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#P = :val</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
     *         placeholders for the actual value at runtime.
     *         </p>
     *         </note>
     *         <p>
     *         For more information about expression attribute names, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, String> expressionAttributeNames() {
        return expressionAttributeNames;
    }

    /**
     * Returns true if the ExpressionAttributeValues property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExpressionAttributeValues() {
        return expressionAttributeValues != null && !(expressionAttributeValues instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more values that can be substituted in an expression.
     * </p>
     * <p>
     * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that
     * you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of the following:
     * </p>
     * <p>
     * <code>Available | Backordered | Discontinued</code>
     * </p>
     * <p>
     * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     * </p>
     * <p>
     * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     * </p>
     * <p>
     * You could then use these values in an expression, such as this:
     * </p>
     * <p>
     * <code>ProductStatus IN (:avail, :back, :disc)</code>
     * </p>
     * <p>
     * For more information on expression attribute values, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     * >Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExpressionAttributeValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more values that can be substituted in an expression.</p>
     *         <p>
     *         Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
     *         suppose that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of
     *         the following:
     *         </p>
     *         <p>
     *         <code>Available | Backordered | Discontinued</code>
     *         </p>
     *         <p>
     *         You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     *         </p>
     *         <p>
     *         <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     *         </p>
     *         <p>
     *         You could then use these values in an expression, such as this:
     *         </p>
     *         <p>
     *         <code>ProductStatus IN (:avail, :back, :disc)</code>
     *         </p>
     *         <p>
     *         For more information on expression attribute values, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     *         >Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, AttributeValue> expressionAttributeValues() {
        return expressionAttributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(attributeUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(expected());
        hashCode = 31 * hashCode + Objects.hashCode(conditionalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(returnValuesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(returnItemCollectionMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateExpression());
        hashCode = 31 * hashCode + Objects.hashCode(conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateItemRequest)) {
            return false;
        }
        UpdateItemRequest other = (UpdateItemRequest) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(key(), other.key())
                && Objects.equals(attributeUpdates(), other.attributeUpdates()) && Objects.equals(expected(), other.expected())
                && Objects.equals(conditionalOperatorAsString(), other.conditionalOperatorAsString())
                && Objects.equals(returnValuesAsString(), other.returnValuesAsString())
                && Objects.equals(returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString())
                && Objects.equals(returnItemCollectionMetricsAsString(), other.returnItemCollectionMetricsAsString())
                && Objects.equals(updateExpression(), other.updateExpression())
                && Objects.equals(conditionExpression(), other.conditionExpression())
                && Objects.equals(expressionAttributeNames(), other.expressionAttributeNames())
                && Objects.equals(expressionAttributeValues(), other.expressionAttributeValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateItemRequest").add("TableName", tableName()).add("Key", key())
                .add("AttributeUpdates", attributeUpdates()).add("Expected", expected())
                .add("ConditionalOperator", conditionalOperatorAsString()).add("ReturnValues", returnValuesAsString())
                .add("ReturnConsumedCapacity", returnConsumedCapacityAsString())
                .add("ReturnItemCollectionMetrics", returnItemCollectionMetricsAsString())
                .add("UpdateExpression", updateExpression()).add("ConditionExpression", conditionExpression())
                .add("ExpressionAttributeNames", expressionAttributeNames())
                .add("ExpressionAttributeValues", expressionAttributeValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "AttributeUpdates":
            return Optional.ofNullable(clazz.cast(attributeUpdates()));
        case "Expected":
            return Optional.ofNullable(clazz.cast(expected()));
        case "ConditionalOperator":
            return Optional.ofNullable(clazz.cast(conditionalOperatorAsString()));
        case "ReturnValues":
            return Optional.ofNullable(clazz.cast(returnValuesAsString()));
        case "ReturnConsumedCapacity":
            return Optional.ofNullable(clazz.cast(returnConsumedCapacityAsString()));
        case "ReturnItemCollectionMetrics":
            return Optional.ofNullable(clazz.cast(returnItemCollectionMetricsAsString()));
        case "UpdateExpression":
            return Optional.ofNullable(clazz.cast(updateExpression()));
        case "ConditionExpression":
            return Optional.ofNullable(clazz.cast(conditionExpression()));
        case "ExpressionAttributeNames":
            return Optional.ofNullable(clazz.cast(expressionAttributeNames()));
        case "ExpressionAttributeValues":
            return Optional.ofNullable(clazz.cast(expressionAttributeValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateItemRequest, T> g) {
        return obj -> g.apply((UpdateItemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateItemRequest> {
        /**
         * <p>
         * The name of the table containing the item to update.
         * </p>
         * 
         * @param tableName
         *        The name of the table containing the item to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The primary key of the item to be updated. Each element consists of an attribute name and a value for that
         * attribute.
         * </p>
         * <p>
         * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only
         * need to provide a value for the partition key. For a composite primary key, you must provide values for both
         * the partition key and the sort key.
         * </p>
         * 
         * @param key
         *        The primary key of the item to be updated. Each element consists of an attribute name and a value for
         *        that attribute.</p>
         *        <p>
         *        For the primary key, you must provide all of the attributes. For example, with a simple primary key,
         *        you only need to provide a value for the partition key. For a composite primary key, you must provide
         *        values for both the partition key and the sort key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(Map<String, AttributeValue> key);

        /**
         * <p>
         * This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html"
         * >AttributeUpdates</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param attributeUpdates
         *        This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html"
         *        >AttributeUpdates</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(Map<String, AttributeValueUpdate> attributeUpdates);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
         * >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expected
         *        This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
         *        >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expected(Map<String, ExpectedAttributeValue> expected);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @see ConditionalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(String conditionalOperator);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @see ConditionalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(ConditionalOperator conditionalOperator);

        /**
         * <p>
         * Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after they are
         * updated. For <code>UpdateItem</code>, the valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
         * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem
         * operation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * There is no additional cost associated with requesting a return value aside from the small network and
         * processing overhead of receiving a larger response. No read capacity units are consumed.
         * </p>
         * <p>
         * The values returned are strongly consistent.
         * </p>
         * 
         * @param returnValues
         *        Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after
         *        they are updated. For <code>UpdateItem</code>, the valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
         *        <code>NONE</code>, then nothing is returned. (This setting is the default for
         *        <code>ReturnValues</code>.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the
         *        UpdateItem operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem
         *        operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem
         *        operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem
         *        operation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        There is no additional cost associated with requesting a return value aside from the small network and
         *        processing overhead of receiving a larger response. No read capacity units are consumed.
         *        </p>
         *        <p>
         *        The values returned are strongly consistent.
         * @see ReturnValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValue
         */
        Builder returnValues(String returnValues);

        /**
         * <p>
         * Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after they are
         * updated. For <code>UpdateItem</code>, the valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
         * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem
         * operation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * There is no additional cost associated with requesting a return value aside from the small network and
         * processing overhead of receiving a larger response. No read capacity units are consumed.
         * </p>
         * <p>
         * The values returned are strongly consistent.
         * </p>
         * 
         * @param returnValues
         *        Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after
         *        they are updated. For <code>UpdateItem</code>, the valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
         *        <code>NONE</code>, then nothing is returned. (This setting is the default for
         *        <code>ReturnValues</code>.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the
         *        UpdateItem operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem
         *        operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem
         *        operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem
         *        operation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        There is no additional cost associated with requesting a return value aside from the small network and
         *        processing overhead of receiving a larger response. No read capacity units are consumed.
         *        </p>
         *        <p>
         *        The values returned are strongly consistent.
         * @see ReturnValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValue
         */
        Builder returnValues(ReturnValue returnValues);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections, if any, that were modified during the operation are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections, if any, that were modified during the operation are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @see ReturnItemCollectionMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(String returnItemCollectionMetrics);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections, if any, that were modified during the operation are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections, if any, that were modified during the operation are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @see ReturnItemCollectionMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics);

        /**
         * <p>
         * An expression that defines one or more attributes to be updated, the action to be performed on them, and new
         * values for them.
         * </p>
         * <p>
         * The following action values are available for <code>UpdateExpression</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SET</code> - Adds one or more attributes and values to an item. If any of these attributes already
         * exist, they are replaced by the new values. You can also use <code>SET</code> to add or subtract from an
         * attribute that is of type Number. For example: <code>SET myNum = myNum + :val</code>
         * </p>
         * <p>
         * <code>SET</code> supports the following functions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>if_not_exists (path, operand)</code> - if the item does not contain an attribute at the specified path,
         * then <code>if_not_exists</code> evaluates to operand; otherwise, it evaluates to path. You can use this
         * function to avoid overwriting an attribute that may already be present in the item.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>list_append (operand, operand)</code> - evaluates to a list with a new element added to it. You can
         * append the new element to the start or the end of the list by reversing the order of the operands.
         * </p>
         * </li>
         * </ul>
         * <p>
         * These function names are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVE</code> - Removes one or more attributes from an item.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADD</code> - Adds the specified value to the item, if the attribute does not already exist. If the
         * attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the existing attribute is a number, and if <code>Value</code> is also a number, then <code>Value</code> is
         * mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is
         * subtracted from the existing attribute.
         * </p>
         * <note>
         * <p>
         * If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist before
         * the update, DynamoDB uses <code>0</code> as the initial value.
         * </p>
         * <p>
         * Similarly, if you use <code>ADD</code> for an existing item to increment or decrement an attribute value that
         * doesn't exist before the update, DynamoDB uses <code>0</code> as the initial value. For example, suppose that
         * the item you want to update doesn't have an attribute named <code>itemcount</code>, but you decide to
         * <code>ADD</code> the number <code>3</code> to this attribute anyway. DynamoDB will create the
         * <code>itemcount</code> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to
         * it. The result will be a new <code>itemcount</code> attribute in the item, with a value of <code>3</code>.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * If the existing data type is a set and if <code>Value</code> is also a set, then <code>Value</code> is added
         * to the existing set. For example, if the attribute value is the set <code>[1,2]</code>, and the
         * <code>ADD</code> action specified <code>[3]</code>, then the final attribute value is <code>[1,2,3]</code>.
         * An error occurs if an <code>ADD</code> action is specified for a set attribute and the attribute type
         * specified does not match the existing set type.
         * </p>
         * <p>
         * Both sets must have the same primitive data type. For example, if the existing data type is a set of strings,
         * the <code>Value</code> must also be a set of strings.
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * The <code>ADD</code> action only supports Number and set data types. In addition, <code>ADD</code> can only
         * be used on top-level attributes, not nested attributes.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>DELETE</code> - Deletes an element from a set.
         * </p>
         * <p>
         * If a set of values is specified, then those values are subtracted from the old set. For example, if the
         * attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specifies
         * <code>[a,c]</code>, then the final attribute value is <code>[b]</code>. Specifying an empty set is an error.
         * </p>
         * <important>
         * <p>
         * The <code>DELETE</code> action only supports set data types. In addition, <code>DELETE</code> can only be
         * used on top-level attributes, not nested attributes.
         * </p>
         * </important></li>
         * </ul>
         * <p>
         * You can have many actions in a single expression, such as the following:
         * <code>SET a=:value1, b=:value2 DELETE :value3, :value4, :value5</code>
         * </p>
         * <p>
         * For more information on update expressions, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying
         * Items and Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param updateExpression
         *        An expression that defines one or more attributes to be updated, the action to be performed on them,
         *        and new values for them.</p>
         *        <p>
         *        The following action values are available for <code>UpdateExpression</code>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SET</code> - Adds one or more attributes and values to an item. If any of these attributes
         *        already exist, they are replaced by the new values. You can also use <code>SET</code> to add or
         *        subtract from an attribute that is of type Number. For example: <code>SET myNum = myNum + :val</code>
         *        </p>
         *        <p>
         *        <code>SET</code> supports the following functions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>if_not_exists (path, operand)</code> - if the item does not contain an attribute at the
         *        specified path, then <code>if_not_exists</code> evaluates to operand; otherwise, it evaluates to path.
         *        You can use this function to avoid overwriting an attribute that may already be present in the item.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>list_append (operand, operand)</code> - evaluates to a list with a new element added to it. You
         *        can append the new element to the start or the end of the list by reversing the order of the operands.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        These function names are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVE</code> - Removes one or more attributes from an item.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADD</code> - Adds the specified value to the item, if the attribute does not already exist. If
         *        the attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the
         *        attribute:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the existing attribute is a number, and if <code>Value</code> is also a number, then
         *        <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a
         *        negative number, then it is subtracted from the existing attribute.
         *        </p>
         *        <note>
         *        <p>
         *        If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist
         *        before the update, DynamoDB uses <code>0</code> as the initial value.
         *        </p>
         *        <p>
         *        Similarly, if you use <code>ADD</code> for an existing item to increment or decrement an attribute
         *        value that doesn't exist before the update, DynamoDB uses <code>0</code> as the initial value. For
         *        example, suppose that the item you want to update doesn't have an attribute named
         *        <code>itemcount</code>, but you decide to <code>ADD</code> the number <code>3</code> to this attribute
         *        anyway. DynamoDB will create the <code>itemcount</code> attribute, set its initial value to
         *        <code>0</code>, and finally add <code>3</code> to it. The result will be a new <code>itemcount</code>
         *        attribute in the item, with a value of <code>3</code>.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        If the existing data type is a set and if <code>Value</code> is also a set, then <code>Value</code> is
         *        added to the existing set. For example, if the attribute value is the set <code>[1,2]</code>, and the
         *        <code>ADD</code> action specified <code>[3]</code>, then the final attribute value is
         *        <code>[1,2,3]</code>. An error occurs if an <code>ADD</code> action is specified for a set attribute
         *        and the attribute type specified does not match the existing set type.
         *        </p>
         *        <p>
         *        Both sets must have the same primitive data type. For example, if the existing data type is a set of
         *        strings, the <code>Value</code> must also be a set of strings.
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        The <code>ADD</code> action only supports Number and set data types. In addition, <code>ADD</code> can
         *        only be used on top-level attributes, not nested attributes.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>DELETE</code> - Deletes an element from a set.
         *        </p>
         *        <p>
         *        If a set of values is specified, then those values are subtracted from the old set. For example, if
         *        the attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specifies
         *        <code>[a,c]</code>, then the final attribute value is <code>[b]</code>. Specifying an empty set is an
         *        error.
         *        </p>
         *        <important>
         *        <p>
         *        The <code>DELETE</code> action only supports set data types. In addition, <code>DELETE</code> can only
         *        be used on top-level attributes, not nested attributes.
         *        </p>
         *        </important></li>
         *        </ul>
         *        <p>
         *        You can have many actions in a single expression, such as the following:
         *        <code>SET a=:value1, b=:value2 DELETE :value3, :value4, :value5</code>
         *        </p>
         *        <p>
         *        For more information on update expressions, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html"
         *        >Modifying Items and Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateExpression(String updateExpression);

        /**
         * <p>
         * A condition that must be satisfied in order for a conditional update to succeed.
         * </p>
         * <p>
         * An expression can contain any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Functions:
         * <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
         * </p>
         * <p>
         * These function names are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Logical operators: <code>AND | OR | NOT</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about condition expressions, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionExpression
         *        A condition that must be satisfied in order for a conditional update to succeed.</p>
         *        <p>
         *        An expression can contain any of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Functions:
         *        <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
         *        </p>
         *        <p>
         *        These function names are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Logical operators: <code>AND | OR | NOT</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about condition expressions, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         *        >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionExpression(String conditionExpression);

        /**
         * <p>
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for
         * using <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To access an attribute whose name conflicts with a DynamoDB reserved word.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a placeholder for repeating occurrences of an attribute name in an expression.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent special characters in an attribute name from being misinterpreted in an expression.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
         * following attribute name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Percentile</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression.
         * (For the complete list of reserved words, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>.) To work around this, you could specify the following for
         * <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>{"#P":"Percentile"}</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You could then use this substitution in an expression, as in this example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#P = :val</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders
         * for the actual value at runtime.
         * </p>
         * </note>
         * <p>
         * For more information about expression attribute names, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeNames
         *        One or more substitution tokens for attribute names in an expression. The following are some use cases
         *        for using <code>ExpressionAttributeNames</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To access an attribute whose name conflicts with a DynamoDB reserved word.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a placeholder for repeating occurrences of an attribute name in an expression.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To prevent special characters in an attribute name from being misinterpreted in an expression.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider
         *        the following attribute name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Percentile</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
         *        expression. (For the complete list of reserved words, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
         *        Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.) To work around this, you could specify the
         *        following for <code>ExpressionAttributeNames</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>{"#P":"Percentile"}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You could then use this substitution in an expression, as in this example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#P = :val</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
         *        placeholders for the actual value at runtime.
         *        </p>
         *        </note>
         *        <p>
         *        For more information about expression attribute names, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeNames(Map<String, String> expressionAttributeNames);

        /**
         * <p>
         * One or more values that can be substituted in an expression.
         * </p>
         * <p>
         * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose
         * that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of the
         * following:
         * </p>
         * <p>
         * <code>Available | Backordered | Discontinued</code>
         * </p>
         * <p>
         * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         * </p>
         * <p>
         * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         * </p>
         * <p>
         * You could then use these values in an expression, such as this:
         * </p>
         * <p>
         * <code>ProductStatus IN (:avail, :back, :disc)</code>
         * </p>
         * <p>
         * For more information on expression attribute values, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         * >Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeValues
         *        One or more values that can be substituted in an expression.</p>
         *        <p>
         *        Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
         *        suppose that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one
         *        of the following:
         *        </p>
         *        <p>
         *        <code>Available | Backordered | Discontinued</code>
         *        </p>
         *        <p>
         *        You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         *        </p>
         *        <p>
         *        <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         *        </p>
         *        <p>
         *        You could then use these values in an expression, such as this:
         *        </p>
         *        <p>
         *        <code>ProductStatus IN (:avail, :back, :disc)</code>
         *        </p>
         *        <p>
         *        For more information on expression attribute values, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         *        >Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableName;

        private Map<String, AttributeValue> key = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, AttributeValueUpdate> attributeUpdates = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ExpectedAttributeValue> expected = DefaultSdkAutoConstructMap.getInstance();

        private String conditionalOperator;

        private String returnValues;

        private String returnConsumedCapacity;

        private String returnItemCollectionMetrics;

        private String updateExpression;

        private String conditionExpression;

        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateItemRequest model) {
            super(model);
            tableName(model.tableName);
            key(model.key);
            attributeUpdates(model.attributeUpdates);
            expected(model.expected);
            conditionalOperator(model.conditionalOperator);
            returnValues(model.returnValues);
            returnConsumedCapacity(model.returnConsumedCapacity);
            returnItemCollectionMetrics(model.returnItemCollectionMetrics);
            updateExpression(model.updateExpression);
            conditionExpression(model.conditionExpression);
            expressionAttributeNames(model.expressionAttributeNames);
            expressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Map<String, AttributeValue.Builder> getKey() {
            return key != null ? CollectionUtils.mapValues(key, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue.BuilderImpl> key) {
            this.key = KeyCopier.copyFromBuilder(key);
        }

        public final Map<String, AttributeValueUpdate.Builder> getAttributeUpdates() {
            return attributeUpdates != null ? CollectionUtils.mapValues(attributeUpdates, AttributeValueUpdate::toBuilder) : null;
        }

        @Override
        public final Builder attributeUpdates(Map<String, AttributeValueUpdate> attributeUpdates) {
            this.attributeUpdates = AttributeUpdatesCopier.copy(attributeUpdates);
            return this;
        }

        public final void setAttributeUpdates(Map<String, AttributeValueUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = AttributeUpdatesCopier.copyFromBuilder(attributeUpdates);
        }

        public final Map<String, ExpectedAttributeValue.Builder> getExpected() {
            return expected != null ? CollectionUtils.mapValues(expected, ExpectedAttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
            return this;
        }

        public final void setExpected(Map<String, ExpectedAttributeValue.BuilderImpl> expected) {
            this.expected = ExpectedAttributeMapCopier.copyFromBuilder(expected);
        }

        public final String getConditionalOperator() {
            return conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator == null ? null : conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final String getReturnValues() {
            return returnValues;
        }

        @Override
        public final Builder returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        @Override
        public final Builder returnValues(ReturnValue returnValues) {
            this.returnValues(returnValues == null ? null : returnValues.toString());
            return this;
        }

        public final void setReturnValues(String returnValues) {
            this.returnValues = returnValues;
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getReturnItemCollectionMetrics() {
            return returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics == null ? null : returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        public final String getUpdateExpression() {
            return updateExpression;
        }

        @Override
        public final Builder updateExpression(String updateExpression) {
            this.updateExpression = updateExpression;
            return this;
        }

        public final void setUpdateExpression(String updateExpression) {
            this.updateExpression = updateExpression;
        }

        public final String getConditionExpression() {
            return conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return expressionAttributeValues != null ? CollectionUtils.mapValues(expressionAttributeValues,
                    AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateItemRequest build() {
            return new UpdateItemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
