/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Capacity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Capacity> {
    private static final SdkField<Double> READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ReadCapacityUnits").getter(Capacity.getter(Capacity::readCapacityUnits)).setter(Capacity.setter(Builder::readCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadCapacityUnits").build()}).build();
    private static final SdkField<Double> WRITE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("WriteCapacityUnits").getter(Capacity.getter(Capacity::writeCapacityUnits)).setter(Capacity.setter(Builder::writeCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteCapacityUnits").build()}).build();
    private static final SdkField<Double> CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("CapacityUnits").getter(Capacity.getter(Capacity::capacityUnits)).setter(Capacity.setter(Builder::capacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_CAPACITY_UNITS_FIELD, WRITE_CAPACITY_UNITS_FIELD, CAPACITY_UNITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double readCapacityUnits;
    private final Double writeCapacityUnits;
    private final Double capacityUnits;

    private Capacity(BuilderImpl builder) {
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
        this.capacityUnits = builder.capacityUnits;
    }

    public Double readCapacityUnits() {
        return this.readCapacityUnits;
    }

    public Double writeCapacityUnits() {
        return this.writeCapacityUnits;
    }

    public Double capacityUnits() {
        return this.capacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityUnits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capacity)) {
            return false;
        }
        Capacity other = (Capacity)obj;
        return Objects.equals(this.readCapacityUnits(), other.readCapacityUnits()) && Objects.equals(this.writeCapacityUnits(), other.writeCapacityUnits()) && Objects.equals(this.capacityUnits(), other.capacityUnits());
    }

    public String toString() {
        return ToString.builder((String)"Capacity").add("ReadCapacityUnits", (Object)this.readCapacityUnits()).add("WriteCapacityUnits", (Object)this.writeCapacityUnits()).add("CapacityUnits", (Object)this.capacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.readCapacityUnits()));
            }
            case "WriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.writeCapacityUnits()));
            }
            case "CapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.capacityUnits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Capacity, T> g) {
        return obj -> g.apply((Capacity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double readCapacityUnits;
        private Double writeCapacityUnits;
        private Double capacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(Capacity model) {
            this.readCapacityUnits(model.readCapacityUnits);
            this.writeCapacityUnits(model.writeCapacityUnits);
            this.capacityUnits(model.capacityUnits);
        }

        public final Double getReadCapacityUnits() {
            return this.readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Double readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final void setReadCapacityUnits(Double readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        public final Double getWriteCapacityUnits() {
            return this.writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Double writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public final void setWriteCapacityUnits(Double writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        public final Double getCapacityUnits() {
            return this.capacityUnits;
        }

        @Override
        public final Builder capacityUnits(Double capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        public final void setCapacityUnits(Double capacityUnits) {
            this.capacityUnits = capacityUnits;
        }

        public Capacity build() {
            return new Capacity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Capacity> {
        public Builder readCapacityUnits(Double var1);

        public Builder writeCapacityUnits(Double var1);

        public Builder capacityUnits(Double var1);
    }
}

