/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeKinesisStreamingDestinationResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DescribeKinesisStreamingDestinationResponse.Builder, DescribeKinesisStreamingDestinationResponse> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(DescribeKinesisStreamingDestinationResponse::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<List<KinesisDataStreamDestination>> KINESIS_DATA_STREAM_DESTINATIONS_FIELD = SdkField
            .<List<KinesisDataStreamDestination>> builder(MarshallingType.LIST)
            .memberName("KinesisDataStreamDestinations")
            .getter(getter(DescribeKinesisStreamingDestinationResponse::kinesisDataStreamDestinations))
            .setter(setter(Builder::kinesisDataStreamDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisDataStreamDestinations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KinesisDataStreamDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(KinesisDataStreamDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            KINESIS_DATA_STREAM_DESTINATIONS_FIELD));

    private final String tableName;

    private final List<KinesisDataStreamDestination> kinesisDataStreamDestinations;

    private DescribeKinesisStreamingDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.kinesisDataStreamDestinations = builder.kinesisDataStreamDestinations;
    }

    /**
     * <p>
     * The name of the table being described.
     * </p>
     * 
     * @return The name of the table being described.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * Returns true if the KinesisDataStreamDestinations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasKinesisDataStreamDestinations() {
        return kinesisDataStreamDestinations != null && !(kinesisDataStreamDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of replica structures for the table being described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKinesisDataStreamDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of replica structures for the table being described.
     */
    public final List<KinesisDataStreamDestination> kinesisDataStreamDestinations() {
        return kinesisDataStreamDestinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasKinesisDataStreamDestinations() ? kinesisDataStreamDestinations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKinesisStreamingDestinationResponse)) {
            return false;
        }
        DescribeKinesisStreamingDestinationResponse other = (DescribeKinesisStreamingDestinationResponse) obj;
        return Objects.equals(tableName(), other.tableName())
                && hasKinesisDataStreamDestinations() == other.hasKinesisDataStreamDestinations()
                && Objects.equals(kinesisDataStreamDestinations(), other.kinesisDataStreamDestinations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeKinesisStreamingDestinationResponse")
                .add("TableName", tableName())
                .add("KinesisDataStreamDestinations", hasKinesisDataStreamDestinations() ? kinesisDataStreamDestinations() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "KinesisDataStreamDestinations":
            return Optional.ofNullable(clazz.cast(kinesisDataStreamDestinations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKinesisStreamingDestinationResponse, T> g) {
        return obj -> g.apply((DescribeKinesisStreamingDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeKinesisStreamingDestinationResponse> {
        /**
         * <p>
         * The name of the table being described.
         * </p>
         * 
         * @param tableName
         *        The name of the table being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The list of replica structures for the table being described.
         * </p>
         * 
         * @param kinesisDataStreamDestinations
         *        The list of replica structures for the table being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisDataStreamDestinations(Collection<KinesisDataStreamDestination> kinesisDataStreamDestinations);

        /**
         * <p>
         * The list of replica structures for the table being described.
         * </p>
         * 
         * @param kinesisDataStreamDestinations
         *        The list of replica structures for the table being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisDataStreamDestinations(KinesisDataStreamDestination... kinesisDataStreamDestinations);

        /**
         * <p>
         * The list of replica structures for the table being described.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KinesisDataStreamDestination>.Builder}
         * avoiding the need to create one manually via {@link List<KinesisDataStreamDestination>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KinesisDataStreamDestination>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #kinesisDataStreamDestinations(List<KinesisDataStreamDestination>)}.
         * 
         * @param kinesisDataStreamDestinations
         *        a consumer that will call methods on {@link List<KinesisDataStreamDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisDataStreamDestinations(List<KinesisDataStreamDestination>)
         */
        Builder kinesisDataStreamDestinations(Consumer<KinesisDataStreamDestination.Builder>... kinesisDataStreamDestinations);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private String tableName;

        private List<KinesisDataStreamDestination> kinesisDataStreamDestinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKinesisStreamingDestinationResponse model) {
            super(model);
            tableName(model.tableName);
            kinesisDataStreamDestinations(model.kinesisDataStreamDestinations);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KinesisDataStreamDestination.Builder> getKinesisDataStreamDestinations() {
            if (kinesisDataStreamDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return kinesisDataStreamDestinations != null ? kinesisDataStreamDestinations.stream()
                    .map(KinesisDataStreamDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder kinesisDataStreamDestinations(Collection<KinesisDataStreamDestination> kinesisDataStreamDestinations) {
            this.kinesisDataStreamDestinations = KinesisDataStreamDestinationsCopier.copy(kinesisDataStreamDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kinesisDataStreamDestinations(KinesisDataStreamDestination... kinesisDataStreamDestinations) {
            kinesisDataStreamDestinations(Arrays.asList(kinesisDataStreamDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kinesisDataStreamDestinations(
                Consumer<KinesisDataStreamDestination.Builder>... kinesisDataStreamDestinations) {
            kinesisDataStreamDestinations(Stream.of(kinesisDataStreamDestinations)
                    .map(c -> KinesisDataStreamDestination.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKinesisDataStreamDestinations(
                Collection<KinesisDataStreamDestination.BuilderImpl> kinesisDataStreamDestinations) {
            this.kinesisDataStreamDestinations = KinesisDataStreamDestinationsCopier
                    .copyFromBuilder(kinesisDataStreamDestinations);
        }

        @Override
        public DescribeKinesisStreamingDestinationResponse build() {
            return new DescribeKinesisStreamingDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
