/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetShardIterator</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetShardIteratorResponse extends DynamoDbStreamsResponse implements
        ToCopyableBuilder<GetShardIteratorResponse.Builder, GetShardIteratorResponse> {
    private static final SdkField<String> SHARD_ITERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShardIterator").getter(getter(GetShardIteratorResponse::shardIterator))
            .setter(setter(Builder::shardIterator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardIterator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ITERATOR_FIELD));

    private final String shardIterator;

    private GetShardIteratorResponse(BuilderImpl builder) {
        super(builder);
        this.shardIterator = builder.shardIterator;
    }

    /**
     * <p>
     * The position in the shard from which to start reading stream records sequentially. A shard iterator specifies
     * this position using the sequence number of a stream record in a shard.
     * </p>
     * 
     * @return The position in the shard from which to start reading stream records sequentially. A shard iterator
     *         specifies this position using the sequence number of a stream record in a shard.
     */
    public final String shardIterator() {
        return shardIterator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(shardIterator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorResponse)) {
            return false;
        }
        GetShardIteratorResponse other = (GetShardIteratorResponse) obj;
        return Objects.equals(shardIterator(), other.shardIterator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetShardIteratorResponse").add("ShardIterator", shardIterator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardIterator":
            return Optional.ofNullable(clazz.cast(shardIterator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetShardIteratorResponse, T> g) {
        return obj -> g.apply((GetShardIteratorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbStreamsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetShardIteratorResponse> {
        /**
         * <p>
         * The position in the shard from which to start reading stream records sequentially. A shard iterator specifies
         * this position using the sequence number of a stream record in a shard.
         * </p>
         * 
         * @param shardIterator
         *        The position in the shard from which to start reading stream records sequentially. A shard iterator
         *        specifies this position using the sequence number of a stream record in a shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardIterator(String shardIterator);
    }

    static final class BuilderImpl extends DynamoDbStreamsResponse.BuilderImpl implements Builder {
        private String shardIterator;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorResponse model) {
            super(model);
            shardIterator(model.shardIterator);
        }

        public final String getShardIterator() {
            return shardIterator;
        }

        @Override
        public final Builder shardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
            return this;
        }

        public final void setShardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
        }

        @Override
        public GetShardIteratorResponse build() {
            return new GetShardIteratorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
