/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to perform a <code>PutItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Put implements SdkPojo, Serializable, ToCopyableBuilder<Put.Builder, Put> {
    private static final SdkField<Map<String, AttributeValue>> ITEM_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("Item")
            .getter(getter(Put::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(Put::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionExpression").getter(getter(Put::conditionExpression))
            .setter(setter(Builder::conditionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpression").build())
            .build();

    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ExpressionAttributeNames")
            .getter(getter(Put::expressionAttributeNames))
            .setter(setter(Builder::expressionAttributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("ExpressionAttributeValues")
            .getter(getter(Put::expressionAttributeValues))
            .setter(setter(Builder::expressionAttributeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReturnValuesOnConditionCheckFailure")
            .getter(getter(Put::returnValuesOnConditionCheckFailureAsString))
            .setter(setter(Builder::returnValuesOnConditionCheckFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReturnValuesOnConditionCheckFailure").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, TABLE_NAME_FIELD,
            CONDITION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD, EXPRESSION_ATTRIBUTE_VALUES_FIELD,
            RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, AttributeValue> item;

    private final String tableName;

    private final String conditionExpression;

    private final Map<String, String> expressionAttributeNames;

    private final Map<String, AttributeValue> expressionAttributeValues;

    private final String returnValuesOnConditionCheckFailure;

    private Put(BuilderImpl builder) {
        this.item = builder.item;
        this.tableName = builder.tableName;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
        this.returnValuesOnConditionCheckFailure = builder.returnValuesOnConditionCheckFailure;
    }

    /**
     * Returns true if the Item property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasItem() {
        return item != null && !(item instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of attribute name to attribute values, representing the primary key of the item to be written by
     * <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must
     * match those of the table's key schema. If any attributes are present in the item that are part of an index key
     * schema for the table, their types must match the index key schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItem()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of attribute name to attribute values, representing the primary key of the item to be written by
     *         <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types
     *         must match those of the table's key schema. If any attributes are present in the item that are part of an
     *         index key schema for the table, their types must match the index key schema.
     */
    public Map<String, AttributeValue> item() {
        return item;
    }

    /**
     * <p>
     * Name of the table in which to write the item.
     * </p>
     * 
     * @return Name of the table in which to write the item.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A condition that must be satisfied in order for a conditional update to succeed.
     * </p>
     * 
     * @return A condition that must be satisfied in order for a conditional update to succeed.
     */
    public String conditionExpression() {
        return conditionExpression;
    }

    /**
     * Returns true if the ExpressionAttributeNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExpressionAttributeNames() {
        return expressionAttributeNames != null && !(expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more substitution tokens for attribute names in an expression.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExpressionAttributeNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more substitution tokens for attribute names in an expression.
     */
    public Map<String, String> expressionAttributeNames() {
        return expressionAttributeNames;
    }

    /**
     * Returns true if the ExpressionAttributeValues property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExpressionAttributeValues() {
        return expressionAttributeValues != null && !(expressionAttributeValues instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more values that can be substituted in an expression.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExpressionAttributeValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more values that can be substituted in an expression.
     */
    public Map<String, AttributeValue> expressionAttributeValues() {
        return expressionAttributeValues;
    }

    /**
     * <p>
     * Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code> condition
     * fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnValuesOnConditionCheckFailure} will return
     * {@link ReturnValuesOnConditionCheckFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #returnValuesOnConditionCheckFailureAsString}.
     * </p>
     * 
     * @return Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code>
     *         condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and
     *         ALL_OLD.
     * @see ReturnValuesOnConditionCheckFailure
     */
    public ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure() {
        return ReturnValuesOnConditionCheckFailure.fromValue(returnValuesOnConditionCheckFailure);
    }

    /**
     * <p>
     * Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code> condition
     * fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnValuesOnConditionCheckFailure} will return
     * {@link ReturnValuesOnConditionCheckFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #returnValuesOnConditionCheckFailureAsString}.
     * </p>
     * 
     * @return Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code>
     *         condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and
     *         ALL_OLD.
     * @see ReturnValuesOnConditionCheckFailure
     */
    public String returnValuesOnConditionCheckFailureAsString() {
        return returnValuesOnConditionCheckFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(item());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeValues());
        hashCode = 31 * hashCode + Objects.hashCode(returnValuesOnConditionCheckFailureAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Put)) {
            return false;
        }
        Put other = (Put) obj;
        return Objects.equals(item(), other.item())
                && Objects.equals(tableName(), other.tableName())
                && Objects.equals(conditionExpression(), other.conditionExpression())
                && Objects.equals(expressionAttributeNames(), other.expressionAttributeNames())
                && Objects.equals(expressionAttributeValues(), other.expressionAttributeValues())
                && Objects.equals(returnValuesOnConditionCheckFailureAsString(),
                        other.returnValuesOnConditionCheckFailureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Put").add("Item", item()).add("TableName", tableName())
                .add("ConditionExpression", conditionExpression()).add("ExpressionAttributeNames", expressionAttributeNames())
                .add("ExpressionAttributeValues", expressionAttributeValues())
                .add("ReturnValuesOnConditionCheckFailure", returnValuesOnConditionCheckFailureAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "ConditionExpression":
            return Optional.ofNullable(clazz.cast(conditionExpression()));
        case "ExpressionAttributeNames":
            return Optional.ofNullable(clazz.cast(expressionAttributeNames()));
        case "ExpressionAttributeValues":
            return Optional.ofNullable(clazz.cast(expressionAttributeValues()));
        case "ReturnValuesOnConditionCheckFailure":
            return Optional.ofNullable(clazz.cast(returnValuesOnConditionCheckFailureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Put, T> g) {
        return obj -> g.apply((Put) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Put> {
        /**
         * <p>
         * A map of attribute name to attribute values, representing the primary key of the item to be written by
         * <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must
         * match those of the table's key schema. If any attributes are present in the item that are part of an index
         * key schema for the table, their types must match the index key schema.
         * </p>
         * 
         * @param item
         *        A map of attribute name to attribute values, representing the primary key of the item to be written by
         *        <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data
         *        types must match those of the table's key schema. If any attributes are present in the item that are
         *        part of an index key schema for the table, their types must match the index key schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Map<String, AttributeValue> item);

        /**
         * <p>
         * Name of the table in which to write the item.
         * </p>
         * 
         * @param tableName
         *        Name of the table in which to write the item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A condition that must be satisfied in order for a conditional update to succeed.
         * </p>
         * 
         * @param conditionExpression
         *        A condition that must be satisfied in order for a conditional update to succeed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionExpression(String conditionExpression);

        /**
         * <p>
         * One or more substitution tokens for attribute names in an expression.
         * </p>
         * 
         * @param expressionAttributeNames
         *        One or more substitution tokens for attribute names in an expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeNames(Map<String, String> expressionAttributeNames);

        /**
         * <p>
         * One or more values that can be substituted in an expression.
         * </p>
         * 
         * @param expressionAttributeValues
         *        One or more values that can be substituted in an expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues);

        /**
         * <p>
         * Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code>
         * condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and
         * ALL_OLD.
         * </p>
         * 
         * @param returnValuesOnConditionCheckFailure
         *        Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the
         *        <code>Put</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid
         *        values are: NONE and ALL_OLD.
         * @see ReturnValuesOnConditionCheckFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValuesOnConditionCheckFailure
         */
        Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure);

        /**
         * <p>
         * Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code>
         * condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and
         * ALL_OLD.
         * </p>
         * 
         * @param returnValuesOnConditionCheckFailure
         *        Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the
         *        <code>Put</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid
         *        values are: NONE and ALL_OLD.
         * @see ReturnValuesOnConditionCheckFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValuesOnConditionCheckFailure
         */
        Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AttributeValue> item = DefaultSdkAutoConstructMap.getInstance();

        private String tableName;

        private String conditionExpression;

        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();

        private String returnValuesOnConditionCheckFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(Put model) {
            item(model.item);
            tableName(model.tableName);
            conditionExpression(model.conditionExpression);
            expressionAttributeNames(model.expressionAttributeNames);
            expressionAttributeValues(model.expressionAttributeValues);
            returnValuesOnConditionCheckFailure(model.returnValuesOnConditionCheckFailure);
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            return item != null ? CollectionUtils.mapValues(item, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = PutItemInputAttributeMapCopier.copyFromBuilder(item);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getConditionExpression() {
            return conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return expressionAttributeValues != null ? CollectionUtils.mapValues(expressionAttributeValues,
                    AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        public final String getReturnValuesOnConditionCheckFailure() {
            return returnValuesOnConditionCheckFailure;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
            return this;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(
                ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure == null ? null
                    : returnValuesOnConditionCheckFailure.toString());
            return this;
        }

        public final void setReturnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
        }

        @Override
        public Put build() {
            return new Put(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
