/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of a single data modification that was performed on an item in a DynamoDB table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamRecord implements SdkPojo, Serializable, ToCopyableBuilder<StreamRecord.Builder, StreamRecord> {
    private static final SdkField<Instant> APPROXIMATE_CREATION_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApproximateCreationDateTime")
            .getter(getter(StreamRecord::approximateCreationDateTime))
            .setter(setter(Builder::approximateCreationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateCreationDateTime")
                    .build()).build();

    private static final SdkField<Map<String, AttributeValue>> KEYS_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("Keys")
            .getter(getter(StreamRecord::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeValue>> NEW_IMAGE_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("NewImage")
            .getter(getter(StreamRecord::newImage))
            .setter(setter(Builder::newImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewImage").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeValue>> OLD_IMAGE_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("OldImage")
            .getter(getter(StreamRecord::oldImage))
            .setter(setter(Builder::oldImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldImage").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SequenceNumber").getter(getter(StreamRecord::sequenceNumber)).setter(setter(Builder::sequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()).build();

    private static final SdkField<Long> SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("SizeBytes")
            .getter(getter(StreamRecord::sizeBytes)).setter(setter(Builder::sizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeBytes").build()).build();

    private static final SdkField<String> STREAM_VIEW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamViewType").getter(getter(StreamRecord::streamViewTypeAsString))
            .setter(setter(Builder::streamViewType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamViewType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROXIMATE_CREATION_DATE_TIME_FIELD, KEYS_FIELD, NEW_IMAGE_FIELD, OLD_IMAGE_FIELD, SEQUENCE_NUMBER_FIELD,
            SIZE_BYTES_FIELD, STREAM_VIEW_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant approximateCreationDateTime;

    private final Map<String, AttributeValue> keys;

    private final Map<String, AttributeValue> newImage;

    private final Map<String, AttributeValue> oldImage;

    private final String sequenceNumber;

    private final Long sizeBytes;

    private final String streamViewType;

    private StreamRecord(BuilderImpl builder) {
        this.approximateCreationDateTime = builder.approximateCreationDateTime;
        this.keys = builder.keys;
        this.newImage = builder.newImage;
        this.oldImage = builder.oldImage;
        this.sequenceNumber = builder.sequenceNumber;
        this.sizeBytes = builder.sizeBytes;
        this.streamViewType = builder.streamViewType;
    }

    /**
     * <p>
     * The approximate date and time when the stream record was created, in <a
     * href="http://www.epochconverter.com/">UNIX epoch time</a> format.
     * </p>
     * 
     * @return The approximate date and time when the stream record was created, in <a
     *         href="http://www.epochconverter.com/">UNIX epoch time</a> format.
     */
    public final Instant approximateCreationDateTime() {
        return approximateCreationDateTime;
    }

    /**
     * Returns true if the Keys property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The primary key attribute(s) for the DynamoDB item that was modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The primary key attribute(s) for the DynamoDB item that was modified.
     */
    public final Map<String, AttributeValue> keys() {
        return keys;
    }

    /**
     * Returns true if the NewImage property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasNewImage() {
        return newImage != null && !(newImage instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The item in the DynamoDB table as it appeared after it was modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNewImage()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The item in the DynamoDB table as it appeared after it was modified.
     */
    public final Map<String, AttributeValue> newImage() {
        return newImage;
    }

    /**
     * Returns true if the OldImage property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOldImage() {
        return oldImage != null && !(oldImage instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The item in the DynamoDB table as it appeared before it was modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOldImage()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The item in the DynamoDB table as it appeared before it was modified.
     */
    public final Map<String, AttributeValue> oldImage() {
        return oldImage;
    }

    /**
     * <p>
     * The sequence number of the stream record.
     * </p>
     * 
     * @return The sequence number of the stream record.
     */
    public final String sequenceNumber() {
        return sequenceNumber;
    }

    /**
     * <p>
     * The size of the stream record, in bytes.
     * </p>
     * 
     * @return The size of the stream record, in bytes.
     */
    public final Long sizeBytes() {
        return sizeBytes;
    }

    /**
     * <p>
     * The type of data from the modified DynamoDB item that was captured in this stream record:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - only the key attributes of the modified item.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamViewType}
     * will return {@link StreamViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamViewTypeAsString}.
     * </p>
     * 
     * @return The type of data from the modified DynamoDB item that was captured in this stream record:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - only the key attributes of the modified item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
     *         </p>
     *         </li>
     * @see StreamViewType
     */
    public final StreamViewType streamViewType() {
        return StreamViewType.fromValue(streamViewType);
    }

    /**
     * <p>
     * The type of data from the modified DynamoDB item that was captured in this stream record:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - only the key attributes of the modified item.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamViewType}
     * will return {@link StreamViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamViewTypeAsString}.
     * </p>
     * 
     * @return The type of data from the modified DynamoDB item that was captured in this stream record:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - only the key attributes of the modified item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
     *         </p>
     *         </li>
     * @see StreamViewType
     */
    public final String streamViewTypeAsString() {
        return streamViewType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approximateCreationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNewImage() ? newImage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOldImage() ? oldImage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(sizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(streamViewTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamRecord)) {
            return false;
        }
        StreamRecord other = (StreamRecord) obj;
        return Objects.equals(approximateCreationDateTime(), other.approximateCreationDateTime()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys()) && hasNewImage() == other.hasNewImage()
                && Objects.equals(newImage(), other.newImage()) && hasOldImage() == other.hasOldImage()
                && Objects.equals(oldImage(), other.oldImage()) && Objects.equals(sequenceNumber(), other.sequenceNumber())
                && Objects.equals(sizeBytes(), other.sizeBytes())
                && Objects.equals(streamViewTypeAsString(), other.streamViewTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamRecord").add("ApproximateCreationDateTime", approximateCreationDateTime())
                .add("Keys", hasKeys() ? keys() : null).add("NewImage", hasNewImage() ? newImage() : null)
                .add("OldImage", hasOldImage() ? oldImage() : null).add("SequenceNumber", sequenceNumber())
                .add("SizeBytes", sizeBytes()).add("StreamViewType", streamViewTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApproximateCreationDateTime":
            return Optional.ofNullable(clazz.cast(approximateCreationDateTime()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "NewImage":
            return Optional.ofNullable(clazz.cast(newImage()));
        case "OldImage":
            return Optional.ofNullable(clazz.cast(oldImage()));
        case "SequenceNumber":
            return Optional.ofNullable(clazz.cast(sequenceNumber()));
        case "SizeBytes":
            return Optional.ofNullable(clazz.cast(sizeBytes()));
        case "StreamViewType":
            return Optional.ofNullable(clazz.cast(streamViewTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamRecord, T> g) {
        return obj -> g.apply((StreamRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamRecord> {
        /**
         * <p>
         * The approximate date and time when the stream record was created, in <a
         * href="http://www.epochconverter.com/">UNIX epoch time</a> format.
         * </p>
         * 
         * @param approximateCreationDateTime
         *        The approximate date and time when the stream record was created, in <a
         *        href="http://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateCreationDateTime(Instant approximateCreationDateTime);

        /**
         * <p>
         * The primary key attribute(s) for the DynamoDB item that was modified.
         * </p>
         * 
         * @param keys
         *        The primary key attribute(s) for the DynamoDB item that was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Map<String, AttributeValue> keys);

        /**
         * <p>
         * The item in the DynamoDB table as it appeared after it was modified.
         * </p>
         * 
         * @param newImage
         *        The item in the DynamoDB table as it appeared after it was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newImage(Map<String, AttributeValue> newImage);

        /**
         * <p>
         * The item in the DynamoDB table as it appeared before it was modified.
         * </p>
         * 
         * @param oldImage
         *        The item in the DynamoDB table as it appeared before it was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldImage(Map<String, AttributeValue> oldImage);

        /**
         * <p>
         * The sequence number of the stream record.
         * </p>
         * 
         * @param sequenceNumber
         *        The sequence number of the stream record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);

        /**
         * <p>
         * The size of the stream record, in bytes.
         * </p>
         * 
         * @param sizeBytes
         *        The size of the stream record, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeBytes(Long sizeBytes);

        /**
         * <p>
         * The type of data from the modified DynamoDB item that was captured in this stream record:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - only the key attributes of the modified item.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamViewType
         *        The type of data from the modified DynamoDB item that was captured in this stream record:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - only the key attributes of the modified item.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
         *        </p>
         *        </li>
         * @see StreamViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamViewType
         */
        Builder streamViewType(String streamViewType);

        /**
         * <p>
         * The type of data from the modified DynamoDB item that was captured in this stream record:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - only the key attributes of the modified item.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamViewType
         *        The type of data from the modified DynamoDB item that was captured in this stream record:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - only the key attributes of the modified item.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
         *        </p>
         *        </li>
         * @see StreamViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamViewType
         */
        Builder streamViewType(StreamViewType streamViewType);
    }

    static final class BuilderImpl implements Builder {
        private Instant approximateCreationDateTime;

        private Map<String, AttributeValue> keys = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, AttributeValue> newImage = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, AttributeValue> oldImage = DefaultSdkAutoConstructMap.getInstance();

        private String sequenceNumber;

        private Long sizeBytes;

        private String streamViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamRecord model) {
            approximateCreationDateTime(model.approximateCreationDateTime);
            keys(model.keys);
            newImage(model.newImage);
            oldImage(model.oldImage);
            sequenceNumber(model.sequenceNumber);
            sizeBytes(model.sizeBytes);
            streamViewType(model.streamViewType);
        }

        public final Instant getApproximateCreationDateTime() {
            return approximateCreationDateTime;
        }

        @Override
        public final Builder approximateCreationDateTime(Instant approximateCreationDateTime) {
            this.approximateCreationDateTime = approximateCreationDateTime;
            return this;
        }

        public final void setApproximateCreationDateTime(Instant approximateCreationDateTime) {
            this.approximateCreationDateTime = approximateCreationDateTime;
        }

        public final Map<String, AttributeValue.Builder> getKeys() {
            if (keys instanceof SdkAutoConstructMap) {
                return null;
            }
            return keys != null ? CollectionUtils.mapValues(keys, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder keys(Map<String, AttributeValue> keys) {
            this.keys = AttributeMapCopier.copy(keys);
            return this;
        }

        public final void setKeys(Map<String, AttributeValue.BuilderImpl> keys) {
            this.keys = AttributeMapCopier.copyFromBuilder(keys);
        }

        public final Map<String, AttributeValue.Builder> getNewImage() {
            if (newImage instanceof SdkAutoConstructMap) {
                return null;
            }
            return newImage != null ? CollectionUtils.mapValues(newImage, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder newImage(Map<String, AttributeValue> newImage) {
            this.newImage = AttributeMapCopier.copy(newImage);
            return this;
        }

        public final void setNewImage(Map<String, AttributeValue.BuilderImpl> newImage) {
            this.newImage = AttributeMapCopier.copyFromBuilder(newImage);
        }

        public final Map<String, AttributeValue.Builder> getOldImage() {
            if (oldImage instanceof SdkAutoConstructMap) {
                return null;
            }
            return oldImage != null ? CollectionUtils.mapValues(oldImage, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder oldImage(Map<String, AttributeValue> oldImage) {
            this.oldImage = AttributeMapCopier.copy(oldImage);
            return this;
        }

        public final void setOldImage(Map<String, AttributeValue.BuilderImpl> oldImage) {
            this.oldImage = AttributeMapCopier.copyFromBuilder(oldImage);
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final Long getSizeBytes() {
            return sizeBytes;
        }

        @Override
        public final Builder sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public final void setSizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public final String getStreamViewType() {
            return streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType == null ? null : streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        @Override
        public StreamRecord build() {
            return new StreamRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
