/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteStatementResponse extends DynamoDbResponse implements
        ToCopyableBuilder<ExecuteStatementResponse.Builder, ExecuteStatementResponse> {
    private static final SdkField<List<Map<String, AttributeValue>>> ITEMS_FIELD = SdkField
            .<List<Map<String, AttributeValue>>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(ExecuteStatementResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, AttributeValue>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(AttributeValue::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ExecuteStatementResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Map<String, AttributeValue>> items;

    private final String nextToken;

    private ExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If a read operation was used, this property will contain the result of the reade operation; a map of attribute
     * names and their values. For the write operations this value will be empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If a read operation was used, this property will contain the result of the reade operation; a map of
     *         attribute names and their values. For the write operations this value will be empty.
     */
    public final List<Map<String, AttributeValue>> items() {
        return items;
    }

    /**
     * <p>
     * If the response of a read request exceeds the response payload limit DynamoDB will set this value in the
     * response. If set, you can use that this value in the subsequent request to get the remaining results.
     * </p>
     * 
     * @return If the response of a read request exceeds the response payload limit DynamoDB will set this value in the
     *         response. If set, you can use that this value in the subsequent request to get the remaining results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementResponse)) {
            return false;
        }
        ExecuteStatementResponse other = (ExecuteStatementResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteStatementResponse").add("Items", hasItems() ? items() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementResponse, T> g) {
        return obj -> g.apply((ExecuteStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteStatementResponse> {
        /**
         * <p>
         * If a read operation was used, this property will contain the result of the reade operation; a map of
         * attribute names and their values. For the write operations this value will be empty.
         * </p>
         * 
         * @param items
         *        If a read operation was used, this property will contain the result of the reade operation; a map of
         *        attribute names and their values. For the write operations this value will be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<? extends Map<String, AttributeValue>> items);

        /**
         * <p>
         * If a read operation was used, this property will contain the result of the reade operation; a map of
         * attribute names and their values. For the write operations this value will be empty.
         * </p>
         * 
         * @param items
         *        If a read operation was used, this property will contain the result of the reade operation; a map of
         *        attribute names and their values. For the write operations this value will be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Map<String, AttributeValue>... items);

        /**
         * <p>
         * If the response of a read request exceeds the response payload limit DynamoDB will set this value in the
         * response. If set, you can use that this value in the subsequent request to get the remaining results.
         * </p>
         * 
         * @param nextToken
         *        If the response of a read request exceeds the response payload limit DynamoDB will set this value in
         *        the response. If set, you can use that this value in the subsequent request to get the remaining
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<Map<String, AttributeValue>> items = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementResponse model) {
            super(model);
            items(model.items);
            nextToken(model.nextToken);
        }

        public final Collection<Map<String, AttributeValue.Builder>> getItems() {
            if (items instanceof SdkAutoConstructList) {
                return null;
            }
            return items != null ? items
                    .stream()
                    .map(m -> m.entrySet().stream()
                            .collect(Collectors.toMap(entry -> entry.getKey(), entry -> entry.getValue().toBuilder())))
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<? extends Map<String, AttributeValue>> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Map<String, AttributeValue>... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<Map<String, AttributeValue.BuilderImpl>> items) {
            this.items = ItemListCopier.copyFromBuilder(items);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ExecuteStatementResponse build() {
            return new ExecuteStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
