/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceTableDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceTableDetails> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(SourceTableDetails.getter(SourceTableDetails::tableName)).setter(SourceTableDetails.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableId").getter(SourceTableDetails.getter(SourceTableDetails::tableId)).setter(SourceTableDetails.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableArn").getter(SourceTableDetails.getter(SourceTableDetails::tableArn)).setter(SourceTableDetails.setter(Builder::tableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()}).build();
    private static final SdkField<Long> TABLE_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TableSizeBytes").getter(SourceTableDetails.getter(SourceTableDetails::tableSizeBytes)).setter(SourceTableDetails.setter(Builder::tableSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableSizeBytes").build()}).build();
    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeySchema").getter(SourceTableDetails.getter(SourceTableDetails::keySchema)).setter(SourceTableDetails.setter(Builder::keySchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeySchemaElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> TABLE_CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TableCreationDateTime").getter(SourceTableDetails.getter(SourceTableDetails::tableCreationDateTime)).setter(SourceTableDetails.setter(Builder::tableCreationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableCreationDateTime").build()}).build();
    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughput").getter(SourceTableDetails.getter(SourceTableDetails::provisionedThroughput)).setter(SourceTableDetails.setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build()}).build();
    private static final SdkField<Long> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ItemCount").getter(SourceTableDetails.getter(SourceTableDetails::itemCount)).setter(SourceTableDetails.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingMode").getter(SourceTableDetails.getter(SourceTableDetails::billingModeAsString)).setter(SourceTableDetails.setter(Builder::billingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, TABLE_ID_FIELD, TABLE_ARN_FIELD, TABLE_SIZE_BYTES_FIELD, KEY_SCHEMA_FIELD, TABLE_CREATION_DATE_TIME_FIELD, PROVISIONED_THROUGHPUT_FIELD, ITEM_COUNT_FIELD, BILLING_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final String tableId;
    private final String tableArn;
    private final Long tableSizeBytes;
    private final List<KeySchemaElement> keySchema;
    private final Instant tableCreationDateTime;
    private final ProvisionedThroughput provisionedThroughput;
    private final Long itemCount;
    private final String billingMode;

    private SourceTableDetails(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.tableId = builder.tableId;
        this.tableArn = builder.tableArn;
        this.tableSizeBytes = builder.tableSizeBytes;
        this.keySchema = builder.keySchema;
        this.tableCreationDateTime = builder.tableCreationDateTime;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.itemCount = builder.itemCount;
        this.billingMode = builder.billingMode;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String tableId() {
        return this.tableId;
    }

    public final String tableArn() {
        return this.tableArn;
    }

    public final Long tableSizeBytes() {
        return this.tableSizeBytes;
    }

    public final boolean hasKeySchema() {
        return this.keySchema != null && !(this.keySchema instanceof SdkAutoConstructList);
    }

    public final List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public final Instant tableCreationDateTime() {
        return this.tableCreationDateTime;
    }

    public final ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public final Long itemCount() {
        return this.itemCount;
    }

    public final BillingMode billingMode() {
        return BillingMode.fromValue(this.billingMode);
    }

    public final String billingModeAsString() {
        return this.billingMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeySchema() ? this.keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tableCreationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceTableDetails)) {
            return false;
        }
        SourceTableDetails other = (SourceTableDetails)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.tableId(), other.tableId()) && Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.tableSizeBytes(), other.tableSizeBytes()) && this.hasKeySchema() == other.hasKeySchema() && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.tableCreationDateTime(), other.tableCreationDateTime()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.billingModeAsString(), other.billingModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SourceTableDetails").add("TableName", (Object)this.tableName()).add("TableId", (Object)this.tableId()).add("TableArn", (Object)this.tableArn()).add("TableSizeBytes", (Object)this.tableSizeBytes()).add("KeySchema", this.hasKeySchema() ? this.keySchema() : null).add("TableCreationDateTime", (Object)this.tableCreationDateTime()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("ItemCount", (Object)this.itemCount()).add("BillingMode", (Object)this.billingModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "TableSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.tableSizeBytes()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "TableCreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.tableCreationDateTime()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "BillingMode": {
                return Optional.ofNullable(clazz.cast(this.billingModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceTableDetails, T> g) {
        return obj -> g.apply((SourceTableDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String tableId;
        private String tableArn;
        private Long tableSizeBytes;
        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();
        private Instant tableCreationDateTime;
        private ProvisionedThroughput provisionedThroughput;
        private Long itemCount;
        private String billingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceTableDetails model) {
            this.tableName(model.tableName);
            this.tableId(model.tableId);
            this.tableArn(model.tableArn);
            this.tableSizeBytes(model.tableSizeBytes);
            this.keySchema(model.keySchema);
            this.tableCreationDateTime(model.tableCreationDateTime);
            this.provisionedThroughput(model.provisionedThroughput);
            this.itemCount(model.itemCount);
            this.billingMode(model.billingMode);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getTableId() {
            return this.tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        public final Long getTableSizeBytes() {
            return this.tableSizeBytes;
        }

        @Override
        public final Builder tableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
            return this;
        }

        public final void setTableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
        }

        public final List<KeySchemaElement.Builder> getKeySchema() {
            List<KeySchemaElement.Builder> result = KeySchemaCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (KeySchemaElement)((KeySchemaElement.Builder)KeySchemaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Instant getTableCreationDateTime() {
            return this.tableCreationDateTime;
        }

        @Override
        public final Builder tableCreationDateTime(Instant tableCreationDateTime) {
            this.tableCreationDateTime = tableCreationDateTime;
            return this;
        }

        public final void setTableCreationDateTime(Instant tableCreationDateTime) {
            this.tableCreationDateTime = tableCreationDateTime;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public final String getBillingMode() {
            return this.billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        public SourceTableDetails build() {
            return new SourceTableDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceTableDetails> {
        public Builder tableName(String var1);

        public Builder tableId(String var1);

        public Builder tableArn(String var1);

        public Builder tableSizeBytes(Long var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder keySchema(Consumer<KeySchemaElement.Builder> ... var1);

        public Builder tableCreationDateTime(Instant var1);

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughput)).build());
        }

        public Builder itemCount(Long var1);

        public Builder billingMode(String var1);

        public Builder billingMode(BillingMode var1);
    }
}

