/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the Time to Live (TTL) status on the specified table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeToLiveDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeToLiveDescription.Builder, TimeToLiveDescription> {
    private static final SdkField<String> TIME_TO_LIVE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeToLiveStatus").getter(getter(TimeToLiveDescription::timeToLiveStatusAsString))
            .setter(setter(Builder::timeToLiveStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLiveStatus").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(TimeToLiveDescription::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_TO_LIVE_STATUS_FIELD,
            ATTRIBUTE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timeToLiveStatus;

    private final String attributeName;

    private TimeToLiveDescription(BuilderImpl builder) {
        this.timeToLiveStatus = builder.timeToLiveStatus;
        this.attributeName = builder.attributeName;
    }

    /**
     * <p>
     * The TTL status for the table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeToLiveStatus}
     * will return {@link TimeToLiveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeToLiveStatusAsString}.
     * </p>
     * 
     * @return The TTL status for the table.
     * @see TimeToLiveStatus
     */
    public final TimeToLiveStatus timeToLiveStatus() {
        return TimeToLiveStatus.fromValue(timeToLiveStatus);
    }

    /**
     * <p>
     * The TTL status for the table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeToLiveStatus}
     * will return {@link TimeToLiveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeToLiveStatusAsString}.
     * </p>
     * 
     * @return The TTL status for the table.
     * @see TimeToLiveStatus
     */
    public final String timeToLiveStatusAsString() {
        return timeToLiveStatus;
    }

    /**
     * <p>
     * The name of the TTL attribute for items in the table.
     * </p>
     * 
     * @return The name of the TTL attribute for items in the table.
     */
    public final String attributeName() {
        return attributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeToLiveStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeToLiveDescription)) {
            return false;
        }
        TimeToLiveDescription other = (TimeToLiveDescription) obj;
        return Objects.equals(timeToLiveStatusAsString(), other.timeToLiveStatusAsString())
                && Objects.equals(attributeName(), other.attributeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeToLiveDescription").add("TimeToLiveStatus", timeToLiveStatusAsString())
                .add("AttributeName", attributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeToLiveStatus":
            return Optional.ofNullable(clazz.cast(timeToLiveStatusAsString()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeToLiveDescription, T> g) {
        return obj -> g.apply((TimeToLiveDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeToLiveDescription> {
        /**
         * <p>
         * The TTL status for the table.
         * </p>
         * 
         * @param timeToLiveStatus
         *        The TTL status for the table.
         * @see TimeToLiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeToLiveStatus
         */
        Builder timeToLiveStatus(String timeToLiveStatus);

        /**
         * <p>
         * The TTL status for the table.
         * </p>
         * 
         * @param timeToLiveStatus
         *        The TTL status for the table.
         * @see TimeToLiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeToLiveStatus
         */
        Builder timeToLiveStatus(TimeToLiveStatus timeToLiveStatus);

        /**
         * <p>
         * The name of the TTL attribute for items in the table.
         * </p>
         * 
         * @param attributeName
         *        The name of the TTL attribute for items in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);
    }

    static final class BuilderImpl implements Builder {
        private String timeToLiveStatus;

        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeToLiveDescription model) {
            timeToLiveStatus(model.timeToLiveStatus);
            attributeName(model.attributeName);
        }

        public final String getTimeToLiveStatus() {
            return timeToLiveStatus;
        }

        public final void setTimeToLiveStatus(String timeToLiveStatus) {
            this.timeToLiveStatus = timeToLiveStatus;
        }

        @Override
        @Transient
        public final Builder timeToLiveStatus(String timeToLiveStatus) {
            this.timeToLiveStatus = timeToLiveStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder timeToLiveStatus(TimeToLiveStatus timeToLiveStatus) {
            this.timeToLiveStatus(timeToLiveStatus == null ? null : timeToLiveStatus.toString());
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        @Transient
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        @Override
        public TimeToLiveDescription build() {
            return new TimeToLiveDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
