/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteTransactionRequest extends DynamoDbRequest implements
        ToCopyableBuilder<ExecuteTransactionRequest.Builder, ExecuteTransactionRequest> {
    private static final SdkField<List<ParameterizedStatement>> TRANSACT_STATEMENTS_FIELD = SdkField
            .<List<ParameterizedStatement>> builder(MarshallingType.LIST)
            .memberName("TransactStatements")
            .getter(getter(ExecuteTransactionRequest::transactStatements))
            .setter(setter(Builder::transactStatements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactStatements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterizedStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterizedStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(ExecuteTransactionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACT_STATEMENTS_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final List<ParameterizedStatement> transactStatements;

    private final String clientRequestToken;

    private ExecuteTransactionRequest(BuilderImpl builder) {
        super(builder);
        this.transactStatements = builder.transactStatements;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * Returns true if the TransactStatements property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTransactStatements() {
        return transactStatements != null && !(transactStatements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of PartiQL statements representing the transaction to run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTransactStatements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of PartiQL statements representing the transaction to run.
     */
    public final List<ParameterizedStatement> transactStatements() {
        return transactStatements;
    }

    /**
     * <p>
     * Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.
     * </p>
     * 
     * @return Set this value to get remaining results, if <code>NextToken</code> was returned in the statement
     *         response.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransactStatements() ? transactStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteTransactionRequest)) {
            return false;
        }
        ExecuteTransactionRequest other = (ExecuteTransactionRequest) obj;
        return hasTransactStatements() == other.hasTransactStatements()
                && Objects.equals(transactStatements(), other.transactStatements())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteTransactionRequest")
                .add("TransactStatements", hasTransactStatements() ? transactStatements() : null)
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransactStatements":
            return Optional.ofNullable(clazz.cast(transactStatements()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteTransactionRequest, T> g) {
        return obj -> g.apply((ExecuteTransactionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteTransactionRequest> {
        /**
         * <p>
         * The list of PartiQL statements representing the transaction to run.
         * </p>
         * 
         * @param transactStatements
         *        The list of PartiQL statements representing the transaction to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactStatements(Collection<ParameterizedStatement> transactStatements);

        /**
         * <p>
         * The list of PartiQL statements representing the transaction to run.
         * </p>
         * 
         * @param transactStatements
         *        The list of PartiQL statements representing the transaction to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactStatements(ParameterizedStatement... transactStatements);

        /**
         * <p>
         * The list of PartiQL statements representing the transaction to run.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterizedStatement>.Builder} avoiding
         * the need to create one manually via {@link List<ParameterizedStatement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterizedStatement>.Builder#build()} is called
         * immediately and its result is passed to {@link #transactStatements(List<ParameterizedStatement>)}.
         * 
         * @param transactStatements
         *        a consumer that will call methods on {@link List<ParameterizedStatement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transactStatements(List<ParameterizedStatement>)
         */
        Builder transactStatements(Consumer<ParameterizedStatement.Builder>... transactStatements);

        /**
         * <p>
         * Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.
         * </p>
         * 
         * @param clientRequestToken
         *        Set this value to get remaining results, if <code>NextToken</code> was returned in the statement
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private List<ParameterizedStatement> transactStatements = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteTransactionRequest model) {
            super(model);
            transactStatements(model.transactStatements);
            clientRequestToken(model.clientRequestToken);
        }

        public final List<ParameterizedStatement.Builder> getTransactStatements() {
            List<ParameterizedStatement.Builder> result = ParameterizedStatementsCopier.copyToBuilder(this.transactStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransactStatements(Collection<ParameterizedStatement.BuilderImpl> transactStatements) {
            this.transactStatements = ParameterizedStatementsCopier.copyFromBuilder(transactStatements);
        }

        @Override
        @Transient
        public final Builder transactStatements(Collection<ParameterizedStatement> transactStatements) {
            this.transactStatements = ParameterizedStatementsCopier.copy(transactStatements);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transactStatements(ParameterizedStatement... transactStatements) {
            transactStatements(Arrays.asList(transactStatements));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transactStatements(Consumer<ParameterizedStatement.Builder>... transactStatements) {
            transactStatements(Stream.of(transactStatements).map(c -> ParameterizedStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteTransactionRequest build() {
            return new ExecuteTransactionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
