/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to perform a <code>PutItem</code> operation on an item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRequest implements SdkPojo, Serializable, ToCopyableBuilder<PutRequest.Builder, PutRequest> {
    private static final SdkField<Map<String, AttributeValue>> ITEM_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("Item")
            .getter(getter(PutRequest::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, AttributeValue> item;

    private PutRequest(BuilderImpl builder) {
        this.item = builder.item;
    }

    /**
     * Returns true if the Item property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasItem() {
        return item != null && !(item instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of attribute name to attribute values, representing the primary key of an item to be processed by
     * <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must
     * match those of the table's key schema. If any attributes are present in the item that are part of an index key
     * schema for the table, their types must match the index key schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItem()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of attribute name to attribute values, representing the primary key of an item to be processed by
     *         <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types
     *         must match those of the table's key schema. If any attributes are present in the item that are part of an
     *         index key schema for the table, their types must match the index key schema.
     */
    public final Map<String, AttributeValue> item() {
        return item;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItem() ? item() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRequest)) {
            return false;
        }
        PutRequest other = (PutRequest) obj;
        return hasItem() == other.hasItem() && Objects.equals(item(), other.item());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRequest").add("Item", hasItem() ? item() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRequest, T> g) {
        return obj -> g.apply((PutRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PutRequest> {
        /**
         * <p>
         * A map of attribute name to attribute values, representing the primary key of an item to be processed by
         * <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must
         * match those of the table's key schema. If any attributes are present in the item that are part of an index
         * key schema for the table, their types must match the index key schema.
         * </p>
         * 
         * @param item
         *        A map of attribute name to attribute values, representing the primary key of an item to be processed
         *        by <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data
         *        types must match those of the table's key schema. If any attributes are present in the item that are
         *        part of an index key schema for the table, their types must match the index key schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Map<String, AttributeValue> item);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AttributeValue> item = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRequest model) {
            item(model.item);
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            Map<String, AttributeValue.Builder> result = PutItemInputAttributeMapCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = PutItemInputAttributeMapCopier.copyFromBuilder(item);
        }

        @Override
        @Transient
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        @Override
        public PutRequest build() {
            return new PutRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
