/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the description of the backup created for the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<BackupDescription.Builder, BackupDescription> {
    private static final SdkField<BackupDetails> BACKUP_DETAILS_FIELD = SdkField
            .<BackupDetails> builder(MarshallingType.SDK_POJO).memberName("BackupDetails")
            .getter(getter(BackupDescription::backupDetails)).setter(setter(Builder::backupDetails))
            .constructor(BackupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupDetails").build()).build();

    private static final SdkField<SourceTableDetails> SOURCE_TABLE_DETAILS_FIELD = SdkField
            .<SourceTableDetails> builder(MarshallingType.SDK_POJO).memberName("SourceTableDetails")
            .getter(getter(BackupDescription::sourceTableDetails)).setter(setter(Builder::sourceTableDetails))
            .constructor(SourceTableDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableDetails").build())
            .build();

    private static final SdkField<SourceTableFeatureDetails> SOURCE_TABLE_FEATURE_DETAILS_FIELD = SdkField
            .<SourceTableFeatureDetails> builder(MarshallingType.SDK_POJO).memberName("SourceTableFeatureDetails")
            .getter(getter(BackupDescription::sourceTableFeatureDetails)).setter(setter(Builder::sourceTableFeatureDetails))
            .constructor(SourceTableFeatureDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableFeatureDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_DETAILS_FIELD,
            SOURCE_TABLE_DETAILS_FIELD, SOURCE_TABLE_FEATURE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final BackupDetails backupDetails;

    private final SourceTableDetails sourceTableDetails;

    private final SourceTableFeatureDetails sourceTableFeatureDetails;

    private BackupDescription(BuilderImpl builder) {
        this.backupDetails = builder.backupDetails;
        this.sourceTableDetails = builder.sourceTableDetails;
        this.sourceTableFeatureDetails = builder.sourceTableFeatureDetails;
    }

    /**
     * <p>
     * Contains the details of the backup created for the table.
     * </p>
     * 
     * @return Contains the details of the backup created for the table.
     */
    public final BackupDetails backupDetails() {
        return backupDetails;
    }

    /**
     * <p>
     * Contains the details of the table when the backup was created.
     * </p>
     * 
     * @return Contains the details of the table when the backup was created.
     */
    public final SourceTableDetails sourceTableDetails() {
        return sourceTableDetails;
    }

    /**
     * <p>
     * Contains the details of the features enabled on the table when the backup was created. For example, LSIs, GSIs,
     * streams, TTL.
     * </p>
     * 
     * @return Contains the details of the features enabled on the table when the backup was created. For example, LSIs,
     *         GSIs, streams, TTL.
     */
    public final SourceTableFeatureDetails sourceTableFeatureDetails() {
        return sourceTableFeatureDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupDetails());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableDetails());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableFeatureDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupDescription)) {
            return false;
        }
        BackupDescription other = (BackupDescription) obj;
        return Objects.equals(backupDetails(), other.backupDetails())
                && Objects.equals(sourceTableDetails(), other.sourceTableDetails())
                && Objects.equals(sourceTableFeatureDetails(), other.sourceTableFeatureDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackupDescription").add("BackupDetails", backupDetails())
                .add("SourceTableDetails", sourceTableDetails()).add("SourceTableFeatureDetails", sourceTableFeatureDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupDetails":
            return Optional.ofNullable(clazz.cast(backupDetails()));
        case "SourceTableDetails":
            return Optional.ofNullable(clazz.cast(sourceTableDetails()));
        case "SourceTableFeatureDetails":
            return Optional.ofNullable(clazz.cast(sourceTableFeatureDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupDescription, T> g) {
        return obj -> g.apply((BackupDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackupDescription> {
        /**
         * <p>
         * Contains the details of the backup created for the table.
         * </p>
         * 
         * @param backupDetails
         *        Contains the details of the backup created for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupDetails(BackupDetails backupDetails);

        /**
         * <p>
         * Contains the details of the backup created for the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackupDetails.Builder} avoiding the need
         * to create one manually via {@link BackupDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackupDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #backupDetails(BackupDetails)}.
         * 
         * @param backupDetails
         *        a consumer that will call methods on {@link BackupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupDetails(BackupDetails)
         */
        default Builder backupDetails(Consumer<BackupDetails.Builder> backupDetails) {
            return backupDetails(BackupDetails.builder().applyMutation(backupDetails).build());
        }

        /**
         * <p>
         * Contains the details of the table when the backup was created.
         * </p>
         * 
         * @param sourceTableDetails
         *        Contains the details of the table when the backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableDetails(SourceTableDetails sourceTableDetails);

        /**
         * <p>
         * Contains the details of the table when the backup was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceTableDetails.Builder} avoiding the
         * need to create one manually via {@link SourceTableDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceTableDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceTableDetails(SourceTableDetails)}.
         * 
         * @param sourceTableDetails
         *        a consumer that will call methods on {@link SourceTableDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceTableDetails(SourceTableDetails)
         */
        default Builder sourceTableDetails(Consumer<SourceTableDetails.Builder> sourceTableDetails) {
            return sourceTableDetails(SourceTableDetails.builder().applyMutation(sourceTableDetails).build());
        }

        /**
         * <p>
         * Contains the details of the features enabled on the table when the backup was created. For example, LSIs,
         * GSIs, streams, TTL.
         * </p>
         * 
         * @param sourceTableFeatureDetails
         *        Contains the details of the features enabled on the table when the backup was created. For example,
         *        LSIs, GSIs, streams, TTL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableFeatureDetails(SourceTableFeatureDetails sourceTableFeatureDetails);

        /**
         * <p>
         * Contains the details of the features enabled on the table when the backup was created. For example, LSIs,
         * GSIs, streams, TTL.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceTableFeatureDetails.Builder}
         * avoiding the need to create one manually via {@link SourceTableFeatureDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceTableFeatureDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceTableFeatureDetails(SourceTableFeatureDetails)}.
         * 
         * @param sourceTableFeatureDetails
         *        a consumer that will call methods on {@link SourceTableFeatureDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceTableFeatureDetails(SourceTableFeatureDetails)
         */
        default Builder sourceTableFeatureDetails(Consumer<SourceTableFeatureDetails.Builder> sourceTableFeatureDetails) {
            return sourceTableFeatureDetails(SourceTableFeatureDetails.builder().applyMutation(sourceTableFeatureDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BackupDetails backupDetails;

        private SourceTableDetails sourceTableDetails;

        private SourceTableFeatureDetails sourceTableFeatureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupDescription model) {
            backupDetails(model.backupDetails);
            sourceTableDetails(model.sourceTableDetails);
            sourceTableFeatureDetails(model.sourceTableFeatureDetails);
        }

        public final BackupDetails.Builder getBackupDetails() {
            return backupDetails != null ? backupDetails.toBuilder() : null;
        }

        public final void setBackupDetails(BackupDetails.BuilderImpl backupDetails) {
            this.backupDetails = backupDetails != null ? backupDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder backupDetails(BackupDetails backupDetails) {
            this.backupDetails = backupDetails;
            return this;
        }

        public final SourceTableDetails.Builder getSourceTableDetails() {
            return sourceTableDetails != null ? sourceTableDetails.toBuilder() : null;
        }

        public final void setSourceTableDetails(SourceTableDetails.BuilderImpl sourceTableDetails) {
            this.sourceTableDetails = sourceTableDetails != null ? sourceTableDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceTableDetails(SourceTableDetails sourceTableDetails) {
            this.sourceTableDetails = sourceTableDetails;
            return this;
        }

        public final SourceTableFeatureDetails.Builder getSourceTableFeatureDetails() {
            return sourceTableFeatureDetails != null ? sourceTableFeatureDetails.toBuilder() : null;
        }

        public final void setSourceTableFeatureDetails(SourceTableFeatureDetails.BuilderImpl sourceTableFeatureDetails) {
            this.sourceTableFeatureDetails = sourceTableFeatureDetails != null ? sourceTableFeatureDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceTableFeatureDetails(SourceTableFeatureDetails sourceTableFeatureDetails) {
            this.sourceTableFeatureDetails = sourceTableFeatureDetails;
            return this;
        }

        @Override
        public BackupDescription build() {
            return new BackupDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
