/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteStatementRequest extends DynamoDbRequest implements
        ToCopyableBuilder<ExecuteStatementRequest.Builder, ExecuteStatementRequest> {
    private static final SdkField<String> STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Statement").getter(getter(ExecuteStatementRequest::statement)).setter(setter(Builder::statement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statement").build()).build();

    private static final SdkField<List<AttributeValue>> PARAMETERS_FIELD = SdkField
            .<List<AttributeValue>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(ExecuteStatementRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> CONSISTENT_READ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ConsistentRead").getter(getter(ExecuteStatementRequest::consistentRead))
            .setter(setter(Builder::consistentRead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistentRead").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ExecuteStatementRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReturnConsumedCapacity").getter(getter(ExecuteStatementRequest::returnConsumedCapacityAsString))
            .setter(setter(Builder::returnConsumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build())
            .build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ExecuteStatementRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_FIELD,
            PARAMETERS_FIELD, CONSISTENT_READ_FIELD, NEXT_TOKEN_FIELD, RETURN_CONSUMED_CAPACITY_FIELD, LIMIT_FIELD));

    private final String statement;

    private final List<AttributeValue> parameters;

    private final Boolean consistentRead;

    private final String nextToken;

    private final String returnConsumedCapacity;

    private final Integer limit;

    private ExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.statement = builder.statement;
        this.parameters = builder.parameters;
        this.consistentRead = builder.consistentRead;
        this.nextToken = builder.nextToken;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The PartiQL statement representing the operation to run.
     * </p>
     * 
     * @return The PartiQL statement representing the operation to run.
     */
    public final String statement() {
        return statement;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters for the PartiQL statement, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the PartiQL statement, if any.
     */
    public final List<AttributeValue> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used;
     * otherwise, an eventually consistent read is used.
     * </p>
     * 
     * @return The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is
     *         used; otherwise, an eventually consistent read is used.
     */
    public final Boolean consistentRead() {
        return consistentRead;
    }

    /**
     * <p>
     * Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.
     * </p>
     * 
     * @return Set this value to get remaining results, if <code>NextToken</code> was returned in the statement
     *         response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public final ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(returnConsumedCapacity);
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public final String returnConsumedCapacityAsString() {
        return returnConsumedCapacity;
    }

    /**
     * <p>
     * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the
     * number of items up to the limit while processing the results, it stops the operation and returns the matching
     * values up to that point, along with a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation so
     * you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this
     * limit, it stops the operation and returns the matching values up to the limit, and a key in
     * <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation.
     * </p>
     * 
     * @return The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB
     *         processes the number of items up to the limit while processing the results, it stops the operation and
     *         returns the matching values up to that point, along with a key in <code>LastEvaluatedKey</code> to apply
     *         in a subsequent operation so you can pick up where you left off. Also, if the processed dataset size
     *         exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values
     *         up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to
     *         continue the operation.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statement());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(consistentRead());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest) obj;
        return Objects.equals(statement(), other.statement()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(consistentRead(), other.consistentRead())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString())
                && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteStatementRequest").add("Statement", statement())
                .add("Parameters", hasParameters() ? parameters() : null).add("ConsistentRead", consistentRead())
                .add("NextToken", nextToken()).add("ReturnConsumedCapacity", returnConsumedCapacityAsString())
                .add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statement":
            return Optional.ofNullable(clazz.cast(statement()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ConsistentRead":
            return Optional.ofNullable(clazz.cast(consistentRead()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ReturnConsumedCapacity":
            return Optional.ofNullable(clazz.cast(returnConsumedCapacityAsString()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementRequest, T> g) {
        return obj -> g.apply((ExecuteStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteStatementRequest> {
        /**
         * <p>
         * The PartiQL statement representing the operation to run.
         * </p>
         * 
         * @param statement
         *        The PartiQL statement representing the operation to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statement(String statement);

        /**
         * <p>
         * The parameters for the PartiQL statement, if any.
         * </p>
         * 
         * @param parameters
         *        The parameters for the PartiQL statement, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<AttributeValue> parameters);

        /**
         * <p>
         * The parameters for the PartiQL statement, if any.
         * </p>
         * 
         * @param parameters
         *        The parameters for the PartiQL statement, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(AttributeValue... parameters);

        /**
         * <p>
         * The parameters for the PartiQL statement, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AttributeValue>.Builder} avoiding
         * the need to create one manually via {@link List<AttributeValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(List<AttributeValue>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<AttributeValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<AttributeValue>)
         */
        Builder parameters(Consumer<AttributeValue.Builder>... parameters);

        /**
         * <p>
         * The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used;
         * otherwise, an eventually consistent read is used.
         * </p>
         * 
         * @param consistentRead
         *        The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is
         *        used; otherwise, an eventually consistent read is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consistentRead(Boolean consistentRead);

        /**
         * <p>
         * Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.
         * </p>
         * 
         * @param nextToken
         *        Set this value to get remaining results, if <code>NextToken</code> was returned in the statement
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        /**
         * <p>
         * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes
         * the number of items up to the limit while processing the results, it stops the operation and returns the
         * matching values up to that point, along with a key in <code>LastEvaluatedKey</code> to apply in a subsequent
         * operation so you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
         * DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a
         * key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB
         *        processes the number of items up to the limit while processing the results, it stops the operation and
         *        returns the matching values up to that point, along with a key in <code>LastEvaluatedKey</code> to
         *        apply in a subsequent operation so you can pick up where you left off. Also, if the processed dataset
         *        size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching
         *        values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation
         *        to continue the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String statement;

        private List<AttributeValue> parameters = DefaultSdkAutoConstructList.getInstance();

        private Boolean consistentRead;

        private String nextToken;

        private String returnConsumedCapacity;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementRequest model) {
            super(model);
            statement(model.statement);
            parameters(model.parameters);
            consistentRead(model.consistentRead);
            nextToken(model.nextToken);
            returnConsumedCapacity(model.returnConsumedCapacity);
            limit(model.limit);
        }

        public final String getStatement() {
            return statement;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        @Override
        @Transient
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        public final List<AttributeValue.Builder> getParameters() {
            List<AttributeValue.Builder> result = PreparedStatementParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<AttributeValue.BuilderImpl> parameters) {
            this.parameters = PreparedStatementParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Collection<AttributeValue> parameters) {
            this.parameters = PreparedStatementParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(AttributeValue... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(Consumer<AttributeValue.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> AttributeValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getConsistentRead() {
            return consistentRead;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        @Override
        @Transient
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        @Transient
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        @Transient
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteStatementRequest build() {
            return new ExecuteStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
