/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteTransactionRequest extends DynamoDbRequest implements
        ToCopyableBuilder<ExecuteTransactionRequest.Builder, ExecuteTransactionRequest> {
    private static final SdkField<List<ParameterizedStatement>> TRANSACT_STATEMENTS_FIELD = SdkField
            .<List<ParameterizedStatement>> builder(MarshallingType.LIST)
            .memberName("TransactStatements")
            .getter(getter(ExecuteTransactionRequest::transactStatements))
            .setter(setter(Builder::transactStatements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactStatements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterizedStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterizedStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(ExecuteTransactionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReturnConsumedCapacity").getter(getter(ExecuteTransactionRequest::returnConsumedCapacityAsString))
            .setter(setter(Builder::returnConsumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACT_STATEMENTS_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, RETURN_CONSUMED_CAPACITY_FIELD));

    private final List<ParameterizedStatement> transactStatements;

    private final String clientRequestToken;

    private final String returnConsumedCapacity;

    private ExecuteTransactionRequest(BuilderImpl builder) {
        super(builder);
        this.transactStatements = builder.transactStatements;
        this.clientRequestToken = builder.clientRequestToken;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransactStatements property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransactStatements() {
        return transactStatements != null && !(transactStatements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of PartiQL statements representing the transaction to run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransactStatements} method.
     * </p>
     * 
     * @return The list of PartiQL statements representing the transaction to run.
     */
    public final List<ParameterizedStatement> transactStatements() {
        return transactStatements;
    }

    /**
     * <p>
     * Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.
     * </p>
     * 
     * @return Set this value to get remaining results, if <code>NextToken</code> was returned in the statement
     *         response.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in
     * the response. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html"
     * >TransactGetItems</a> and <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html"
     * >TransactWriteItems</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return Determines the level of detail about either provisioned or on-demand throughput consumption that is
     *         returned in the response. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html"
     *         >TransactGetItems</a> and <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html"
     *         >TransactWriteItems</a>.
     * @see ReturnConsumedCapacity
     */
    public final ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(returnConsumedCapacity);
    }

    /**
     * <p>
     * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in
     * the response. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html"
     * >TransactGetItems</a> and <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html"
     * >TransactWriteItems</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return Determines the level of detail about either provisioned or on-demand throughput consumption that is
     *         returned in the response. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html"
     *         >TransactGetItems</a> and <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html"
     *         >TransactWriteItems</a>.
     * @see ReturnConsumedCapacity
     */
    public final String returnConsumedCapacityAsString() {
        return returnConsumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransactStatements() ? transactStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(returnConsumedCapacityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteTransactionRequest)) {
            return false;
        }
        ExecuteTransactionRequest other = (ExecuteTransactionRequest) obj;
        return hasTransactStatements() == other.hasTransactStatements()
                && Objects.equals(transactStatements(), other.transactStatements())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteTransactionRequest")
                .add("TransactStatements", hasTransactStatements() ? transactStatements() : null)
                .add("ClientRequestToken", clientRequestToken()).add("ReturnConsumedCapacity", returnConsumedCapacityAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransactStatements":
            return Optional.ofNullable(clazz.cast(transactStatements()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "ReturnConsumedCapacity":
            return Optional.ofNullable(clazz.cast(returnConsumedCapacityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteTransactionRequest, T> g) {
        return obj -> g.apply((ExecuteTransactionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteTransactionRequest> {
        /**
         * <p>
         * The list of PartiQL statements representing the transaction to run.
         * </p>
         * 
         * @param transactStatements
         *        The list of PartiQL statements representing the transaction to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactStatements(Collection<ParameterizedStatement> transactStatements);

        /**
         * <p>
         * The list of PartiQL statements representing the transaction to run.
         * </p>
         * 
         * @param transactStatements
         *        The list of PartiQL statements representing the transaction to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactStatements(ParameterizedStatement... transactStatements);

        /**
         * <p>
         * The list of PartiQL statements representing the transaction to run.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ParameterizedStatement>.Builder}
         * avoiding the need to create one manually via {@link List<ParameterizedStatement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterizedStatement>.Builder#build()} is called
         * immediately and its result is passed to {@link #transactStatements(List<ParameterizedStatement>)}.
         * 
         * @param transactStatements
         *        a consumer that will call methods on {@link List<ParameterizedStatement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transactStatements(List<ParameterizedStatement>)
         */
        Builder transactStatements(Consumer<ParameterizedStatement.Builder>... transactStatements);

        /**
         * <p>
         * Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.
         * </p>
         * 
         * @param clientRequestToken
         *        Set this value to get remaining results, if <code>NextToken</code> was returned in the statement
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned
         * in the response. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html"
         * >TransactGetItems</a> and <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html"
         * >TransactWriteItems</a>.
         * </p>
         * 
         * @param returnConsumedCapacity
         *        Determines the level of detail about either provisioned or on-demand throughput consumption that is
         *        returned in the response. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html"
         *        >TransactGetItems</a> and <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html"
         *        >TransactWriteItems</a>.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * <p>
         * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned
         * in the response. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html"
         * >TransactGetItems</a> and <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html"
         * >TransactWriteItems</a>.
         * </p>
         * 
         * @param returnConsumedCapacity
         *        Determines the level of detail about either provisioned or on-demand throughput consumption that is
         *        returned in the response. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html"
         *        >TransactGetItems</a> and <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html"
         *        >TransactWriteItems</a>.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private List<ParameterizedStatement> transactStatements = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private String returnConsumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteTransactionRequest model) {
            super(model);
            transactStatements(model.transactStatements);
            clientRequestToken(model.clientRequestToken);
            returnConsumedCapacity(model.returnConsumedCapacity);
        }

        public final List<ParameterizedStatement.Builder> getTransactStatements() {
            List<ParameterizedStatement.Builder> result = ParameterizedStatementsCopier.copyToBuilder(this.transactStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransactStatements(Collection<ParameterizedStatement.BuilderImpl> transactStatements) {
            this.transactStatements = ParameterizedStatementsCopier.copyFromBuilder(transactStatements);
        }

        @Override
        @Transient
        public final Builder transactStatements(Collection<ParameterizedStatement> transactStatements) {
            this.transactStatements = ParameterizedStatementsCopier.copy(transactStatements);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transactStatements(ParameterizedStatement... transactStatements) {
            transactStatements(Arrays.asList(transactStatements));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transactStatements(Consumer<ParameterizedStatement.Builder>... transactStatements) {
            transactStatements(Stream.of(transactStatements).map(c -> ParameterizedStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        @Transient
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        @Transient
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteTransactionRequest build() {
            return new ExecuteTransactionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
