/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>Query</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryResponse extends DynamoDbResponse implements ToCopyableBuilder<QueryResponse.Builder, QueryResponse> {
    private static final SdkField<List<Map<String, AttributeValue>>> ITEMS_FIELD = SdkField
            .<List<Map<String, AttributeValue>>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(QueryResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, AttributeValue>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(AttributeValue::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(QueryResponse::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Integer> SCANNED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScannedCount").getter(getter(QueryResponse::scannedCount)).setter(setter(Builder::scannedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScannedCount").build()).build();

    private static final SdkField<Map<String, AttributeValue>> LAST_EVALUATED_KEY_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("LastEvaluatedKey")
            .getter(getter(QueryResponse::lastEvaluatedKey))
            .setter(setter(Builder::lastEvaluatedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedKey").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ConsumedCapacity> CONSUMED_CAPACITY_FIELD = SdkField
            .<ConsumedCapacity> builder(MarshallingType.SDK_POJO).memberName("ConsumedCapacity")
            .getter(getter(QueryResponse::consumedCapacity)).setter(setter(Builder::consumedCapacity))
            .constructor(ConsumedCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, COUNT_FIELD,
            SCANNED_COUNT_FIELD, LAST_EVALUATED_KEY_FIELD, CONSUMED_CAPACITY_FIELD));

    private final List<Map<String, AttributeValue>> items;

    private final Integer count;

    private final Integer scannedCount;

    private final Map<String, AttributeValue> lastEvaluatedKey;

    private final ConsumedCapacity consumedCapacity;

    private QueryResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.count = builder.count;
        this.scannedCount = builder.scannedCount;
        this.lastEvaluatedKey = builder.lastEvaluatedKey;
        this.consumedCapacity = builder.consumedCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of item attributes that match the query criteria. Each element in this array consists of an attribute
     * name and the value for that attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return An array of item attributes that match the query criteria. Each element in this array consists of an
     *         attribute name and the value for that attribute.
     */
    public final List<Map<String, AttributeValue>> items() {
        return items;
    }

    /**
     * <p>
     * The number of items in the response.
     * </p>
     * <p>
     * If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the number of items returned
     * after the filter was applied, and <code>ScannedCount</code> is the number of matching items before the filter was
     * applied.
     * </p>
     * <p>
     * If you did not use a filter in the request, then <code>Count</code> and <code>ScannedCount</code> are the same.
     * </p>
     * 
     * @return The number of items in the response.</p>
     *         <p>
     *         If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the number of items
     *         returned after the filter was applied, and <code>ScannedCount</code> is the number of matching items
     *         before the filter was applied.
     *         </p>
     *         <p>
     *         If you did not use a filter in the request, then <code>Count</code> and <code>ScannedCount</code> are the
     *         same.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The number of items evaluated, before any <code>QueryFilter</code> is applied. A high <code>ScannedCount</code>
     * value with few, or no, <code>Count</code> results indicates an inefficient <code>Query</code> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
     * ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If you did not use a filter in the request, then <code>ScannedCount</code> is the same as <code>Count</code>.
     * </p>
     * 
     * @return The number of items evaluated, before any <code>QueryFilter</code> is applied. A high
     *         <code>ScannedCount</code> value with few, or no, <code>Count</code> results indicates an inefficient
     *         <code>Query</code> operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
     *         ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
     *         <p>
     *         If you did not use a filter in the request, then <code>ScannedCount</code> is the same as
     *         <code>Count</code>.
     */
    public final Integer scannedCount() {
        return scannedCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastEvaluatedKey property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastEvaluatedKey() {
        return lastEvaluatedKey != null && !(lastEvaluatedKey instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to
     * start a new operation, excluding this value in the new request.
     * </p>
     * <p>
     * If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there is no
     * more data to be retrieved.
     * </p>
     * <p>
     * If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the result
     * set. The only way to know when you have reached the end of the result set is when <code>LastEvaluatedKey</code>
     * is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastEvaluatedKey} method.
     * </p>
     * 
     * @return The primary key of the item where the operation stopped, inclusive of the previous result set. Use this
     *         value to start a new operation, excluding this value in the new request.</p>
     *         <p>
     *         If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there
     *         is no more data to be retrieved.
     *         </p>
     *         <p>
     *         If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in
     *         the result set. The only way to know when you have reached the end of the result set is when
     *         <code>LastEvaluatedKey</code> is empty.
     */
    public final Map<String, AttributeValue> lastEvaluatedKey() {
        return lastEvaluatedKey;
    }

    /**
     * <p>
     * The capacity units consumed by the <code>Query</code> operation. The data returned includes the total provisioned
     * throughput consumed, along with statistics for the table and any indexes involved in the operation.
     * <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was
     * specified. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
     * >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The capacity units consumed by the <code>Query</code> operation. The data returned includes the total
     *         provisioned throughput consumed, along with statistics for the table and any indexes involved in the
     *         operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
     *         parameter was specified. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
     *         >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final ConsumedCapacity consumedCapacity() {
        return consumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(scannedCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasLastEvaluatedKey() ? lastEvaluatedKey() : null);
        hashCode = 31 * hashCode + Objects.hashCode(consumedCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items()) && Objects.equals(count(), other.count())
                && Objects.equals(scannedCount(), other.scannedCount()) && hasLastEvaluatedKey() == other.hasLastEvaluatedKey()
                && Objects.equals(lastEvaluatedKey(), other.lastEvaluatedKey())
                && Objects.equals(consumedCapacity(), other.consumedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryResponse").add("Items", hasItems() ? items() : null).add("Count", count())
                .add("ScannedCount", scannedCount()).add("LastEvaluatedKey", hasLastEvaluatedKey() ? lastEvaluatedKey() : null)
                .add("ConsumedCapacity", consumedCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "ScannedCount":
            return Optional.ofNullable(clazz.cast(scannedCount()));
        case "LastEvaluatedKey":
            return Optional.ofNullable(clazz.cast(lastEvaluatedKey()));
        case "ConsumedCapacity":
            return Optional.ofNullable(clazz.cast(consumedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryResponse, T> g) {
        return obj -> g.apply((QueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, QueryResponse> {
        /**
         * <p>
         * An array of item attributes that match the query criteria. Each element in this array consists of an
         * attribute name and the value for that attribute.
         * </p>
         * 
         * @param items
         *        An array of item attributes that match the query criteria. Each element in this array consists of an
         *        attribute name and the value for that attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<? extends Map<String, AttributeValue>> items);

        /**
         * <p>
         * An array of item attributes that match the query criteria. Each element in this array consists of an
         * attribute name and the value for that attribute.
         * </p>
         * 
         * @param items
         *        An array of item attributes that match the query criteria. Each element in this array consists of an
         *        attribute name and the value for that attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Map<String, AttributeValue>... items);

        /**
         * <p>
         * The number of items in the response.
         * </p>
         * <p>
         * If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the number of items
         * returned after the filter was applied, and <code>ScannedCount</code> is the number of matching items before
         * the filter was applied.
         * </p>
         * <p>
         * If you did not use a filter in the request, then <code>Count</code> and <code>ScannedCount</code> are the
         * same.
         * </p>
         * 
         * @param count
         *        The number of items in the response.</p>
         *        <p>
         *        If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the number of items
         *        returned after the filter was applied, and <code>ScannedCount</code> is the number of matching items
         *        before the filter was applied.
         *        </p>
         *        <p>
         *        If you did not use a filter in the request, then <code>Count</code> and <code>ScannedCount</code> are
         *        the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The number of items evaluated, before any <code>QueryFilter</code> is applied. A high
         * <code>ScannedCount</code> value with few, or no, <code>Count</code> results indicates an inefficient
         * <code>Query</code> operation. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
         * ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * If you did not use a filter in the request, then <code>ScannedCount</code> is the same as <code>Count</code>.
         * </p>
         * 
         * @param scannedCount
         *        The number of items evaluated, before any <code>QueryFilter</code> is applied. A high
         *        <code>ScannedCount</code> value with few, or no, <code>Count</code> results indicates an inefficient
         *        <code>Query</code> operation. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count
         *        and ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
         *        <p>
         *        If you did not use a filter in the request, then <code>ScannedCount</code> is the same as
         *        <code>Count</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scannedCount(Integer scannedCount);

        /**
         * <p>
         * The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value
         * to start a new operation, excluding this value in the new request.
         * </p>
         * <p>
         * If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there is no
         * more data to be retrieved.
         * </p>
         * <p>
         * If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the
         * result set. The only way to know when you have reached the end of the result set is when
         * <code>LastEvaluatedKey</code> is empty.
         * </p>
         * 
         * @param lastEvaluatedKey
         *        The primary key of the item where the operation stopped, inclusive of the previous result set. Use
         *        this value to start a new operation, excluding this value in the new request.</p>
         *        <p>
         *        If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and
         *        there is no more data to be retrieved.
         *        </p>
         *        <p>
         *        If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in
         *        the result set. The only way to know when you have reached the end of the result set is when
         *        <code>LastEvaluatedKey</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey);

        /**
         * <p>
         * The capacity units consumed by the <code>Query</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         * >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the <code>Query</code> operation. The data returned includes the total
         *        provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         *        operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         *        parameter was specified. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         *        >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity consumedCapacity);

        /**
         * <p>
         * The capacity units consumed by the <code>Query</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         * >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumedCapacity.Builder} avoiding the
         * need to create one manually via {@link ConsumedCapacity#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConsumedCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #consumedCapacity(ConsumedCapacity)}.
         * 
         * @param consumedCapacity
         *        a consumer that will call methods on {@link ConsumedCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedCapacity(ConsumedCapacity)
         */
        default Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return consumedCapacity(ConsumedCapacity.builder().applyMutation(consumedCapacity).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<Map<String, AttributeValue>> items = DefaultSdkAutoConstructList.getInstance();

        private Integer count;

        private Integer scannedCount;

        private Map<String, AttributeValue> lastEvaluatedKey = DefaultSdkAutoConstructMap.getInstance();

        private ConsumedCapacity consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResponse model) {
            super(model);
            items(model.items);
            count(model.count);
            scannedCount(model.scannedCount);
            lastEvaluatedKey(model.lastEvaluatedKey);
            consumedCapacity(model.consumedCapacity);
        }

        public final List<Map<String, AttributeValue.Builder>> getItems() {
            List<Map<String, AttributeValue.Builder>> result = ItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<? extends Map<String, AttributeValue.BuilderImpl>> items) {
            this.items = ItemListCopier.copyFromBuilder(items);
        }

        @Override
        @Transient
        public final Builder items(Collection<? extends Map<String, AttributeValue>> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(Map<String, AttributeValue>... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Integer getScannedCount() {
            return scannedCount;
        }

        public final void setScannedCount(Integer scannedCount) {
            this.scannedCount = scannedCount;
        }

        @Override
        @Transient
        public final Builder scannedCount(Integer scannedCount) {
            this.scannedCount = scannedCount;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getLastEvaluatedKey() {
            Map<String, AttributeValue.Builder> result = KeyCopier.copyToBuilder(this.lastEvaluatedKey);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLastEvaluatedKey(Map<String, AttributeValue.BuilderImpl> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copyFromBuilder(lastEvaluatedKey);
        }

        @Override
        @Transient
        public final Builder lastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copy(lastEvaluatedKey);
            return this;
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return consumedCapacity != null ? consumedCapacity.toBuilder() : null;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        @Override
        @Transient
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
