/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of a replica.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaSettingsDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaSettingsDescription.Builder, ReplicaSettingsDescription> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(ReplicaSettingsDescription::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<String> REPLICA_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicaStatus").getter(getter(ReplicaSettingsDescription::replicaStatusAsString))
            .setter(setter(Builder::replicaStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatus").build()).build();

    private static final SdkField<BillingModeSummary> REPLICA_BILLING_MODE_SUMMARY_FIELD = SdkField
            .<BillingModeSummary> builder(MarshallingType.SDK_POJO).memberName("ReplicaBillingModeSummary")
            .getter(getter(ReplicaSettingsDescription::replicaBillingModeSummary))
            .setter(setter(Builder::replicaBillingModeSummary)).constructor(BillingModeSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaBillingModeSummary").build())
            .build();

    private static final SdkField<Long> REPLICA_PROVISIONED_READ_CAPACITY_UNITS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ReplicaProvisionedReadCapacityUnits")
            .getter(getter(ReplicaSettingsDescription::replicaProvisionedReadCapacityUnits))
            .setter(setter(Builder::replicaProvisionedReadCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaProvisionedReadCapacityUnits").build()).build();

    private static final SdkField<AutoScalingSettingsDescription> REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField
            .<AutoScalingSettingsDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ReplicaProvisionedReadCapacityAutoScalingSettings")
            .getter(getter(ReplicaSettingsDescription::replicaProvisionedReadCapacityAutoScalingSettings))
            .setter(setter(Builder::replicaProvisionedReadCapacityAutoScalingSettings))
            .constructor(AutoScalingSettingsDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaProvisionedReadCapacityAutoScalingSettings").build()).build();

    private static final SdkField<Long> REPLICA_PROVISIONED_WRITE_CAPACITY_UNITS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ReplicaProvisionedWriteCapacityUnits")
            .getter(getter(ReplicaSettingsDescription::replicaProvisionedWriteCapacityUnits))
            .setter(setter(Builder::replicaProvisionedWriteCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaProvisionedWriteCapacityUnits").build()).build();

    private static final SdkField<AutoScalingSettingsDescription> REPLICA_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField
            .<AutoScalingSettingsDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ReplicaProvisionedWriteCapacityAutoScalingSettings")
            .getter(getter(ReplicaSettingsDescription::replicaProvisionedWriteCapacityAutoScalingSettings))
            .setter(setter(Builder::replicaProvisionedWriteCapacityAutoScalingSettings))
            .constructor(AutoScalingSettingsDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaProvisionedWriteCapacityAutoScalingSettings").build()).build();

    private static final SdkField<List<ReplicaGlobalSecondaryIndexSettingsDescription>> REPLICA_GLOBAL_SECONDARY_INDEX_SETTINGS_FIELD = SdkField
            .<List<ReplicaGlobalSecondaryIndexSettingsDescription>> builder(MarshallingType.LIST)
            .memberName("ReplicaGlobalSecondaryIndexSettings")
            .getter(getter(ReplicaSettingsDescription::replicaGlobalSecondaryIndexSettings))
            .setter(setter(Builder::replicaGlobalSecondaryIndexSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaGlobalSecondaryIndexSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaGlobalSecondaryIndexSettingsDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaGlobalSecondaryIndexSettingsDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TableClassSummary> REPLICA_TABLE_CLASS_SUMMARY_FIELD = SdkField
            .<TableClassSummary> builder(MarshallingType.SDK_POJO).memberName("ReplicaTableClassSummary")
            .getter(getter(ReplicaSettingsDescription::replicaTableClassSummary))
            .setter(setter(Builder::replicaTableClassSummary)).constructor(TableClassSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaTableClassSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            REPLICA_STATUS_FIELD, REPLICA_BILLING_MODE_SUMMARY_FIELD, REPLICA_PROVISIONED_READ_CAPACITY_UNITS_FIELD,
            REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD, REPLICA_PROVISIONED_WRITE_CAPACITY_UNITS_FIELD,
            REPLICA_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD, REPLICA_GLOBAL_SECONDARY_INDEX_SETTINGS_FIELD,
            REPLICA_TABLE_CLASS_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final String replicaStatus;

    private final BillingModeSummary replicaBillingModeSummary;

    private final Long replicaProvisionedReadCapacityUnits;

    private final AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings;

    private final Long replicaProvisionedWriteCapacityUnits;

    private final AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings;

    private final List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings;

    private final TableClassSummary replicaTableClassSummary;

    private ReplicaSettingsDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaStatus = builder.replicaStatus;
        this.replicaBillingModeSummary = builder.replicaBillingModeSummary;
        this.replicaProvisionedReadCapacityUnits = builder.replicaProvisionedReadCapacityUnits;
        this.replicaProvisionedReadCapacityAutoScalingSettings = builder.replicaProvisionedReadCapacityAutoScalingSettings;
        this.replicaProvisionedWriteCapacityUnits = builder.replicaProvisionedWriteCapacityUnits;
        this.replicaProvisionedWriteCapacityAutoScalingSettings = builder.replicaProvisionedWriteCapacityAutoScalingSettings;
        this.replicaGlobalSecondaryIndexSettings = builder.replicaGlobalSecondaryIndexSettings;
        this.replicaTableClassSummary = builder.replicaTableClassSummary;
    }

    /**
     * <p>
     * The Region name of the replica.
     * </p>
     * 
     * @return The Region name of the replica.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The current state of the Region:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The Region is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The Region is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The Region is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The Region is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaStatus}
     * will return {@link ReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaStatusAsString}.
     * </p>
     * 
     * @return The current state of the Region:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The Region is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The Region is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The Region is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The Region is ready for use.
     *         </p>
     *         </li>
     * @see ReplicaStatus
     */
    public final ReplicaStatus replicaStatus() {
        return ReplicaStatus.fromValue(replicaStatus);
    }

    /**
     * <p>
     * The current state of the Region:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The Region is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The Region is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The Region is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The Region is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaStatus}
     * will return {@link ReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaStatusAsString}.
     * </p>
     * 
     * @return The current state of the Region:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The Region is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The Region is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The Region is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The Region is ready for use.
     *         </p>
     *         </li>
     * @see ReplicaStatus
     */
    public final String replicaStatusAsString() {
        return replicaStatus;
    }

    /**
     * <p>
     * The read/write capacity mode of the replica.
     * </p>
     * 
     * @return The read/write capacity mode of the replica.
     */
    public final BillingModeSummary replicaBillingModeSummary() {
        return replicaBillingModeSummary;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     *         >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final Long replicaProvisionedReadCapacityUnits() {
        return replicaProvisionedReadCapacityUnits;
    }

    /**
     * <p>
     * Auto scaling settings for a global table replica's read capacity units.
     * </p>
     * 
     * @return Auto scaling settings for a global table replica's read capacity units.
     */
    public final AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings() {
        return replicaProvisionedReadCapacityAutoScalingSettings;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     *         >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final Long replicaProvisionedWriteCapacityUnits() {
        return replicaProvisionedWriteCapacityUnits;
    }

    /**
     * <p>
     * Auto scaling settings for a global table replica's write capacity units.
     * </p>
     * 
     * @return Auto scaling settings for a global table replica's write capacity units.
     */
    public final AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings() {
        return replicaProvisionedWriteCapacityAutoScalingSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicaGlobalSecondaryIndexSettings
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReplicaGlobalSecondaryIndexSettings() {
        return replicaGlobalSecondaryIndexSettings != null
                && !(replicaGlobalSecondaryIndexSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Replica global secondary index settings for the global table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicaGlobalSecondaryIndexSettings}
     * method.
     * </p>
     * 
     * @return Replica global secondary index settings for the global table.
     */
    public final List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings() {
        return replicaGlobalSecondaryIndexSettings;
    }

    /**
     * Returns the value of the ReplicaTableClassSummary property for this object.
     * 
     * @return The value of the ReplicaTableClassSummary property for this object.
     */
    public final TableClassSummary replicaTableClassSummary() {
        return replicaTableClassSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(replicaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicaBillingModeSummary());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedReadCapacityAutoScalingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedWriteCapacityAutoScalingSettings());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicaGlobalSecondaryIndexSettings() ? replicaGlobalSecondaryIndexSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicaTableClassSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSettingsDescription)) {
            return false;
        }
        ReplicaSettingsDescription other = (ReplicaSettingsDescription) obj;
        return Objects.equals(regionName(), other.regionName())
                && Objects.equals(replicaStatusAsString(), other.replicaStatusAsString())
                && Objects.equals(replicaBillingModeSummary(), other.replicaBillingModeSummary())
                && Objects.equals(replicaProvisionedReadCapacityUnits(), other.replicaProvisionedReadCapacityUnits())
                && Objects.equals(replicaProvisionedReadCapacityAutoScalingSettings(),
                        other.replicaProvisionedReadCapacityAutoScalingSettings())
                && Objects.equals(replicaProvisionedWriteCapacityUnits(), other.replicaProvisionedWriteCapacityUnits())
                && Objects.equals(replicaProvisionedWriteCapacityAutoScalingSettings(),
                        other.replicaProvisionedWriteCapacityAutoScalingSettings())
                && hasReplicaGlobalSecondaryIndexSettings() == other.hasReplicaGlobalSecondaryIndexSettings()
                && Objects.equals(replicaGlobalSecondaryIndexSettings(), other.replicaGlobalSecondaryIndexSettings())
                && Objects.equals(replicaTableClassSummary(), other.replicaTableClassSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ReplicaSettingsDescription")
                .add("RegionName", regionName())
                .add("ReplicaStatus", replicaStatusAsString())
                .add("ReplicaBillingModeSummary", replicaBillingModeSummary())
                .add("ReplicaProvisionedReadCapacityUnits", replicaProvisionedReadCapacityUnits())
                .add("ReplicaProvisionedReadCapacityAutoScalingSettings", replicaProvisionedReadCapacityAutoScalingSettings())
                .add("ReplicaProvisionedWriteCapacityUnits", replicaProvisionedWriteCapacityUnits())
                .add("ReplicaProvisionedWriteCapacityAutoScalingSettings", replicaProvisionedWriteCapacityAutoScalingSettings())
                .add("ReplicaGlobalSecondaryIndexSettings",
                        hasReplicaGlobalSecondaryIndexSettings() ? replicaGlobalSecondaryIndexSettings() : null)
                .add("ReplicaTableClassSummary", replicaTableClassSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "ReplicaStatus":
            return Optional.ofNullable(clazz.cast(replicaStatusAsString()));
        case "ReplicaBillingModeSummary":
            return Optional.ofNullable(clazz.cast(replicaBillingModeSummary()));
        case "ReplicaProvisionedReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(replicaProvisionedReadCapacityUnits()));
        case "ReplicaProvisionedReadCapacityAutoScalingSettings":
            return Optional.ofNullable(clazz.cast(replicaProvisionedReadCapacityAutoScalingSettings()));
        case "ReplicaProvisionedWriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(replicaProvisionedWriteCapacityUnits()));
        case "ReplicaProvisionedWriteCapacityAutoScalingSettings":
            return Optional.ofNullable(clazz.cast(replicaProvisionedWriteCapacityAutoScalingSettings()));
        case "ReplicaGlobalSecondaryIndexSettings":
            return Optional.ofNullable(clazz.cast(replicaGlobalSecondaryIndexSettings()));
        case "ReplicaTableClassSummary":
            return Optional.ofNullable(clazz.cast(replicaTableClassSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaSettingsDescription, T> g) {
        return obj -> g.apply((ReplicaSettingsDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaSettingsDescription> {
        /**
         * <p>
         * The Region name of the replica.
         * </p>
         * 
         * @param regionName
         *        The Region name of the replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The current state of the Region:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The Region is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The Region is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The Region is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The Region is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicaStatus
         *        The current state of the Region:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The Region is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The Region is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The Region is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The Region is ready for use.
         *        </p>
         *        </li>
         * @see ReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaStatus
         */
        Builder replicaStatus(String replicaStatus);

        /**
         * <p>
         * The current state of the Region:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The Region is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The Region is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The Region is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The Region is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicaStatus
         *        The current state of the Region:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The Region is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The Region is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The Region is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The Region is ready for use.
         *        </p>
         *        </li>
         * @see ReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaStatus
         */
        Builder replicaStatus(ReplicaStatus replicaStatus);

        /**
         * <p>
         * The read/write capacity mode of the replica.
         * </p>
         * 
         * @param replicaBillingModeSummary
         *        The read/write capacity mode of the replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaBillingModeSummary(BillingModeSummary replicaBillingModeSummary);

        /**
         * <p>
         * The read/write capacity mode of the replica.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillingModeSummary.Builder} avoiding the
         * need to create one manually via {@link BillingModeSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link BillingModeSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #replicaBillingModeSummary(BillingModeSummary)}.
         * 
         * @param replicaBillingModeSummary
         *        a consumer that will call methods on {@link BillingModeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaBillingModeSummary(BillingModeSummary)
         */
        default Builder replicaBillingModeSummary(Consumer<BillingModeSummary.Builder> replicaBillingModeSummary) {
            return replicaBillingModeSummary(BillingModeSummary.builder().applyMutation(replicaBillingModeSummary).build());
        }

        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param replicaProvisionedReadCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         *        >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits);

        /**
         * <p>
         * Auto scaling settings for a global table replica's read capacity units.
         * </p>
         * 
         * @param replicaProvisionedReadCapacityAutoScalingSettings
         *        Auto scaling settings for a global table replica's read capacity units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedReadCapacityAutoScalingSettings(
                AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings);

        /**
         * <p>
         * Auto scaling settings for a global table replica's read capacity units.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingSettingsDescription.Builder}
         * avoiding the need to create one manually via {@link AutoScalingSettingsDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription)}.
         * 
         * @param replicaProvisionedReadCapacityAutoScalingSettings
         *        a consumer that will call methods on {@link AutoScalingSettingsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription)
         */
        default Builder replicaProvisionedReadCapacityAutoScalingSettings(
                Consumer<AutoScalingSettingsDescription.Builder> replicaProvisionedReadCapacityAutoScalingSettings) {
            return replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription.builder()
                    .applyMutation(replicaProvisionedReadCapacityAutoScalingSettings).build());
        }

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param replicaProvisionedWriteCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         *        >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedWriteCapacityUnits(Long replicaProvisionedWriteCapacityUnits);

        /**
         * <p>
         * Auto scaling settings for a global table replica's write capacity units.
         * </p>
         * 
         * @param replicaProvisionedWriteCapacityAutoScalingSettings
         *        Auto scaling settings for a global table replica's write capacity units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedWriteCapacityAutoScalingSettings(
                AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings);

        /**
         * <p>
         * Auto scaling settings for a global table replica's write capacity units.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingSettingsDescription.Builder}
         * avoiding the need to create one manually via {@link AutoScalingSettingsDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription)}.
         * 
         * @param replicaProvisionedWriteCapacityAutoScalingSettings
         *        a consumer that will call methods on {@link AutoScalingSettingsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription)
         */
        default Builder replicaProvisionedWriteCapacityAutoScalingSettings(
                Consumer<AutoScalingSettingsDescription.Builder> replicaProvisionedWriteCapacityAutoScalingSettings) {
            return replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription.builder()
                    .applyMutation(replicaProvisionedWriteCapacityAutoScalingSettings).build());
        }

        /**
         * <p>
         * Replica global secondary index settings for the global table.
         * </p>
         * 
         * @param replicaGlobalSecondaryIndexSettings
         *        Replica global secondary index settings for the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaGlobalSecondaryIndexSettings(
                Collection<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings);

        /**
         * <p>
         * Replica global secondary index settings for the global table.
         * </p>
         * 
         * @param replicaGlobalSecondaryIndexSettings
         *        Replica global secondary index settings for the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaGlobalSecondaryIndexSettings(
                ReplicaGlobalSecondaryIndexSettingsDescription... replicaGlobalSecondaryIndexSettings);

        /**
         * <p>
         * Replica global secondary index settings for the global table.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ReplicaGlobalSecondaryIndexSettingsDescription>.Builder} avoiding the need to create one manually via
         * {@link List<ReplicaGlobalSecondaryIndexSettingsDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <ReplicaGlobalSecondaryIndexSettingsDescription>.Builder#build()} is called immediately and its result is
         * passed to {@link #replicaGlobalSecondaryIndexSettings(List<ReplicaGlobalSecondaryIndexSettingsDescription>)}.
         * 
         * @param replicaGlobalSecondaryIndexSettings
         *        a consumer that will call methods on {@link List
         *        <ReplicaGlobalSecondaryIndexSettingsDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaGlobalSecondaryIndexSettings(List<ReplicaGlobalSecondaryIndexSettingsDescription>)
         */
        Builder replicaGlobalSecondaryIndexSettings(
                Consumer<ReplicaGlobalSecondaryIndexSettingsDescription.Builder>... replicaGlobalSecondaryIndexSettings);

        /**
         * Sets the value of the ReplicaTableClassSummary property for this object.
         *
         * @param replicaTableClassSummary
         *        The new value for the ReplicaTableClassSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaTableClassSummary(TableClassSummary replicaTableClassSummary);

        /**
         * Sets the value of the ReplicaTableClassSummary property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TableClassSummary.Builder} avoiding the
         * need to create one manually via {@link TableClassSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableClassSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #replicaTableClassSummary(TableClassSummary)}.
         * 
         * @param replicaTableClassSummary
         *        a consumer that will call methods on {@link TableClassSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaTableClassSummary(TableClassSummary)
         */
        default Builder replicaTableClassSummary(Consumer<TableClassSummary.Builder> replicaTableClassSummary) {
            return replicaTableClassSummary(TableClassSummary.builder().applyMutation(replicaTableClassSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private String replicaStatus;

        private BillingModeSummary replicaBillingModeSummary;

        private Long replicaProvisionedReadCapacityUnits;

        private AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings;

        private Long replicaProvisionedWriteCapacityUnits;

        private AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings;

        private List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings = DefaultSdkAutoConstructList
                .getInstance();

        private TableClassSummary replicaTableClassSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSettingsDescription model) {
            regionName(model.regionName);
            replicaStatus(model.replicaStatus);
            replicaBillingModeSummary(model.replicaBillingModeSummary);
            replicaProvisionedReadCapacityUnits(model.replicaProvisionedReadCapacityUnits);
            replicaProvisionedReadCapacityAutoScalingSettings(model.replicaProvisionedReadCapacityAutoScalingSettings);
            replicaProvisionedWriteCapacityUnits(model.replicaProvisionedWriteCapacityUnits);
            replicaProvisionedWriteCapacityAutoScalingSettings(model.replicaProvisionedWriteCapacityAutoScalingSettings);
            replicaGlobalSecondaryIndexSettings(model.replicaGlobalSecondaryIndexSettings);
            replicaTableClassSummary(model.replicaTableClassSummary);
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        @Transient
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getReplicaStatus() {
            return replicaStatus;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        @Override
        @Transient
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder replicaStatus(ReplicaStatus replicaStatus) {
            this.replicaStatus(replicaStatus == null ? null : replicaStatus.toString());
            return this;
        }

        public final BillingModeSummary.Builder getReplicaBillingModeSummary() {
            return replicaBillingModeSummary != null ? replicaBillingModeSummary.toBuilder() : null;
        }

        public final void setReplicaBillingModeSummary(BillingModeSummary.BuilderImpl replicaBillingModeSummary) {
            this.replicaBillingModeSummary = replicaBillingModeSummary != null ? replicaBillingModeSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder replicaBillingModeSummary(BillingModeSummary replicaBillingModeSummary) {
            this.replicaBillingModeSummary = replicaBillingModeSummary;
            return this;
        }

        public final Long getReplicaProvisionedReadCapacityUnits() {
            return replicaProvisionedReadCapacityUnits;
        }

        public final void setReplicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
        }

        @Override
        @Transient
        public final Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
            return this;
        }

        public final AutoScalingSettingsDescription.Builder getReplicaProvisionedReadCapacityAutoScalingSettings() {
            return replicaProvisionedReadCapacityAutoScalingSettings != null ? replicaProvisionedReadCapacityAutoScalingSettings
                    .toBuilder() : null;
        }

        public final void setReplicaProvisionedReadCapacityAutoScalingSettings(
                AutoScalingSettingsDescription.BuilderImpl replicaProvisionedReadCapacityAutoScalingSettings) {
            this.replicaProvisionedReadCapacityAutoScalingSettings = replicaProvisionedReadCapacityAutoScalingSettings != null ? replicaProvisionedReadCapacityAutoScalingSettings
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder replicaProvisionedReadCapacityAutoScalingSettings(
                AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings) {
            this.replicaProvisionedReadCapacityAutoScalingSettings = replicaProvisionedReadCapacityAutoScalingSettings;
            return this;
        }

        public final Long getReplicaProvisionedWriteCapacityUnits() {
            return replicaProvisionedWriteCapacityUnits;
        }

        public final void setReplicaProvisionedWriteCapacityUnits(Long replicaProvisionedWriteCapacityUnits) {
            this.replicaProvisionedWriteCapacityUnits = replicaProvisionedWriteCapacityUnits;
        }

        @Override
        @Transient
        public final Builder replicaProvisionedWriteCapacityUnits(Long replicaProvisionedWriteCapacityUnits) {
            this.replicaProvisionedWriteCapacityUnits = replicaProvisionedWriteCapacityUnits;
            return this;
        }

        public final AutoScalingSettingsDescription.Builder getReplicaProvisionedWriteCapacityAutoScalingSettings() {
            return replicaProvisionedWriteCapacityAutoScalingSettings != null ? replicaProvisionedWriteCapacityAutoScalingSettings
                    .toBuilder() : null;
        }

        public final void setReplicaProvisionedWriteCapacityAutoScalingSettings(
                AutoScalingSettingsDescription.BuilderImpl replicaProvisionedWriteCapacityAutoScalingSettings) {
            this.replicaProvisionedWriteCapacityAutoScalingSettings = replicaProvisionedWriteCapacityAutoScalingSettings != null ? replicaProvisionedWriteCapacityAutoScalingSettings
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder replicaProvisionedWriteCapacityAutoScalingSettings(
                AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings) {
            this.replicaProvisionedWriteCapacityAutoScalingSettings = replicaProvisionedWriteCapacityAutoScalingSettings;
            return this;
        }

        public final List<ReplicaGlobalSecondaryIndexSettingsDescription.Builder> getReplicaGlobalSecondaryIndexSettings() {
            List<ReplicaGlobalSecondaryIndexSettingsDescription.Builder> result = ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier
                    .copyToBuilder(this.replicaGlobalSecondaryIndexSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaGlobalSecondaryIndexSettings(
                Collection<ReplicaGlobalSecondaryIndexSettingsDescription.BuilderImpl> replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings = ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier
                    .copyFromBuilder(replicaGlobalSecondaryIndexSettings);
        }

        @Override
        @Transient
        public final Builder replicaGlobalSecondaryIndexSettings(
                Collection<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings = ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier
                    .copy(replicaGlobalSecondaryIndexSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettings(
                ReplicaGlobalSecondaryIndexSettingsDescription... replicaGlobalSecondaryIndexSettings) {
            replicaGlobalSecondaryIndexSettings(Arrays.asList(replicaGlobalSecondaryIndexSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettings(
                Consumer<ReplicaGlobalSecondaryIndexSettingsDescription.Builder>... replicaGlobalSecondaryIndexSettings) {
            replicaGlobalSecondaryIndexSettings(Stream.of(replicaGlobalSecondaryIndexSettings)
                    .map(c -> ReplicaGlobalSecondaryIndexSettingsDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TableClassSummary.Builder getReplicaTableClassSummary() {
            return replicaTableClassSummary != null ? replicaTableClassSummary.toBuilder() : null;
        }

        public final void setReplicaTableClassSummary(TableClassSummary.BuilderImpl replicaTableClassSummary) {
            this.replicaTableClassSummary = replicaTableClassSummary != null ? replicaTableClassSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder replicaTableClassSummary(TableClassSummary replicaTableClassSummary) {
            this.replicaTableClassSummary = replicaTableClassSummary;
            return this;
        }

        @Override
        public ReplicaSettingsDescription build() {
            return new ReplicaSettingsDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
