/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * A new replica to be added to an existing global table.
 * </p>
 * </li>
 * <li>
 * <p>
 * New parameters for an existing replica.
 * </p>
 * </li>
 * <li>
 * <p>
 * An existing replica to be removed from an existing global table.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaUpdate implements SdkPojo, Serializable, ToCopyableBuilder<ReplicaUpdate.Builder, ReplicaUpdate> {
    private static final SdkField<CreateReplicaAction> CREATE_FIELD = SdkField
            .<CreateReplicaAction> builder(MarshallingType.SDK_POJO).memberName("Create").getter(getter(ReplicaUpdate::create))
            .setter(setter(Builder::create)).constructor(CreateReplicaAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Create").build()).build();

    private static final SdkField<DeleteReplicaAction> DELETE_FIELD = SdkField
            .<DeleteReplicaAction> builder(MarshallingType.SDK_POJO).memberName("Delete").getter(getter(ReplicaUpdate::delete))
            .setter(setter(Builder::delete)).constructor(DeleteReplicaAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_FIELD, DELETE_FIELD));

    private static final long serialVersionUID = 1L;

    private final CreateReplicaAction create;

    private final DeleteReplicaAction delete;

    private ReplicaUpdate(BuilderImpl builder) {
        this.create = builder.create;
        this.delete = builder.delete;
    }

    /**
     * <p>
     * The parameters required for creating a replica on an existing global table.
     * </p>
     * 
     * @return The parameters required for creating a replica on an existing global table.
     */
    public final CreateReplicaAction create() {
        return create;
    }

    /**
     * <p>
     * The name of the existing replica to be removed.
     * </p>
     * 
     * @return The name of the existing replica to be removed.
     */
    public final DeleteReplicaAction delete() {
        return delete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(create());
        hashCode = 31 * hashCode + Objects.hashCode(delete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaUpdate)) {
            return false;
        }
        ReplicaUpdate other = (ReplicaUpdate) obj;
        return Objects.equals(create(), other.create()) && Objects.equals(delete(), other.delete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaUpdate").add("Create", create()).add("Delete", delete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Create":
            return Optional.ofNullable(clazz.cast(create()));
        case "Delete":
            return Optional.ofNullable(clazz.cast(delete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaUpdate, T> g) {
        return obj -> g.apply((ReplicaUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaUpdate> {
        /**
         * <p>
         * The parameters required for creating a replica on an existing global table.
         * </p>
         * 
         * @param create
         *        The parameters required for creating a replica on an existing global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder create(CreateReplicaAction create);

        /**
         * <p>
         * The parameters required for creating a replica on an existing global table.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateReplicaAction.Builder} avoiding the
         * need to create one manually via {@link CreateReplicaAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateReplicaAction.Builder#build()} is called immediately and
         * its result is passed to {@link #create(CreateReplicaAction)}.
         * 
         * @param create
         *        a consumer that will call methods on {@link CreateReplicaAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #create(CreateReplicaAction)
         */
        default Builder create(Consumer<CreateReplicaAction.Builder> create) {
            return create(CreateReplicaAction.builder().applyMutation(create).build());
        }

        /**
         * <p>
         * The name of the existing replica to be removed.
         * </p>
         * 
         * @param delete
         *        The name of the existing replica to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delete(DeleteReplicaAction delete);

        /**
         * <p>
         * The name of the existing replica to be removed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteReplicaAction.Builder} avoiding the
         * need to create one manually via {@link DeleteReplicaAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteReplicaAction.Builder#build()} is called immediately and
         * its result is passed to {@link #delete(DeleteReplicaAction)}.
         * 
         * @param delete
         *        a consumer that will call methods on {@link DeleteReplicaAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delete(DeleteReplicaAction)
         */
        default Builder delete(Consumer<DeleteReplicaAction.Builder> delete) {
            return delete(DeleteReplicaAction.builder().applyMutation(delete).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CreateReplicaAction create;

        private DeleteReplicaAction delete;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaUpdate model) {
            create(model.create);
            delete(model.delete);
        }

        public final CreateReplicaAction.Builder getCreate() {
            return create != null ? create.toBuilder() : null;
        }

        public final void setCreate(CreateReplicaAction.BuilderImpl create) {
            this.create = create != null ? create.build() : null;
        }

        @Override
        @Transient
        public final Builder create(CreateReplicaAction create) {
            this.create = create;
            return this;
        }

        public final DeleteReplicaAction.Builder getDelete() {
            return delete != null ? delete.toBuilder() : null;
        }

        public final void setDelete(DeleteReplicaAction.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        @Override
        @Transient
        public final Builder delete(DeleteReplicaAction delete) {
            this.delete = delete;
            return this;
        }

        @Override
        public ReplicaUpdate build() {
            return new ReplicaUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
