/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>BatchWriteItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchWriteItemRequest extends DynamoDbRequest implements
        ToCopyableBuilder<BatchWriteItemRequest.Builder, BatchWriteItemRequest> {
    private static final SdkField<Map<String, List<WriteRequest>>> REQUEST_ITEMS_FIELD = SdkField
            .<Map<String, List<WriteRequest>>> builder(MarshallingType.MAP)
            .memberName("RequestItems")
            .getter(getter(BatchWriteItemRequest::requestItems))
            .setter(setter(Builder::requestItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestItems").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<WriteRequest>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<WriteRequest> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(WriteRequest::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReturnConsumedCapacity").getter(getter(BatchWriteItemRequest::returnConsumedCapacityAsString))
            .setter(setter(Builder::returnConsumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build())
            .build();

    private static final SdkField<String> RETURN_ITEM_COLLECTION_METRICS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReturnItemCollectionMetrics")
            .getter(getter(BatchWriteItemRequest::returnItemCollectionMetricsAsString))
            .setter(setter(Builder::returnItemCollectionMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnItemCollectionMetrics")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ITEMS_FIELD,
            RETURN_CONSUMED_CAPACITY_FIELD, RETURN_ITEM_COLLECTION_METRICS_FIELD));

    private final Map<String, List<WriteRequest>> requestItems;

    private final String returnConsumedCapacity;

    private final String returnItemCollectionMetrics;

    private BatchWriteItemRequest(BuilderImpl builder) {
        super(builder);
        this.requestItems = builder.requestItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
    }

    /**
     * Returns true if the RequestItems property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRequestItems() {
        return requestItems != null && !(requestItems instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of one or more table names and, for each table, a list of operations to be performed (
     * <code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to be
     * deleted is identified by a <code>Key</code> subelement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this map
     * consists of an attribute name and an attribute value. For each primary key, you must provide <i>all</i> of the
     * key attributes. For example, with a simple primary key, you only need to provide a value for the partition key.
     * For a composite primary key, you must provide values for <i>both</i> the partition key and the sort key.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put is
     * identified by an <code>Item</code> subelement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute name
     * and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths
     * greater than zero; and set type attributes must not be empty. Requests that contain empty values are rejected
     * with a <code>ValidationException</code> exception.
     * </p>
     * <p>
     * If you specify any attributes that are part of an index key, then the data types for those attributes must match
     * those of the schema in the table's attribute definition.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequestItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of one or more table names and, for each table, a list of operations to be performed (
     *         <code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item
     *         to be deleted is identified by a <code>Key</code> subelement:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in
     *         this map consists of an attribute name and an attribute value. For each primary key, you must provide
     *         <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide a
     *         value for the partition key. For a composite primary key, you must provide values for <i>both</i> the
     *         partition key and the sort key.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be
     *         put is identified by an <code>Item</code> subelement:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute
     *         name and an attribute value. Attribute values must not be null; string and binary type attributes must
     *         have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty
     *         values are rejected with a <code>ValidationException</code> exception.
     *         </p>
     *         <p>
     *         If you specify any attributes that are part of an index key, then the data types for those attributes
     *         must match those of the schema in the table's attribute definition.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final Map<String, List<WriteRequest>> requestItems() {
        return requestItems;
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public final ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(returnConsumedCapacity);
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public final String returnConsumedCapacityAsString() {
        return returnConsumedCapacity;
    }

    /**
     * <p>
     * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
     * statistics about item collections, if any, that were modified during the operation are returned in the response.
     * If set to <code>NONE</code> (the default), no statistics are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnItemCollectionMetrics} will return {@link ReturnItemCollectionMetrics#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #returnItemCollectionMetricsAsString}.
     * </p>
     * 
     * @return Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
     *         includes statistics about item collections, if any, that were modified during the operation are returned
     *         in the response. If set to <code>NONE</code> (the default), no statistics are returned.
     * @see ReturnItemCollectionMetrics
     */
    public final ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue(returnItemCollectionMetrics);
    }

    /**
     * <p>
     * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
     * statistics about item collections, if any, that were modified during the operation are returned in the response.
     * If set to <code>NONE</code> (the default), no statistics are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnItemCollectionMetrics} will return {@link ReturnItemCollectionMetrics#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #returnItemCollectionMetricsAsString}.
     * </p>
     * 
     * @return Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
     *         includes statistics about item collections, if any, that were modified during the operation are returned
     *         in the response. If set to <code>NONE</code> (the default), no statistics are returned.
     * @see ReturnItemCollectionMetrics
     */
    public final String returnItemCollectionMetricsAsString() {
        return returnItemCollectionMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestItems() ? requestItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(returnItemCollectionMetricsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemRequest)) {
            return false;
        }
        BatchWriteItemRequest other = (BatchWriteItemRequest) obj;
        return hasRequestItems() == other.hasRequestItems() && Objects.equals(requestItems(), other.requestItems())
                && Objects.equals(returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString())
                && Objects.equals(returnItemCollectionMetricsAsString(), other.returnItemCollectionMetricsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchWriteItemRequest").add("RequestItems", hasRequestItems() ? requestItems() : null)
                .add("ReturnConsumedCapacity", returnConsumedCapacityAsString())
                .add("ReturnItemCollectionMetrics", returnItemCollectionMetricsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestItems":
            return Optional.ofNullable(clazz.cast(requestItems()));
        case "ReturnConsumedCapacity":
            return Optional.ofNullable(clazz.cast(returnConsumedCapacityAsString()));
        case "ReturnItemCollectionMetrics":
            return Optional.ofNullable(clazz.cast(returnItemCollectionMetricsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteItemRequest, T> g) {
        return obj -> g.apply((BatchWriteItemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchWriteItemRequest> {
        /**
         * <p>
         * A map of one or more table names and, for each table, a list of operations to be performed (
         * <code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to
         * be deleted is identified by a <code>Key</code> subelement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this
         * map consists of an attribute name and an attribute value. For each primary key, you must provide <i>all</i>
         * of the key attributes. For example, with a simple primary key, you only need to provide a value for the
         * partition key. For a composite primary key, you must provide values for <i>both</i> the partition key and the
         * sort key.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put
         * is identified by an <code>Item</code> subelement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute
         * name and an attribute value. Attribute values must not be null; string and binary type attributes must have
         * lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values are
         * rejected with a <code>ValidationException</code> exception.
         * </p>
         * <p>
         * If you specify any attributes that are part of an index key, then the data types for those attributes must
         * match those of the schema in the table's attribute definition.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param requestItems
         *        A map of one or more table names and, for each table, a list of operations to be performed (
         *        <code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The
         *        item to be deleted is identified by a <code>Key</code> subelement:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry
         *        in this map consists of an attribute name and an attribute value. For each primary key, you must
         *        provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to
         *        provide a value for the partition key. For a composite primary key, you must provide values for
         *        <i>both</i> the partition key and the sort key.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to
         *        be put is identified by an <code>Item</code> subelement:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an
         *        attribute name and an attribute value. Attribute values must not be null; string and binary type
         *        attributes must have lengths greater than zero; and set type attributes must not be empty. Requests
         *        that contain empty values are rejected with a <code>ValidationException</code> exception.
         *        </p>
         *        <p>
         *        If you specify any attributes that are part of an index key, then the data types for those attributes
         *        must match those of the schema in the table's attribute definition.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestItems(Map<String, ? extends Collection<WriteRequest>> requestItems);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections, if any, that were modified during the operation are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections, if any, that were modified during the operation are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @see ReturnItemCollectionMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(String returnItemCollectionMetrics);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections, if any, that were modified during the operation are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections, if any, that were modified during the operation are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @see ReturnItemCollectionMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private Map<String, List<WriteRequest>> requestItems = DefaultSdkAutoConstructMap.getInstance();

        private String returnConsumedCapacity;

        private String returnItemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemRequest model) {
            super(model);
            requestItems(model.requestItems);
            returnConsumedCapacity(model.returnConsumedCapacity);
            returnItemCollectionMetrics(model.returnItemCollectionMetrics);
        }

        public final Map<String, List<WriteRequest.Builder>> getRequestItems() {
            Map<String, List<WriteRequest.Builder>> result = BatchWriteItemRequestMapCopier.copyToBuilder(this.requestItems);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRequestItems(Map<String, ? extends Collection<WriteRequest.BuilderImpl>> requestItems) {
            this.requestItems = BatchWriteItemRequestMapCopier.copyFromBuilder(requestItems);
        }

        @Override
        @Transient
        public final Builder requestItems(Map<String, ? extends Collection<WriteRequest>> requestItems) {
            this.requestItems = BatchWriteItemRequestMapCopier.copy(requestItems);
            return this;
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        @Transient
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        @Transient
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final String getReturnItemCollectionMetrics() {
            return returnItemCollectionMetrics;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        @Override
        @Transient
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        @Transient
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics == null ? null : returnItemCollectionMetrics.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchWriteItemRequest build() {
            return new BatchWriteItemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
