/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of the table being imported into.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTableDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportTableDescription.Builder, ImportTableDescription> {
    private static final SdkField<String> IMPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportArn").getter(getter(ImportTableDescription::importArn)).setter(setter(Builder::importArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportArn").build()).build();

    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportStatus").getter(getter(ImportTableDescription::importStatusAsString))
            .setter(setter(Builder::importStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportStatus").build()).build();

    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableArn").getter(getter(ImportTableDescription::tableArn)).setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()).build();

    private static final SdkField<String> TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableId").getter(getter(ImportTableDescription::tableId)).setter(setter(Builder::tableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(ImportTableDescription::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<S3BucketSource> S3_BUCKET_SOURCE_FIELD = SdkField
            .<S3BucketSource> builder(MarshallingType.SDK_POJO).memberName("S3BucketSource")
            .getter(getter(ImportTableDescription::s3BucketSource)).setter(setter(Builder::s3BucketSource))
            .constructor(S3BucketSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketSource").build()).build();

    private static final SdkField<Long> ERROR_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ErrorCount").getter(getter(ImportTableDescription::errorCount)).setter(setter(Builder::errorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCount").build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupArn").getter(getter(ImportTableDescription::cloudWatchLogGroupArn))
            .setter(setter(Builder::cloudWatchLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build())
            .build();

    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputFormat").getter(getter(ImportTableDescription::inputFormatAsString))
            .setter(setter(Builder::inputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()).build();

    private static final SdkField<InputFormatOptions> INPUT_FORMAT_OPTIONS_FIELD = SdkField
            .<InputFormatOptions> builder(MarshallingType.SDK_POJO).memberName("InputFormatOptions")
            .getter(getter(ImportTableDescription::inputFormatOptions)).setter(setter(Builder::inputFormatOptions))
            .constructor(InputFormatOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormatOptions").build())
            .build();

    private static final SdkField<String> INPUT_COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputCompressionType").getter(getter(ImportTableDescription::inputCompressionTypeAsString))
            .setter(setter(Builder::inputCompressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputCompressionType").build())
            .build();

    private static final SdkField<TableCreationParameters> TABLE_CREATION_PARAMETERS_FIELD = SdkField
            .<TableCreationParameters> builder(MarshallingType.SDK_POJO).memberName("TableCreationParameters")
            .getter(getter(ImportTableDescription::tableCreationParameters)).setter(setter(Builder::tableCreationParameters))
            .constructor(TableCreationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableCreationParameters").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ImportTableDescription::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ImportTableDescription::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Long> PROCESSED_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ProcessedSizeBytes").getter(getter(ImportTableDescription::processedSizeBytes))
            .setter(setter(Builder::processedSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedSizeBytes").build())
            .build();

    private static final SdkField<Long> PROCESSED_ITEM_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ProcessedItemCount").getter(getter(ImportTableDescription::processedItemCount))
            .setter(setter(Builder::processedItemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedItemCount").build())
            .build();

    private static final SdkField<Long> IMPORTED_ITEM_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ImportedItemCount").getter(getter(ImportTableDescription::importedItemCount))
            .setter(setter(Builder::importedItemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedItemCount").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(ImportTableDescription::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(ImportTableDescription::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ARN_FIELD,
            IMPORT_STATUS_FIELD, TABLE_ARN_FIELD, TABLE_ID_FIELD, CLIENT_TOKEN_FIELD, S3_BUCKET_SOURCE_FIELD, ERROR_COUNT_FIELD,
            CLOUD_WATCH_LOG_GROUP_ARN_FIELD, INPUT_FORMAT_FIELD, INPUT_FORMAT_OPTIONS_FIELD, INPUT_COMPRESSION_TYPE_FIELD,
            TABLE_CREATION_PARAMETERS_FIELD, START_TIME_FIELD, END_TIME_FIELD, PROCESSED_SIZE_BYTES_FIELD,
            PROCESSED_ITEM_COUNT_FIELD, IMPORTED_ITEM_COUNT_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String importArn;

    private final String importStatus;

    private final String tableArn;

    private final String tableId;

    private final String clientToken;

    private final S3BucketSource s3BucketSource;

    private final Long errorCount;

    private final String cloudWatchLogGroupArn;

    private final String inputFormat;

    private final InputFormatOptions inputFormatOptions;

    private final String inputCompressionType;

    private final TableCreationParameters tableCreationParameters;

    private final Instant startTime;

    private final Instant endTime;

    private final Long processedSizeBytes;

    private final Long processedItemCount;

    private final Long importedItemCount;

    private final String failureCode;

    private final String failureMessage;

    private ImportTableDescription(BuilderImpl builder) {
        this.importArn = builder.importArn;
        this.importStatus = builder.importStatus;
        this.tableArn = builder.tableArn;
        this.tableId = builder.tableId;
        this.clientToken = builder.clientToken;
        this.s3BucketSource = builder.s3BucketSource;
        this.errorCount = builder.errorCount;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.inputFormat = builder.inputFormat;
        this.inputFormatOptions = builder.inputFormatOptions;
        this.inputCompressionType = builder.inputCompressionType;
        this.tableCreationParameters = builder.tableCreationParameters;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.processedSizeBytes = builder.processedSizeBytes;
        this.processedItemCount = builder.processedItemCount;
        this.importedItemCount = builder.importedItemCount;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) corresponding to the import request.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) corresponding to the import request.
     */
    public final String importArn() {
        return importArn;
    }

    /**
     * <p>
     * The status of the import.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import.
     * @see ImportStatus
     */
    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(importStatus);
    }

    /**
     * <p>
     * The status of the import.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import.
     * @see ImportStatus
     */
    public final String importStatusAsString() {
        return importStatus;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the table being imported into.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the table being imported into.
     */
    public final String tableArn() {
        return tableArn;
    }

    /**
     * <p>
     * The table id corresponding to the table created by import table process.
     * </p>
     * 
     * @return The table id corresponding to the table created by import table process.
     */
    public final String tableId() {
        return tableId;
    }

    /**
     * <p>
     * The client token that was provided for the import task. Reusing the client token on retry makes a call to
     * <code>ImportTable</code> idempotent.
     * </p>
     * 
     * @return The client token that was provided for the import task. Reusing the client token on retry makes a call to
     *         <code>ImportTable</code> idempotent.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Values for the S3 bucket the source file is imported from. Includes bucket name (required), key prefix (optional)
     * and bucket account owner ID (optional).
     * </p>
     * 
     * @return Values for the S3 bucket the source file is imported from. Includes bucket name (required), key prefix
     *         (optional) and bucket account owner ID (optional).
     */
    public final S3BucketSource s3BucketSource() {
        return s3BucketSource;
    }

    /**
     * <p>
     * The number of errors occurred on importing the source file into the target table.
     * </p>
     * 
     * @return The number of errors occurred on importing the source file into the target table.
     */
    public final Long errorCount() {
        return errorCount;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with the target table.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with the target table.
     */
    public final String cloudWatchLogGroupArn() {
        return cloudWatchLogGroupArn;
    }

    /**
     * <p>
     * The format of the source data going into the target table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFormat} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFormatAsString}.
     * </p>
     * 
     * @return The format of the source data going into the target table.
     * @see InputFormat
     */
    public final InputFormat inputFormat() {
        return InputFormat.fromValue(inputFormat);
    }

    /**
     * <p>
     * The format of the source data going into the target table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFormat} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFormatAsString}.
     * </p>
     * 
     * @return The format of the source data going into the target table.
     * @see InputFormat
     */
    public final String inputFormatAsString() {
        return inputFormat;
    }

    /**
     * <p>
     * The format options for the data that was imported into the target table. There is one value, CsvOption.
     * </p>
     * 
     * @return The format options for the data that was imported into the target table. There is one value, CsvOption.
     */
    public final InputFormatOptions inputFormatOptions() {
        return inputFormatOptions;
    }

    /**
     * <p>
     * The compression options for the data that has been imported into the target table. The values are NONE, GZIP, or
     * ZSTD.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputCompressionType} will return {@link InputCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inputCompressionTypeAsString}.
     * </p>
     * 
     * @return The compression options for the data that has been imported into the target table. The values are NONE,
     *         GZIP, or ZSTD.
     * @see InputCompressionType
     */
    public final InputCompressionType inputCompressionType() {
        return InputCompressionType.fromValue(inputCompressionType);
    }

    /**
     * <p>
     * The compression options for the data that has been imported into the target table. The values are NONE, GZIP, or
     * ZSTD.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputCompressionType} will return {@link InputCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inputCompressionTypeAsString}.
     * </p>
     * 
     * @return The compression options for the data that has been imported into the target table. The values are NONE,
     *         GZIP, or ZSTD.
     * @see InputCompressionType
     */
    public final String inputCompressionTypeAsString() {
        return inputCompressionType;
    }

    /**
     * <p>
     * The parameters for the new table that is being imported into.
     * </p>
     * 
     * @return The parameters for the new table that is being imported into.
     */
    public final TableCreationParameters tableCreationParameters() {
        return tableCreationParameters;
    }

    /**
     * <p>
     * The time when this import task started.
     * </p>
     * 
     * @return The time when this import task started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time at which the creation of the table associated with this import task completed.
     * </p>
     * 
     * @return The time at which the creation of the table associated with this import task completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The total size of data processed from the source file, in Bytes.
     * </p>
     * 
     * @return The total size of data processed from the source file, in Bytes.
     */
    public final Long processedSizeBytes() {
        return processedSizeBytes;
    }

    /**
     * <p>
     * The total number of items processed from the source file.
     * </p>
     * 
     * @return The total number of items processed from the source file.
     */
    public final Long processedItemCount() {
        return processedItemCount;
    }

    /**
     * <p>
     * The number of items successfully imported into the new table.
     * </p>
     * 
     * @return The number of items successfully imported into the new table.
     */
    public final Long importedItemCount() {
        return importedItemCount;
    }

    /**
     * <p>
     * The error code corresponding to the failure that the import job ran into during execution.
     * </p>
     * 
     * @return The error code corresponding to the failure that the import job ran into during execution.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * The error message corresponding to the failure that the import job ran into during execution.
     * </p>
     * 
     * @return The error message corresponding to the failure that the import job ran into during execution.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importArn());
        hashCode = 31 * hashCode + Objects.hashCode(importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketSource());
        hashCode = 31 * hashCode + Objects.hashCode(errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputFormatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(inputCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableCreationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(processedSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(processedItemCount());
        hashCode = 31 * hashCode + Objects.hashCode(importedItemCount());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTableDescription)) {
            return false;
        }
        ImportTableDescription other = (ImportTableDescription) obj;
        return Objects.equals(importArn(), other.importArn())
                && Objects.equals(importStatusAsString(), other.importStatusAsString())
                && Objects.equals(tableArn(), other.tableArn()) && Objects.equals(tableId(), other.tableId())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(s3BucketSource(), other.s3BucketSource())
                && Objects.equals(errorCount(), other.errorCount())
                && Objects.equals(cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn())
                && Objects.equals(inputFormatAsString(), other.inputFormatAsString())
                && Objects.equals(inputFormatOptions(), other.inputFormatOptions())
                && Objects.equals(inputCompressionTypeAsString(), other.inputCompressionTypeAsString())
                && Objects.equals(tableCreationParameters(), other.tableCreationParameters())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(processedSizeBytes(), other.processedSizeBytes())
                && Objects.equals(processedItemCount(), other.processedItemCount())
                && Objects.equals(importedItemCount(), other.importedItemCount())
                && Objects.equals(failureCode(), other.failureCode()) && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTableDescription").add("ImportArn", importArn())
                .add("ImportStatus", importStatusAsString()).add("TableArn", tableArn()).add("TableId", tableId())
                .add("ClientToken", clientToken()).add("S3BucketSource", s3BucketSource()).add("ErrorCount", errorCount())
                .add("CloudWatchLogGroupArn", cloudWatchLogGroupArn()).add("InputFormat", inputFormatAsString())
                .add("InputFormatOptions", inputFormatOptions()).add("InputCompressionType", inputCompressionTypeAsString())
                .add("TableCreationParameters", tableCreationParameters()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("ProcessedSizeBytes", processedSizeBytes())
                .add("ProcessedItemCount", processedItemCount()).add("ImportedItemCount", importedItemCount())
                .add("FailureCode", failureCode()).add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportArn":
            return Optional.ofNullable(clazz.cast(importArn()));
        case "ImportStatus":
            return Optional.ofNullable(clazz.cast(importStatusAsString()));
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        case "TableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "S3BucketSource":
            return Optional.ofNullable(clazz.cast(s3BucketSource()));
        case "ErrorCount":
            return Optional.ofNullable(clazz.cast(errorCount()));
        case "CloudWatchLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupArn()));
        case "InputFormat":
            return Optional.ofNullable(clazz.cast(inputFormatAsString()));
        case "InputFormatOptions":
            return Optional.ofNullable(clazz.cast(inputFormatOptions()));
        case "InputCompressionType":
            return Optional.ofNullable(clazz.cast(inputCompressionTypeAsString()));
        case "TableCreationParameters":
            return Optional.ofNullable(clazz.cast(tableCreationParameters()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ProcessedSizeBytes":
            return Optional.ofNullable(clazz.cast(processedSizeBytes()));
        case "ProcessedItemCount":
            return Optional.ofNullable(clazz.cast(processedItemCount()));
        case "ImportedItemCount":
            return Optional.ofNullable(clazz.cast(importedItemCount()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTableDescription, T> g) {
        return obj -> g.apply((ImportTableDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportTableDescription> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) corresponding to the import request.
         * </p>
         * 
         * @param importArn
         *        The Amazon Resource Number (ARN) corresponding to the import request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importArn(String importArn);

        /**
         * <p>
         * The status of the import.
         * </p>
         * 
         * @param importStatus
         *        The status of the import.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(String importStatus);

        /**
         * <p>
         * The status of the import.
         * </p>
         * 
         * @param importStatus
         *        The status of the import.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(ImportStatus importStatus);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the table being imported into.
         * </p>
         * 
         * @param tableArn
         *        The Amazon Resource Number (ARN) of the table being imported into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);

        /**
         * <p>
         * The table id corresponding to the table created by import table process.
         * </p>
         * 
         * @param tableId
         *        The table id corresponding to the table created by import table process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * The client token that was provided for the import task. Reusing the client token on retry makes a call to
         * <code>ImportTable</code> idempotent.
         * </p>
         * 
         * @param clientToken
         *        The client token that was provided for the import task. Reusing the client token on retry makes a call
         *        to <code>ImportTable</code> idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Values for the S3 bucket the source file is imported from. Includes bucket name (required), key prefix
         * (optional) and bucket account owner ID (optional).
         * </p>
         * 
         * @param s3BucketSource
         *        Values for the S3 bucket the source file is imported from. Includes bucket name (required), key prefix
         *        (optional) and bucket account owner ID (optional).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketSource(S3BucketSource s3BucketSource);

        /**
         * <p>
         * Values for the S3 bucket the source file is imported from. Includes bucket name (required), key prefix
         * (optional) and bucket account owner ID (optional).
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BucketSource.Builder} avoiding the need
         * to create one manually via {@link S3BucketSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3BucketSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3BucketSource(S3BucketSource)}.
         * 
         * @param s3BucketSource
         *        a consumer that will call methods on {@link S3BucketSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BucketSource(S3BucketSource)
         */
        default Builder s3BucketSource(Consumer<S3BucketSource.Builder> s3BucketSource) {
            return s3BucketSource(S3BucketSource.builder().applyMutation(s3BucketSource).build());
        }

        /**
         * <p>
         * The number of errors occurred on importing the source file into the target table.
         * </p>
         * 
         * @param errorCount
         *        The number of errors occurred on importing the source file into the target table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCount(Long errorCount);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with the target table.
         * </p>
         * 
         * @param cloudWatchLogGroupArn
         *        The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with the target table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn);

        /**
         * <p>
         * The format of the source data going into the target table.
         * </p>
         * 
         * @param inputFormat
         *        The format of the source data going into the target table.
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder inputFormat(String inputFormat);

        /**
         * <p>
         * The format of the source data going into the target table.
         * </p>
         * 
         * @param inputFormat
         *        The format of the source data going into the target table.
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder inputFormat(InputFormat inputFormat);

        /**
         * <p>
         * The format options for the data that was imported into the target table. There is one value, CsvOption.
         * </p>
         * 
         * @param inputFormatOptions
         *        The format options for the data that was imported into the target table. There is one value,
         *        CsvOption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFormatOptions(InputFormatOptions inputFormatOptions);

        /**
         * <p>
         * The format options for the data that was imported into the target table. There is one value, CsvOption.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputFormatOptions.Builder} avoiding the
         * need to create one manually via {@link InputFormatOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputFormatOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #inputFormatOptions(InputFormatOptions)}.
         * 
         * @param inputFormatOptions
         *        a consumer that will call methods on {@link InputFormatOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputFormatOptions(InputFormatOptions)
         */
        default Builder inputFormatOptions(Consumer<InputFormatOptions.Builder> inputFormatOptions) {
            return inputFormatOptions(InputFormatOptions.builder().applyMutation(inputFormatOptions).build());
        }

        /**
         * <p>
         * The compression options for the data that has been imported into the target table. The values are NONE, GZIP,
         * or ZSTD.
         * </p>
         * 
         * @param inputCompressionType
         *        The compression options for the data that has been imported into the target table. The values are
         *        NONE, GZIP, or ZSTD.
         * @see InputCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputCompressionType
         */
        Builder inputCompressionType(String inputCompressionType);

        /**
         * <p>
         * The compression options for the data that has been imported into the target table. The values are NONE, GZIP,
         * or ZSTD.
         * </p>
         * 
         * @param inputCompressionType
         *        The compression options for the data that has been imported into the target table. The values are
         *        NONE, GZIP, or ZSTD.
         * @see InputCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputCompressionType
         */
        Builder inputCompressionType(InputCompressionType inputCompressionType);

        /**
         * <p>
         * The parameters for the new table that is being imported into.
         * </p>
         * 
         * @param tableCreationParameters
         *        The parameters for the new table that is being imported into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableCreationParameters(TableCreationParameters tableCreationParameters);

        /**
         * <p>
         * The parameters for the new table that is being imported into.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCreationParameters.Builder} avoiding
         * the need to create one manually via {@link TableCreationParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableCreationParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #tableCreationParameters(TableCreationParameters)}.
         * 
         * @param tableCreationParameters
         *        a consumer that will call methods on {@link TableCreationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableCreationParameters(TableCreationParameters)
         */
        default Builder tableCreationParameters(Consumer<TableCreationParameters.Builder> tableCreationParameters) {
            return tableCreationParameters(TableCreationParameters.builder().applyMutation(tableCreationParameters).build());
        }

        /**
         * <p>
         * The time when this import task started.
         * </p>
         * 
         * @param startTime
         *        The time when this import task started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time at which the creation of the table associated with this import task completed.
         * </p>
         * 
         * @param endTime
         *        The time at which the creation of the table associated with this import task completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The total size of data processed from the source file, in Bytes.
         * </p>
         * 
         * @param processedSizeBytes
         *        The total size of data processed from the source file, in Bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedSizeBytes(Long processedSizeBytes);

        /**
         * <p>
         * The total number of items processed from the source file.
         * </p>
         * 
         * @param processedItemCount
         *        The total number of items processed from the source file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedItemCount(Long processedItemCount);

        /**
         * <p>
         * The number of items successfully imported into the new table.
         * </p>
         * 
         * @param importedItemCount
         *        The number of items successfully imported into the new table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedItemCount(Long importedItemCount);

        /**
         * <p>
         * The error code corresponding to the failure that the import job ran into during execution.
         * </p>
         * 
         * @param failureCode
         *        The error code corresponding to the failure that the import job ran into during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The error message corresponding to the failure that the import job ran into during execution.
         * </p>
         * 
         * @param failureMessage
         *        The error message corresponding to the failure that the import job ran into during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String importArn;

        private String importStatus;

        private String tableArn;

        private String tableId;

        private String clientToken;

        private S3BucketSource s3BucketSource;

        private Long errorCount;

        private String cloudWatchLogGroupArn;

        private String inputFormat;

        private InputFormatOptions inputFormatOptions;

        private String inputCompressionType;

        private TableCreationParameters tableCreationParameters;

        private Instant startTime;

        private Instant endTime;

        private Long processedSizeBytes;

        private Long processedItemCount;

        private Long importedItemCount;

        private String failureCode;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTableDescription model) {
            importArn(model.importArn);
            importStatus(model.importStatus);
            tableArn(model.tableArn);
            tableId(model.tableId);
            clientToken(model.clientToken);
            s3BucketSource(model.s3BucketSource);
            errorCount(model.errorCount);
            cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            inputFormat(model.inputFormat);
            inputFormatOptions(model.inputFormatOptions);
            inputCompressionType(model.inputCompressionType);
            tableCreationParameters(model.tableCreationParameters);
            startTime(model.startTime);
            endTime(model.endTime);
            processedSizeBytes(model.processedSizeBytes);
            processedItemCount(model.processedItemCount);
            importedItemCount(model.importedItemCount);
            failureCode(model.failureCode);
            failureMessage(model.failureMessage);
        }

        public final String getImportArn() {
            return importArn;
        }

        public final void setImportArn(String importArn) {
            this.importArn = importArn;
        }

        @Override
        public final Builder importArn(String importArn) {
            this.importArn = importArn;
            return this;
        }

        public final String getImportStatus() {
            return importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final String getTableArn() {
            return tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final String getTableId() {
            return tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final S3BucketSource.Builder getS3BucketSource() {
            return s3BucketSource != null ? s3BucketSource.toBuilder() : null;
        }

        public final void setS3BucketSource(S3BucketSource.BuilderImpl s3BucketSource) {
            this.s3BucketSource = s3BucketSource != null ? s3BucketSource.build() : null;
        }

        @Override
        public final Builder s3BucketSource(S3BucketSource s3BucketSource) {
            this.s3BucketSource = s3BucketSource;
            return this;
        }

        public final Long getErrorCount() {
            return errorCount;
        }

        public final void setErrorCount(Long errorCount) {
            this.errorCount = errorCount;
        }

        @Override
        public final Builder errorCount(Long errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final String getInputFormat() {
            return inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        public final InputFormatOptions.Builder getInputFormatOptions() {
            return inputFormatOptions != null ? inputFormatOptions.toBuilder() : null;
        }

        public final void setInputFormatOptions(InputFormatOptions.BuilderImpl inputFormatOptions) {
            this.inputFormatOptions = inputFormatOptions != null ? inputFormatOptions.build() : null;
        }

        @Override
        public final Builder inputFormatOptions(InputFormatOptions inputFormatOptions) {
            this.inputFormatOptions = inputFormatOptions;
            return this;
        }

        public final String getInputCompressionType() {
            return inputCompressionType;
        }

        public final void setInputCompressionType(String inputCompressionType) {
            this.inputCompressionType = inputCompressionType;
        }

        @Override
        public final Builder inputCompressionType(String inputCompressionType) {
            this.inputCompressionType = inputCompressionType;
            return this;
        }

        @Override
        public final Builder inputCompressionType(InputCompressionType inputCompressionType) {
            this.inputCompressionType(inputCompressionType == null ? null : inputCompressionType.toString());
            return this;
        }

        public final TableCreationParameters.Builder getTableCreationParameters() {
            return tableCreationParameters != null ? tableCreationParameters.toBuilder() : null;
        }

        public final void setTableCreationParameters(TableCreationParameters.BuilderImpl tableCreationParameters) {
            this.tableCreationParameters = tableCreationParameters != null ? tableCreationParameters.build() : null;
        }

        @Override
        public final Builder tableCreationParameters(TableCreationParameters tableCreationParameters) {
            this.tableCreationParameters = tableCreationParameters;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Long getProcessedSizeBytes() {
            return processedSizeBytes;
        }

        public final void setProcessedSizeBytes(Long processedSizeBytes) {
            this.processedSizeBytes = processedSizeBytes;
        }

        @Override
        public final Builder processedSizeBytes(Long processedSizeBytes) {
            this.processedSizeBytes = processedSizeBytes;
            return this;
        }

        public final Long getProcessedItemCount() {
            return processedItemCount;
        }

        public final void setProcessedItemCount(Long processedItemCount) {
            this.processedItemCount = processedItemCount;
        }

        @Override
        public final Builder processedItemCount(Long processedItemCount) {
            this.processedItemCount = processedItemCount;
            return this;
        }

        public final Long getImportedItemCount() {
            return importedItemCount;
        }

        public final void setImportedItemCount(Long importedItemCount) {
            this.importedItemCount = importedItemCount;
        }

        @Override
        public final Builder importedItemCount(Long importedItemCount) {
            this.importedItemCount = importedItemCount;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public ImportTableDescription build() {
            return new ImportTableDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
