/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlobalTableRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateGlobalTableRequest.Builder, UpdateGlobalTableRequest> {
    private static final SdkField<String> GLOBAL_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalTableName").getter(getter(UpdateGlobalTableRequest::globalTableName))
            .setter(setter(Builder::globalTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableName").build()).build();

    private static final SdkField<List<ReplicaUpdate>> REPLICA_UPDATES_FIELD = SdkField
            .<List<ReplicaUpdate>> builder(MarshallingType.LIST)
            .memberName("ReplicaUpdates")
            .getter(getter(UpdateGlobalTableRequest::replicaUpdates))
            .setter(setter(Builder::replicaUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_TABLE_NAME_FIELD,
            REPLICA_UPDATES_FIELD));

    private final String globalTableName;

    private final List<ReplicaUpdate> replicaUpdates;

    private UpdateGlobalTableRequest(BuilderImpl builder) {
        super(builder);
        this.globalTableName = builder.globalTableName;
        this.replicaUpdates = builder.replicaUpdates;
    }

    /**
     * <p>
     * The global table name.
     * </p>
     * 
     * @return The global table name.
     */
    public final String globalTableName() {
        return globalTableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicaUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicaUpdates() {
        return replicaUpdates != null && !(replicaUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Regions that should be added or removed from the global table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicaUpdates} method.
     * </p>
     * 
     * @return A list of Regions that should be added or removed from the global table.
     */
    public final List<ReplicaUpdate> replicaUpdates() {
        return replicaUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicaUpdates() ? replicaUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalTableRequest)) {
            return false;
        }
        UpdateGlobalTableRequest other = (UpdateGlobalTableRequest) obj;
        return Objects.equals(globalTableName(), other.globalTableName()) && hasReplicaUpdates() == other.hasReplicaUpdates()
                && Objects.equals(replicaUpdates(), other.replicaUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGlobalTableRequest").add("GlobalTableName", globalTableName())
                .add("ReplicaUpdates", hasReplicaUpdates() ? replicaUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalTableName":
            return Optional.ofNullable(clazz.cast(globalTableName()));
        case "ReplicaUpdates":
            return Optional.ofNullable(clazz.cast(replicaUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalTableRequest, T> g) {
        return obj -> g.apply((UpdateGlobalTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGlobalTableRequest> {
        /**
         * <p>
         * The global table name.
         * </p>
         * 
         * @param globalTableName
         *        The global table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableName(String globalTableName);

        /**
         * <p>
         * A list of Regions that should be added or removed from the global table.
         * </p>
         * 
         * @param replicaUpdates
         *        A list of Regions that should be added or removed from the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaUpdates(Collection<ReplicaUpdate> replicaUpdates);

        /**
         * <p>
         * A list of Regions that should be added or removed from the global table.
         * </p>
         * 
         * @param replicaUpdates
         *        A list of Regions that should be added or removed from the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaUpdates(ReplicaUpdate... replicaUpdates);

        /**
         * <p>
         * A list of Regions that should be added or removed from the global table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicaUpdate>.Builder} avoiding the need
         * to create one manually via {@link List<ReplicaUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaUpdate>.Builder#build()} is called immediately and
         * its result is passed to {@link #replicaUpdates(List<ReplicaUpdate>)}.
         * 
         * @param replicaUpdates
         *        a consumer that will call methods on {@link List<ReplicaUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaUpdates(List<ReplicaUpdate>)
         */
        Builder replicaUpdates(Consumer<ReplicaUpdate.Builder>... replicaUpdates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String globalTableName;

        private List<ReplicaUpdate> replicaUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalTableRequest model) {
            super(model);
            globalTableName(model.globalTableName);
            replicaUpdates(model.replicaUpdates);
        }

        public final String getGlobalTableName() {
            return globalTableName;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        @Override
        @Transient
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final List<ReplicaUpdate.Builder> getReplicaUpdates() {
            List<ReplicaUpdate.Builder> result = ReplicaUpdateListCopier.copyToBuilder(this.replicaUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaUpdates(Collection<ReplicaUpdate.BuilderImpl> replicaUpdates) {
            this.replicaUpdates = ReplicaUpdateListCopier.copyFromBuilder(replicaUpdates);
        }

        @Override
        @Transient
        public final Builder replicaUpdates(Collection<ReplicaUpdate> replicaUpdates) {
            this.replicaUpdates = ReplicaUpdateListCopier.copy(replicaUpdates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicaUpdates(ReplicaUpdate... replicaUpdates) {
            replicaUpdates(Arrays.asList(replicaUpdates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicaUpdates(Consumer<ReplicaUpdate.Builder>... replicaUpdates) {
            replicaUpdates(Stream.of(replicaUpdates).map(c -> ReplicaUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalTableRequest build() {
            return new UpdateGlobalTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
