/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings for a global table in a Region that will be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaSettingsUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaSettingsUpdate.Builder, ReplicaSettingsUpdate> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(ReplicaSettingsUpdate::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<Long> REPLICA_PROVISIONED_READ_CAPACITY_UNITS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ReplicaProvisionedReadCapacityUnits")
            .getter(getter(ReplicaSettingsUpdate::replicaProvisionedReadCapacityUnits))
            .setter(setter(Builder::replicaProvisionedReadCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaProvisionedReadCapacityUnits").build()).build();

    private static final SdkField<AutoScalingSettingsUpdate> REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD = SdkField
            .<AutoScalingSettingsUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate")
            .getter(getter(ReplicaSettingsUpdate::replicaProvisionedReadCapacityAutoScalingSettingsUpdate))
            .setter(setter(Builder::replicaProvisionedReadCapacityAutoScalingSettingsUpdate))
            .constructor(AutoScalingSettingsUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate").build()).build();

    private static final SdkField<List<ReplicaGlobalSecondaryIndexSettingsUpdate>> REPLICA_GLOBAL_SECONDARY_INDEX_SETTINGS_UPDATE_FIELD = SdkField
            .<List<ReplicaGlobalSecondaryIndexSettingsUpdate>> builder(MarshallingType.LIST)
            .memberName("ReplicaGlobalSecondaryIndexSettingsUpdate")
            .getter(getter(ReplicaSettingsUpdate::replicaGlobalSecondaryIndexSettingsUpdate))
            .setter(setter(Builder::replicaGlobalSecondaryIndexSettingsUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaGlobalSecondaryIndexSettingsUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaGlobalSecondaryIndexSettingsUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaGlobalSecondaryIndexSettingsUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            REPLICA_PROVISIONED_READ_CAPACITY_UNITS_FIELD, REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD,
            REPLICA_GLOBAL_SECONDARY_INDEX_SETTINGS_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final Long replicaProvisionedReadCapacityUnits;

    private final AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate;

    private final List<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate;

    private ReplicaSettingsUpdate(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaProvisionedReadCapacityUnits = builder.replicaProvisionedReadCapacityUnits;
        this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate = builder.replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
        this.replicaGlobalSecondaryIndexSettingsUpdate = builder.replicaGlobalSecondaryIndexSettingsUpdate;
    }

    /**
     * <p>
     * The Region of the replica to be added.
     * </p>
     * 
     * @return The Region of the replica to be added.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     *         >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final Long replicaProvisionedReadCapacityUnits() {
        return replicaProvisionedReadCapacityUnits;
    }

    /**
     * <p>
     * Auto scaling settings for managing a global table replica's read capacity units.
     * </p>
     * 
     * @return Auto scaling settings for managing a global table replica's read capacity units.
     */
    public final AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate() {
        return replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * ReplicaGlobalSecondaryIndexSettingsUpdate property. This DOES NOT check that the value is non-empty (for which,
     * you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never return
     * a null collection or map, but you may need to differentiate between the service returning nothing (or null) and
     * the service returning an empty collection or map. For requests, this returns true if a value for the property was
     * specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasReplicaGlobalSecondaryIndexSettingsUpdate() {
        return replicaGlobalSecondaryIndexSettingsUpdate != null
                && !(replicaGlobalSecondaryIndexSettingsUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the settings of a global secondary index for a global table that will be modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasReplicaGlobalSecondaryIndexSettingsUpdate} method.
     * </p>
     * 
     * @return Represents the settings of a global secondary index for a global table that will be modified.
     */
    public final List<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate() {
        return replicaGlobalSecondaryIndexSettingsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedReadCapacityAutoScalingSettingsUpdate());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasReplicaGlobalSecondaryIndexSettingsUpdate() ? replicaGlobalSecondaryIndexSettingsUpdate()
                        : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSettingsUpdate)) {
            return false;
        }
        ReplicaSettingsUpdate other = (ReplicaSettingsUpdate) obj;
        return Objects.equals(regionName(), other.regionName())
                && Objects.equals(replicaProvisionedReadCapacityUnits(), other.replicaProvisionedReadCapacityUnits())
                && Objects.equals(replicaProvisionedReadCapacityAutoScalingSettingsUpdate(),
                        other.replicaProvisionedReadCapacityAutoScalingSettingsUpdate())
                && hasReplicaGlobalSecondaryIndexSettingsUpdate() == other.hasReplicaGlobalSecondaryIndexSettingsUpdate()
                && Objects.equals(replicaGlobalSecondaryIndexSettingsUpdate(), other.replicaGlobalSecondaryIndexSettingsUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ReplicaSettingsUpdate")
                .add("RegionName", regionName())
                .add("ReplicaProvisionedReadCapacityUnits", replicaProvisionedReadCapacityUnits())
                .add("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate",
                        replicaProvisionedReadCapacityAutoScalingSettingsUpdate())
                .add("ReplicaGlobalSecondaryIndexSettingsUpdate",
                        hasReplicaGlobalSecondaryIndexSettingsUpdate() ? replicaGlobalSecondaryIndexSettingsUpdate() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "ReplicaProvisionedReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(replicaProvisionedReadCapacityUnits()));
        case "ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate":
            return Optional.ofNullable(clazz.cast(replicaProvisionedReadCapacityAutoScalingSettingsUpdate()));
        case "ReplicaGlobalSecondaryIndexSettingsUpdate":
            return Optional.ofNullable(clazz.cast(replicaGlobalSecondaryIndexSettingsUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaSettingsUpdate, T> g) {
        return obj -> g.apply((ReplicaSettingsUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaSettingsUpdate> {
        /**
         * <p>
         * The Region of the replica to be added.
         * </p>
         * 
         * @param regionName
         *        The Region of the replica to be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param replicaProvisionedReadCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         *        >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits);

        /**
         * <p>
         * Auto scaling settings for managing a global table replica's read capacity units.
         * </p>
         * 
         * @param replicaProvisionedReadCapacityAutoScalingSettingsUpdate
         *        Auto scaling settings for managing a global table replica's read capacity units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedReadCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate);

        /**
         * <p>
         * Auto scaling settings for managing a global table replica's read capacity units.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingSettingsUpdate.Builder} avoiding the
         * need to create one manually via {@link AutoScalingSettingsUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsUpdate.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #replicaProvisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate)}.
         * 
         * @param replicaProvisionedReadCapacityAutoScalingSettingsUpdate
         *        a consumer that will call methods on {@link AutoScalingSettingsUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaProvisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate)
         */
        default Builder replicaProvisionedReadCapacityAutoScalingSettingsUpdate(
                Consumer<AutoScalingSettingsUpdate.Builder> replicaProvisionedReadCapacityAutoScalingSettingsUpdate) {
            return replicaProvisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate.builder()
                    .applyMutation(replicaProvisionedReadCapacityAutoScalingSettingsUpdate).build());
        }

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * 
         * @param replicaGlobalSecondaryIndexSettingsUpdate
         *        Represents the settings of a global secondary index for a global table that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaGlobalSecondaryIndexSettingsUpdate(
                Collection<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate);

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * 
         * @param replicaGlobalSecondaryIndexSettingsUpdate
         *        Represents the settings of a global secondary index for a global table that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaGlobalSecondaryIndexSettingsUpdate(
                ReplicaGlobalSecondaryIndexSettingsUpdate... replicaGlobalSecondaryIndexSettingsUpdate);

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ReplicaGlobalSecondaryIndexSettingsUpdate>.Builder} avoiding the need to create one manually via
         * {@link List<ReplicaGlobalSecondaryIndexSettingsUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaGlobalSecondaryIndexSettingsUpdate>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #replicaGlobalSecondaryIndexSettingsUpdate(List<ReplicaGlobalSecondaryIndexSettingsUpdate>)}.
         * 
         * @param replicaGlobalSecondaryIndexSettingsUpdate
         *        a consumer that will call methods on {@link List<ReplicaGlobalSecondaryIndexSettingsUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaGlobalSecondaryIndexSettingsUpdate(List<ReplicaGlobalSecondaryIndexSettingsUpdate>)
         */
        Builder replicaGlobalSecondaryIndexSettingsUpdate(
                Consumer<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder>... replicaGlobalSecondaryIndexSettingsUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private Long replicaProvisionedReadCapacityUnits;

        private AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate;

        private List<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSettingsUpdate model) {
            regionName(model.regionName);
            replicaProvisionedReadCapacityUnits(model.replicaProvisionedReadCapacityUnits);
            replicaProvisionedReadCapacityAutoScalingSettingsUpdate(model.replicaProvisionedReadCapacityAutoScalingSettingsUpdate);
            replicaGlobalSecondaryIndexSettingsUpdate(model.replicaGlobalSecondaryIndexSettingsUpdate);
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        @Transient
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final Long getReplicaProvisionedReadCapacityUnits() {
            return replicaProvisionedReadCapacityUnits;
        }

        public final void setReplicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
        }

        @Override
        @Transient
        public final Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
            return this;
        }

        public final AutoScalingSettingsUpdate.Builder getReplicaProvisionedReadCapacityAutoScalingSettingsUpdate() {
            return replicaProvisionedReadCapacityAutoScalingSettingsUpdate != null ? replicaProvisionedReadCapacityAutoScalingSettingsUpdate
                    .toBuilder() : null;
        }

        public final void setReplicaProvisionedReadCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate.BuilderImpl replicaProvisionedReadCapacityAutoScalingSettingsUpdate) {
            this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate = replicaProvisionedReadCapacityAutoScalingSettingsUpdate != null ? replicaProvisionedReadCapacityAutoScalingSettingsUpdate
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder replicaProvisionedReadCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate) {
            this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate = replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
            return this;
        }

        public final List<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder> getReplicaGlobalSecondaryIndexSettingsUpdate() {
            List<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder> result = ReplicaGlobalSecondaryIndexSettingsUpdateListCopier
                    .copyToBuilder(this.replicaGlobalSecondaryIndexSettingsUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaGlobalSecondaryIndexSettingsUpdate(
                Collection<ReplicaGlobalSecondaryIndexSettingsUpdate.BuilderImpl> replicaGlobalSecondaryIndexSettingsUpdate) {
            this.replicaGlobalSecondaryIndexSettingsUpdate = ReplicaGlobalSecondaryIndexSettingsUpdateListCopier
                    .copyFromBuilder(replicaGlobalSecondaryIndexSettingsUpdate);
        }

        @Override
        @Transient
        public final Builder replicaGlobalSecondaryIndexSettingsUpdate(
                Collection<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate) {
            this.replicaGlobalSecondaryIndexSettingsUpdate = ReplicaGlobalSecondaryIndexSettingsUpdateListCopier
                    .copy(replicaGlobalSecondaryIndexSettingsUpdate);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettingsUpdate(
                ReplicaGlobalSecondaryIndexSettingsUpdate... replicaGlobalSecondaryIndexSettingsUpdate) {
            replicaGlobalSecondaryIndexSettingsUpdate(Arrays.asList(replicaGlobalSecondaryIndexSettingsUpdate));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettingsUpdate(
                Consumer<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder>... replicaGlobalSecondaryIndexSettingsUpdate) {
            replicaGlobalSecondaryIndexSettingsUpdate(Stream.of(replicaGlobalSecondaryIndexSettingsUpdate)
                    .map(c -> ReplicaGlobalSecondaryIndexSettingsUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReplicaSettingsUpdate build() {
            return new ReplicaSettingsUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
