/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings of a global secondary index for a global table that will be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalTableGlobalSecondaryIndexSettingsUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder, GlobalTableGlobalSecondaryIndexSettingsUpdate> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(GlobalTableGlobalSecondaryIndexSettingsUpdate::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<Long> PROVISIONED_WRITE_CAPACITY_UNITS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ProvisionedWriteCapacityUnits")
            .getter(getter(GlobalTableGlobalSecondaryIndexSettingsUpdate::provisionedWriteCapacityUnits))
            .setter(setter(Builder::provisionedWriteCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedWriteCapacityUnits")
                    .build()).build();

    private static final SdkField<AutoScalingSettingsUpdate> PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD = SdkField
            .<AutoScalingSettingsUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedWriteCapacityAutoScalingSettingsUpdate")
            .getter(getter(GlobalTableGlobalSecondaryIndexSettingsUpdate::provisionedWriteCapacityAutoScalingSettingsUpdate))
            .setter(setter(Builder::provisionedWriteCapacityAutoScalingSettingsUpdate))
            .constructor(AutoScalingSettingsUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ProvisionedWriteCapacityAutoScalingSettingsUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            PROVISIONED_WRITE_CAPACITY_UNITS_FIELD, PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indexName;

    private final Long provisionedWriteCapacityUnits;

    private final AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingSettingsUpdate;

    private GlobalTableGlobalSecondaryIndexSettingsUpdate(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedWriteCapacityUnits = builder.provisionedWriteCapacityUnits;
        this.provisionedWriteCapacityAutoScalingSettingsUpdate = builder.provisionedWriteCapacityAutoScalingSettingsUpdate;
    }

    /**
     * <p>
     * The name of the global secondary index. The name must be unique among all other indexes on this table.
     * </p>
     * 
     * @return The name of the global secondary index. The name must be unique among all other indexes on this table.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code>
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException.</code>
     */
    public final Long provisionedWriteCapacityUnits() {
        return provisionedWriteCapacityUnits;
    }

    /**
     * <p>
     * Auto scaling settings for managing a global secondary index's write capacity units.
     * </p>
     * 
     * @return Auto scaling settings for managing a global secondary index's write capacity units.
     */
    public final AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingSettingsUpdate() {
        return provisionedWriteCapacityAutoScalingSettingsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedWriteCapacityAutoScalingSettingsUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTableGlobalSecondaryIndexSettingsUpdate)) {
            return false;
        }
        GlobalTableGlobalSecondaryIndexSettingsUpdate other = (GlobalTableGlobalSecondaryIndexSettingsUpdate) obj;
        return Objects.equals(indexName(), other.indexName())
                && Objects.equals(provisionedWriteCapacityUnits(), other.provisionedWriteCapacityUnits())
                && Objects.equals(provisionedWriteCapacityAutoScalingSettingsUpdate(),
                        other.provisionedWriteCapacityAutoScalingSettingsUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalTableGlobalSecondaryIndexSettingsUpdate").add("IndexName", indexName())
                .add("ProvisionedWriteCapacityUnits", provisionedWriteCapacityUnits())
                .add("ProvisionedWriteCapacityAutoScalingSettingsUpdate", provisionedWriteCapacityAutoScalingSettingsUpdate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "ProvisionedWriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(provisionedWriteCapacityUnits()));
        case "ProvisionedWriteCapacityAutoScalingSettingsUpdate":
            return Optional.ofNullable(clazz.cast(provisionedWriteCapacityAutoScalingSettingsUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalTableGlobalSecondaryIndexSettingsUpdate, T> g) {
        return obj -> g.apply((GlobalTableGlobalSecondaryIndexSettingsUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalTableGlobalSecondaryIndexSettingsUpdate> {
        /**
         * <p>
         * The name of the global secondary index. The name must be unique among all other indexes on this table.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index. The name must be unique among all other indexes on this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code>
         * </p>
         * 
         * @param provisionedWriteCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits);

        /**
         * <p>
         * Auto scaling settings for managing a global secondary index's write capacity units.
         * </p>
         * 
         * @param provisionedWriteCapacityAutoScalingSettingsUpdate
         *        Auto scaling settings for managing a global secondary index's write capacity units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedWriteCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingSettingsUpdate);

        /**
         * <p>
         * Auto scaling settings for managing a global secondary index's write capacity units.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingSettingsUpdate.Builder} avoiding the
         * need to create one manually via {@link AutoScalingSettingsUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsUpdate.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #provisionedWriteCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate)}.
         * 
         * @param provisionedWriteCapacityAutoScalingSettingsUpdate
         *        a consumer that will call methods on {@link AutoScalingSettingsUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedWriteCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate)
         */
        default Builder provisionedWriteCapacityAutoScalingSettingsUpdate(
                Consumer<AutoScalingSettingsUpdate.Builder> provisionedWriteCapacityAutoScalingSettingsUpdate) {
            return provisionedWriteCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate.builder()
                    .applyMutation(provisionedWriteCapacityAutoScalingSettingsUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private Long provisionedWriteCapacityUnits;

        private AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingSettingsUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTableGlobalSecondaryIndexSettingsUpdate model) {
            indexName(model.indexName);
            provisionedWriteCapacityUnits(model.provisionedWriteCapacityUnits);
            provisionedWriteCapacityAutoScalingSettingsUpdate(model.provisionedWriteCapacityAutoScalingSettingsUpdate);
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        @Transient
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final Long getProvisionedWriteCapacityUnits() {
            return provisionedWriteCapacityUnits;
        }

        public final void setProvisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
        }

        @Override
        @Transient
        public final Builder provisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
            return this;
        }

        public final AutoScalingSettingsUpdate.Builder getProvisionedWriteCapacityAutoScalingSettingsUpdate() {
            return provisionedWriteCapacityAutoScalingSettingsUpdate != null ? provisionedWriteCapacityAutoScalingSettingsUpdate
                    .toBuilder() : null;
        }

        public final void setProvisionedWriteCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate.BuilderImpl provisionedWriteCapacityAutoScalingSettingsUpdate) {
            this.provisionedWriteCapacityAutoScalingSettingsUpdate = provisionedWriteCapacityAutoScalingSettingsUpdate != null ? provisionedWriteCapacityAutoScalingSettingsUpdate
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder provisionedWriteCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingSettingsUpdate) {
            this.provisionedWriteCapacityAutoScalingSettingsUpdate = provisionedWriteCapacityAutoScalingSettingsUpdate;
            return this;
        }

        @Override
        public GlobalTableGlobalSecondaryIndexSettingsUpdate build() {
            return new GlobalTableGlobalSecondaryIndexSettingsUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
