/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class BatchGetResponseMapCopier {
    static Map<String, List<Map<String, AttributeValue>>> copy(
            Map<String, ? extends Collection<? extends Map<String, ? extends AttributeValue>>> batchGetResponseMapParam) {
        Map<String, List<Map<String, AttributeValue>>> map;
        if (batchGetResponseMapParam == null || batchGetResponseMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<Map<String, AttributeValue>>> modifiableMap = new LinkedHashMap<>();
            batchGetResponseMapParam.forEach((key, value) -> {
                List<Map<String, AttributeValue>> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Map<String, AttributeValue>> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        Map<String, AttributeValue> map1;
                        if (entry == null || entry instanceof SdkAutoConstructMap) {
                            map1 = DefaultSdkAutoConstructMap.getInstance();
                        } else {
                            Map<String, AttributeValue> modifiableMap1 = new LinkedHashMap<>();
                            entry.forEach((key1, value1) -> {
                                modifiableMap1.put(key1, value1);
                            });
                            map1 = Collections.unmodifiableMap(modifiableMap1);
                        }
                        modifiableList.add(map1);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<Map<String, AttributeValue>>> copyFromBuilder(
            Map<String, ? extends Collection<? extends Map<String, ? extends AttributeValue.Builder>>> batchGetResponseMapParam) {
        Map<String, List<Map<String, AttributeValue>>> map;
        if (batchGetResponseMapParam == null || batchGetResponseMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<Map<String, AttributeValue>>> modifiableMap = new LinkedHashMap<>();
            batchGetResponseMapParam.forEach((key, value) -> {
                List<Map<String, AttributeValue>> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Map<String, AttributeValue>> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        Map<String, AttributeValue> map1;
                        if (entry == null || entry instanceof SdkAutoConstructMap) {
                            map1 = DefaultSdkAutoConstructMap.getInstance();
                        } else {
                            Map<String, AttributeValue> modifiableMap1 = new LinkedHashMap<>();
                            entry.forEach((key1, value1) -> {
                                AttributeValue member = value1.build();
                                modifiableMap1.put(key1, member);
                            });
                            map1 = Collections.unmodifiableMap(modifiableMap1);
                        }
                        modifiableList.add(map1);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<Map<String, AttributeValue.Builder>>> copyToBuilder(
            Map<String, ? extends Collection<? extends Map<String, ? extends AttributeValue>>> batchGetResponseMapParam) {
        Map<String, List<Map<String, AttributeValue.Builder>>> map;
        if (batchGetResponseMapParam == null || batchGetResponseMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<Map<String, AttributeValue.Builder>>> modifiableMap = new LinkedHashMap<>();
            batchGetResponseMapParam.forEach((key, value) -> {
                List<Map<String, AttributeValue.Builder>> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Map<String, AttributeValue.Builder>> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        Map<String, AttributeValue.Builder> map1;
                        if (entry == null || entry instanceof SdkAutoConstructMap) {
                            map1 = DefaultSdkAutoConstructMap.getInstance();
                        } else {
                            Map<String, AttributeValue.Builder> modifiableMap1 = new LinkedHashMap<>();
                            entry.forEach((key1, value1) -> {
                                AttributeValue.Builder member = value1.toBuilder();
                                modifiableMap1.put(key1, member);
                            });
                            map1 = Collections.unmodifiableMap(modifiableMap1);
                        }
                        modifiableList.add(map1);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
