/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportFormat {
    DYNAMODB_JSON("DYNAMODB_JSON"),
    ION("ION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportFormat> VALUE_MAP;
    private final String value;

    private ExportFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportFormat> knownValues() {
        EnumSet<ExportFormat> knownValues = EnumSet.allOf(ExportFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportFormat.class, ExportFormat::toString);
    }
}

