/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportTableToPointInTimeRequest extends DynamoDbRequest implements
        ToCopyableBuilder<ExportTableToPointInTimeRequest.Builder, ExportTableToPointInTimeRequest> {
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableArn").getter(getter(ExportTableToPointInTimeRequest::tableArn)).setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()).build();

    private static final SdkField<Instant> EXPORT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExportTime").getter(getter(ExportTableToPointInTimeRequest::exportTime))
            .setter(setter(Builder::exportTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTime").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ExportTableToPointInTimeRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(ExportTableToPointInTimeRequest::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketOwner").getter(getter(ExportTableToPointInTimeRequest::s3BucketOwner))
            .setter(setter(Builder::s3BucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketOwner").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix").getter(getter(ExportTableToPointInTimeRequest::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final SdkField<String> S3_SSE_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3SseAlgorithm").getter(getter(ExportTableToPointInTimeRequest::s3SseAlgorithmAsString))
            .setter(setter(Builder::s3SseAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SseAlgorithm").build()).build();

    private static final SdkField<String> S3_SSE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3SseKmsKeyId").getter(getter(ExportTableToPointInTimeRequest::s3SseKmsKeyId))
            .setter(setter(Builder::s3SseKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SseKmsKeyId").build()).build();

    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportFormat").getter(getter(ExportTableToPointInTimeRequest::exportFormatAsString))
            .setter(setter(Builder::exportFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()).build();

    private static final SdkField<String> EXPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportType").getter(getter(ExportTableToPointInTimeRequest::exportTypeAsString))
            .setter(setter(Builder::exportType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportType").build()).build();

    private static final SdkField<IncrementalExportSpecification> INCREMENTAL_EXPORT_SPECIFICATION_FIELD = SdkField
            .<IncrementalExportSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("IncrementalExportSpecification")
            .getter(getter(ExportTableToPointInTimeRequest::incrementalExportSpecification))
            .setter(setter(Builder::incrementalExportSpecification))
            .constructor(IncrementalExportSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncrementalExportSpecification")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_ARN_FIELD,
            EXPORT_TIME_FIELD, CLIENT_TOKEN_FIELD, S3_BUCKET_FIELD, S3_BUCKET_OWNER_FIELD, S3_PREFIX_FIELD,
            S3_SSE_ALGORITHM_FIELD, S3_SSE_KMS_KEY_ID_FIELD, EXPORT_FORMAT_FIELD, EXPORT_TYPE_FIELD,
            INCREMENTAL_EXPORT_SPECIFICATION_FIELD));

    private final String tableArn;

    private final Instant exportTime;

    private final String clientToken;

    private final String s3Bucket;

    private final String s3BucketOwner;

    private final String s3Prefix;

    private final String s3SseAlgorithm;

    private final String s3SseKmsKeyId;

    private final String exportFormat;

    private final String exportType;

    private final IncrementalExportSpecification incrementalExportSpecification;

    private ExportTableToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.tableArn = builder.tableArn;
        this.exportTime = builder.exportTime;
        this.clientToken = builder.clientToken;
        this.s3Bucket = builder.s3Bucket;
        this.s3BucketOwner = builder.s3BucketOwner;
        this.s3Prefix = builder.s3Prefix;
        this.s3SseAlgorithm = builder.s3SseAlgorithm;
        this.s3SseKmsKeyId = builder.s3SseKmsKeyId;
        this.exportFormat = builder.exportFormat;
        this.exportType = builder.exportType;
        this.incrementalExportSpecification = builder.incrementalExportSpecification;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the table to export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the table to export.
     */
    public final String tableArn() {
        return tableArn;
    }

    /**
     * <p>
     * Time in the past from which to export table data, counted in seconds from the start of the Unix epoch. The table
     * export will be a snapshot of the table's state at this point in time.
     * </p>
     * 
     * @return Time in the past from which to export table data, counted in seconds from the start of the Unix epoch.
     *         The table export will be a snapshot of the table's state at this point in time.
     */
    public final Instant exportTime() {
        return exportTime;
    }

    /**
     * <p>
     * Providing a <code>ClientToken</code> makes the call to <code>ExportTableToPointInTimeInput</code> idempotent,
     * meaning that multiple identical calls have the same effect as one single call.
     * </p>
     * <p>
     * A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any request
     * with the same client token is treated as a new request. Do not resubmit the same request with the same client
     * token for more than 8 hours, or the result might not be idempotent.
     * </p>
     * <p>
     * If you submit a request with the same client token but a change in other parameters within the 8-hour idempotency
     * window, DynamoDB returns an <code>ImportConflictException</code>.
     * </p>
     * 
     * @return Providing a <code>ClientToken</code> makes the call to <code>ExportTableToPointInTimeInput</code>
     *         idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
     *         <p>
     *         A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any
     *         request with the same client token is treated as a new request. Do not resubmit the same request with the
     *         same client token for more than 8 hours, or the result might not be idempotent.
     *         </p>
     *         <p>
     *         If you submit a request with the same client token but a change in other parameters within the 8-hour
     *         idempotency window, DynamoDB returns an <code>ImportConflictException</code>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket to export the snapshot to.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket to export the snapshot to.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the bucket the export will be stored in.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the bucket the export will be stored in.
     */
    public final String s3BucketOwner() {
        return s3BucketOwner;
    }

    /**
     * <p>
     * The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     * </p>
     * 
     * @return The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    /**
     * <p>
     * Type of encryption used on the bucket where export data will be stored. Valid values for
     * <code>S3SseAlgorithm</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AES256</code> - server-side encryption with Amazon S3 managed keys
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code> - server-side encryption with KMS managed keys
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3SseAlgorithm}
     * will return {@link S3SseAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3SseAlgorithmAsString}.
     * </p>
     * 
     * @return Type of encryption used on the bucket where export data will be stored. Valid values for
     *         <code>S3SseAlgorithm</code> are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AES256</code> - server-side encryption with Amazon S3 managed keys
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code> - server-side encryption with KMS managed keys
     *         </p>
     *         </li>
     * @see S3SseAlgorithm
     */
    public final S3SseAlgorithm s3SseAlgorithm() {
        return S3SseAlgorithm.fromValue(s3SseAlgorithm);
    }

    /**
     * <p>
     * Type of encryption used on the bucket where export data will be stored. Valid values for
     * <code>S3SseAlgorithm</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AES256</code> - server-side encryption with Amazon S3 managed keys
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code> - server-side encryption with KMS managed keys
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3SseAlgorithm}
     * will return {@link S3SseAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3SseAlgorithmAsString}.
     * </p>
     * 
     * @return Type of encryption used on the bucket where export data will be stored. Valid values for
     *         <code>S3SseAlgorithm</code> are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AES256</code> - server-side encryption with Amazon S3 managed keys
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code> - server-side encryption with KMS managed keys
     *         </p>
     *         </li>
     * @see S3SseAlgorithm
     */
    public final String s3SseAlgorithmAsString() {
        return s3SseAlgorithm;
    }

    /**
     * <p>
     * The ID of the KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
     * </p>
     * 
     * @return The ID of the KMS managed key used to encrypt the S3 bucket where export data will be stored (if
     *         applicable).
     */
    public final String s3SseKmsKeyId() {
        return s3SseKmsKeyId;
    }

    /**
     * <p>
     * The format for the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or
     * <code>ION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link ExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The format for the exported data. Valid values for <code>ExportFormat</code> are
     *         <code>DYNAMODB_JSON</code> or <code>ION</code>.
     * @see ExportFormat
     */
    public final ExportFormat exportFormat() {
        return ExportFormat.fromValue(exportFormat);
    }

    /**
     * <p>
     * The format for the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or
     * <code>ION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link ExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The format for the exported data. Valid values for <code>ExportFormat</code> are
     *         <code>DYNAMODB_JSON</code> or <code>ION</code>.
     * @see ExportFormat
     */
    public final String exportFormatAsString() {
        return exportFormat;
    }

    /**
     * <p>
     * Choice of whether to execute as a full export or incremental export. Valid values are <code>FULL_EXPORT</code> or
     * <code>INCREMENTAL_EXPORT</code>. If <code>INCREMENTAL_EXPORT</code> is provided, the
     * <code>IncrementalExportSpecification</code> must also be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeAsString}.
     * </p>
     * 
     * @return Choice of whether to execute as a full export or incremental export. Valid values are
     *         <code>FULL_EXPORT</code> or <code>INCREMENTAL_EXPORT</code>. If <code>INCREMENTAL_EXPORT</code> is
     *         provided, the <code>IncrementalExportSpecification</code> must also be used.
     * @see ExportType
     */
    public final ExportType exportType() {
        return ExportType.fromValue(exportType);
    }

    /**
     * <p>
     * Choice of whether to execute as a full export or incremental export. Valid values are <code>FULL_EXPORT</code> or
     * <code>INCREMENTAL_EXPORT</code>. If <code>INCREMENTAL_EXPORT</code> is provided, the
     * <code>IncrementalExportSpecification</code> must also be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportType} will
     * return {@link ExportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportTypeAsString}.
     * </p>
     * 
     * @return Choice of whether to execute as a full export or incremental export. Valid values are
     *         <code>FULL_EXPORT</code> or <code>INCREMENTAL_EXPORT</code>. If <code>INCREMENTAL_EXPORT</code> is
     *         provided, the <code>IncrementalExportSpecification</code> must also be used.
     * @see ExportType
     */
    public final String exportTypeAsString() {
        return exportType;
    }

    /**
     * <p>
     * Optional object containing the parameters specific to an incremental export.
     * </p>
     * 
     * @return Optional object containing the parameters specific to an incremental export.
     */
    public final IncrementalExportSpecification incrementalExportSpecification() {
        return incrementalExportSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportTime());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3SseAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3SseKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(exportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(incrementalExportSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTableToPointInTimeRequest)) {
            return false;
        }
        ExportTableToPointInTimeRequest other = (ExportTableToPointInTimeRequest) obj;
        return Objects.equals(tableArn(), other.tableArn()) && Objects.equals(exportTime(), other.exportTime())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(s3BucketOwner(), other.s3BucketOwner()) && Objects.equals(s3Prefix(), other.s3Prefix())
                && Objects.equals(s3SseAlgorithmAsString(), other.s3SseAlgorithmAsString())
                && Objects.equals(s3SseKmsKeyId(), other.s3SseKmsKeyId())
                && Objects.equals(exportFormatAsString(), other.exportFormatAsString())
                && Objects.equals(exportTypeAsString(), other.exportTypeAsString())
                && Objects.equals(incrementalExportSpecification(), other.incrementalExportSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportTableToPointInTimeRequest").add("TableArn", tableArn()).add("ExportTime", exportTime())
                .add("ClientToken", clientToken()).add("S3Bucket", s3Bucket()).add("S3BucketOwner", s3BucketOwner())
                .add("S3Prefix", s3Prefix()).add("S3SseAlgorithm", s3SseAlgorithmAsString())
                .add("S3SseKmsKeyId", s3SseKmsKeyId()).add("ExportFormat", exportFormatAsString())
                .add("ExportType", exportTypeAsString()).add("IncrementalExportSpecification", incrementalExportSpecification())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        case "ExportTime":
            return Optional.ofNullable(clazz.cast(exportTime()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3BucketOwner":
            return Optional.ofNullable(clazz.cast(s3BucketOwner()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "S3SseAlgorithm":
            return Optional.ofNullable(clazz.cast(s3SseAlgorithmAsString()));
        case "S3SseKmsKeyId":
            return Optional.ofNullable(clazz.cast(s3SseKmsKeyId()));
        case "ExportFormat":
            return Optional.ofNullable(clazz.cast(exportFormatAsString()));
        case "ExportType":
            return Optional.ofNullable(clazz.cast(exportTypeAsString()));
        case "IncrementalExportSpecification":
            return Optional.ofNullable(clazz.cast(incrementalExportSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTableToPointInTimeRequest, T> g) {
        return obj -> g.apply((ExportTableToPointInTimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExportTableToPointInTimeRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the table to export.
         * </p>
         * 
         * @param tableArn
         *        The Amazon Resource Name (ARN) associated with the table to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);

        /**
         * <p>
         * Time in the past from which to export table data, counted in seconds from the start of the Unix epoch. The
         * table export will be a snapshot of the table's state at this point in time.
         * </p>
         * 
         * @param exportTime
         *        Time in the past from which to export table data, counted in seconds from the start of the Unix epoch.
         *        The table export will be a snapshot of the table's state at this point in time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTime(Instant exportTime);

        /**
         * <p>
         * Providing a <code>ClientToken</code> makes the call to <code>ExportTableToPointInTimeInput</code> idempotent,
         * meaning that multiple identical calls have the same effect as one single call.
         * </p>
         * <p>
         * A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any
         * request with the same client token is treated as a new request. Do not resubmit the same request with the
         * same client token for more than 8 hours, or the result might not be idempotent.
         * </p>
         * <p>
         * If you submit a request with the same client token but a change in other parameters within the 8-hour
         * idempotency window, DynamoDB returns an <code>ImportConflictException</code>.
         * </p>
         * 
         * @param clientToken
         *        Providing a <code>ClientToken</code> makes the call to <code>ExportTableToPointInTimeInput</code>
         *        idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
         *        <p>
         *        A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours,
         *        any request with the same client token is treated as a new request. Do not resubmit the same request
         *        with the same client token for more than 8 hours, or the result might not be idempotent.
         *        </p>
         *        <p>
         *        If you submit a request with the same client token but a change in other parameters within the 8-hour
         *        idempotency window, DynamoDB returns an <code>ImportConflictException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the Amazon S3 bucket to export the snapshot to.
         * </p>
         * 
         * @param s3Bucket
         *        The name of the Amazon S3 bucket to export the snapshot to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the bucket the export will be stored in.
         * </p>
         * 
         * @param s3BucketOwner
         *        The ID of the Amazon Web Services account that owns the bucket the export will be stored in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketOwner(String s3BucketOwner);

        /**
         * <p>
         * The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
         * </p>
         * 
         * @param s3Prefix
         *        The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * <p>
         * Type of encryption used on the bucket where export data will be stored. Valid values for
         * <code>S3SseAlgorithm</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AES256</code> - server-side encryption with Amazon S3 managed keys
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code> - server-side encryption with KMS managed keys
         * </p>
         * </li>
         * </ul>
         * 
         * @param s3SseAlgorithm
         *        Type of encryption used on the bucket where export data will be stored. Valid values for
         *        <code>S3SseAlgorithm</code> are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AES256</code> - server-side encryption with Amazon S3 managed keys
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code> - server-side encryption with KMS managed keys
         *        </p>
         *        </li>
         * @see S3SseAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3SseAlgorithm
         */
        Builder s3SseAlgorithm(String s3SseAlgorithm);

        /**
         * <p>
         * Type of encryption used on the bucket where export data will be stored. Valid values for
         * <code>S3SseAlgorithm</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AES256</code> - server-side encryption with Amazon S3 managed keys
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code> - server-side encryption with KMS managed keys
         * </p>
         * </li>
         * </ul>
         * 
         * @param s3SseAlgorithm
         *        Type of encryption used on the bucket where export data will be stored. Valid values for
         *        <code>S3SseAlgorithm</code> are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AES256</code> - server-side encryption with Amazon S3 managed keys
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code> - server-side encryption with KMS managed keys
         *        </p>
         *        </li>
         * @see S3SseAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3SseAlgorithm
         */
        Builder s3SseAlgorithm(S3SseAlgorithm s3SseAlgorithm);

        /**
         * <p>
         * The ID of the KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).
         * </p>
         * 
         * @param s3SseKmsKeyId
         *        The ID of the KMS managed key used to encrypt the S3 bucket where export data will be stored (if
         *        applicable).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3SseKmsKeyId(String s3SseKmsKeyId);

        /**
         * <p>
         * The format for the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code>
         * or <code>ION</code>.
         * </p>
         * 
         * @param exportFormat
         *        The format for the exported data. Valid values for <code>ExportFormat</code> are
         *        <code>DYNAMODB_JSON</code> or <code>ION</code>.
         * @see ExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFormat
         */
        Builder exportFormat(String exportFormat);

        /**
         * <p>
         * The format for the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code>
         * or <code>ION</code>.
         * </p>
         * 
         * @param exportFormat
         *        The format for the exported data. Valid values for <code>ExportFormat</code> are
         *        <code>DYNAMODB_JSON</code> or <code>ION</code>.
         * @see ExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFormat
         */
        Builder exportFormat(ExportFormat exportFormat);

        /**
         * <p>
         * Choice of whether to execute as a full export or incremental export. Valid values are
         * <code>FULL_EXPORT</code> or <code>INCREMENTAL_EXPORT</code>. If <code>INCREMENTAL_EXPORT</code> is provided,
         * the <code>IncrementalExportSpecification</code> must also be used.
         * </p>
         * 
         * @param exportType
         *        Choice of whether to execute as a full export or incremental export. Valid values are
         *        <code>FULL_EXPORT</code> or <code>INCREMENTAL_EXPORT</code>. If <code>INCREMENTAL_EXPORT</code> is
         *        provided, the <code>IncrementalExportSpecification</code> must also be used.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(String exportType);

        /**
         * <p>
         * Choice of whether to execute as a full export or incremental export. Valid values are
         * <code>FULL_EXPORT</code> or <code>INCREMENTAL_EXPORT</code>. If <code>INCREMENTAL_EXPORT</code> is provided,
         * the <code>IncrementalExportSpecification</code> must also be used.
         * </p>
         * 
         * @param exportType
         *        Choice of whether to execute as a full export or incremental export. Valid values are
         *        <code>FULL_EXPORT</code> or <code>INCREMENTAL_EXPORT</code>. If <code>INCREMENTAL_EXPORT</code> is
         *        provided, the <code>IncrementalExportSpecification</code> must also be used.
         * @see ExportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportType
         */
        Builder exportType(ExportType exportType);

        /**
         * <p>
         * Optional object containing the parameters specific to an incremental export.
         * </p>
         * 
         * @param incrementalExportSpecification
         *        Optional object containing the parameters specific to an incremental export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalExportSpecification(IncrementalExportSpecification incrementalExportSpecification);

        /**
         * <p>
         * Optional object containing the parameters specific to an incremental export.
         * </p>
         * This is a convenience method that creates an instance of the {@link IncrementalExportSpecification.Builder}
         * avoiding the need to create one manually via {@link IncrementalExportSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IncrementalExportSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #incrementalExportSpecification(IncrementalExportSpecification)}.
         * 
         * @param incrementalExportSpecification
         *        a consumer that will call methods on {@link IncrementalExportSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incrementalExportSpecification(IncrementalExportSpecification)
         */
        default Builder incrementalExportSpecification(
                Consumer<IncrementalExportSpecification.Builder> incrementalExportSpecification) {
            return incrementalExportSpecification(IncrementalExportSpecification.builder()
                    .applyMutation(incrementalExportSpecification).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableArn;

        private Instant exportTime;

        private String clientToken;

        private String s3Bucket;

        private String s3BucketOwner;

        private String s3Prefix;

        private String s3SseAlgorithm;

        private String s3SseKmsKeyId;

        private String exportFormat;

        private String exportType;

        private IncrementalExportSpecification incrementalExportSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTableToPointInTimeRequest model) {
            super(model);
            tableArn(model.tableArn);
            exportTime(model.exportTime);
            clientToken(model.clientToken);
            s3Bucket(model.s3Bucket);
            s3BucketOwner(model.s3BucketOwner);
            s3Prefix(model.s3Prefix);
            s3SseAlgorithm(model.s3SseAlgorithm);
            s3SseKmsKeyId(model.s3SseKmsKeyId);
            exportFormat(model.exportFormat);
            exportType(model.exportType);
            incrementalExportSpecification(model.incrementalExportSpecification);
        }

        public final String getTableArn() {
            return tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final Instant getExportTime() {
            return exportTime;
        }

        public final void setExportTime(Instant exportTime) {
            this.exportTime = exportTime;
        }

        @Override
        public final Builder exportTime(Instant exportTime) {
            this.exportTime = exportTime;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3BucketOwner() {
            return s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3SseAlgorithm() {
            return s3SseAlgorithm;
        }

        public final void setS3SseAlgorithm(String s3SseAlgorithm) {
            this.s3SseAlgorithm = s3SseAlgorithm;
        }

        @Override
        public final Builder s3SseAlgorithm(String s3SseAlgorithm) {
            this.s3SseAlgorithm = s3SseAlgorithm;
            return this;
        }

        @Override
        public final Builder s3SseAlgorithm(S3SseAlgorithm s3SseAlgorithm) {
            this.s3SseAlgorithm(s3SseAlgorithm == null ? null : s3SseAlgorithm.toString());
            return this;
        }

        public final String getS3SseKmsKeyId() {
            return s3SseKmsKeyId;
        }

        public final void setS3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
        }

        @Override
        public final Builder s3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
            return this;
        }

        public final String getExportFormat() {
            return exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        public final Builder exportFormat(ExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        public final String getExportType() {
            return exportType;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        @Override
        public final Builder exportType(ExportType exportType) {
            this.exportType(exportType == null ? null : exportType.toString());
            return this;
        }

        public final IncrementalExportSpecification.Builder getIncrementalExportSpecification() {
            return incrementalExportSpecification != null ? incrementalExportSpecification.toBuilder() : null;
        }

        public final void setIncrementalExportSpecification(
                IncrementalExportSpecification.BuilderImpl incrementalExportSpecification) {
            this.incrementalExportSpecification = incrementalExportSpecification != null ? incrementalExportSpecification.build()
                    : null;
        }

        @Override
        public final Builder incrementalExportSpecification(IncrementalExportSpecification incrementalExportSpecification) {
            this.incrementalExportSpecification = incrementalExportSpecification;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportTableToPointInTimeRequest build() {
            return new ExportTableToPointInTimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
