/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the auto scaling settings of a global secondary index for a replica that will be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaGlobalSecondaryIndexAutoScalingUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaGlobalSecondaryIndexAutoScalingUpdate.Builder, ReplicaGlobalSecondaryIndexAutoScalingUpdate> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(ReplicaGlobalSecondaryIndexAutoScalingUpdate::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<AutoScalingSettingsUpdate> PROVISIONED_READ_CAPACITY_AUTO_SCALING_UPDATE_FIELD = SdkField
            .<AutoScalingSettingsUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedReadCapacityAutoScalingUpdate")
            .getter(getter(ReplicaGlobalSecondaryIndexAutoScalingUpdate::provisionedReadCapacityAutoScalingUpdate))
            .setter(setter(Builder::provisionedReadCapacityAutoScalingUpdate))
            .constructor(AutoScalingSettingsUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ProvisionedReadCapacityAutoScalingUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            PROVISIONED_READ_CAPACITY_AUTO_SCALING_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indexName;

    private final AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingUpdate;

    private ReplicaGlobalSecondaryIndexAutoScalingUpdate(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedReadCapacityAutoScalingUpdate = builder.provisionedReadCapacityAutoScalingUpdate;
    }

    /**
     * <p>
     * The name of the global secondary index.
     * </p>
     * 
     * @return The name of the global secondary index.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * Returns the value of the ProvisionedReadCapacityAutoScalingUpdate property for this object.
     * 
     * @return The value of the ProvisionedReadCapacityAutoScalingUpdate property for this object.
     */
    public final AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingUpdate() {
        return provisionedReadCapacityAutoScalingUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedReadCapacityAutoScalingUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaGlobalSecondaryIndexAutoScalingUpdate)) {
            return false;
        }
        ReplicaGlobalSecondaryIndexAutoScalingUpdate other = (ReplicaGlobalSecondaryIndexAutoScalingUpdate) obj;
        return Objects.equals(indexName(), other.indexName())
                && Objects.equals(provisionedReadCapacityAutoScalingUpdate(), other.provisionedReadCapacityAutoScalingUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaGlobalSecondaryIndexAutoScalingUpdate").add("IndexName", indexName())
                .add("ProvisionedReadCapacityAutoScalingUpdate", provisionedReadCapacityAutoScalingUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "ProvisionedReadCapacityAutoScalingUpdate":
            return Optional.ofNullable(clazz.cast(provisionedReadCapacityAutoScalingUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaGlobalSecondaryIndexAutoScalingUpdate, T> g) {
        return obj -> g.apply((ReplicaGlobalSecondaryIndexAutoScalingUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaGlobalSecondaryIndexAutoScalingUpdate> {
        /**
         * <p>
         * The name of the global secondary index.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * Sets the value of the ProvisionedReadCapacityAutoScalingUpdate property for this object.
         *
         * @param provisionedReadCapacityAutoScalingUpdate
         *        The new value for the ProvisionedReadCapacityAutoScalingUpdate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedReadCapacityAutoScalingUpdate(AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingUpdate);

        /**
         * Sets the value of the ProvisionedReadCapacityAutoScalingUpdate property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AutoScalingSettingsUpdate.Builder}
         * avoiding the need to create one manually via {@link AutoScalingSettingsUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingSettingsUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #provisionedReadCapacityAutoScalingUpdate(AutoScalingSettingsUpdate)}.
         * 
         * @param provisionedReadCapacityAutoScalingUpdate
         *        a consumer that will call methods on {@link AutoScalingSettingsUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedReadCapacityAutoScalingUpdate(AutoScalingSettingsUpdate)
         */
        default Builder provisionedReadCapacityAutoScalingUpdate(
                Consumer<AutoScalingSettingsUpdate.Builder> provisionedReadCapacityAutoScalingUpdate) {
            return provisionedReadCapacityAutoScalingUpdate(AutoScalingSettingsUpdate.builder()
                    .applyMutation(provisionedReadCapacityAutoScalingUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaGlobalSecondaryIndexAutoScalingUpdate model) {
            indexName(model.indexName);
            provisionedReadCapacityAutoScalingUpdate(model.provisionedReadCapacityAutoScalingUpdate);
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final AutoScalingSettingsUpdate.Builder getProvisionedReadCapacityAutoScalingUpdate() {
            return provisionedReadCapacityAutoScalingUpdate != null ? provisionedReadCapacityAutoScalingUpdate.toBuilder() : null;
        }

        public final void setProvisionedReadCapacityAutoScalingUpdate(
                AutoScalingSettingsUpdate.BuilderImpl provisionedReadCapacityAutoScalingUpdate) {
            this.provisionedReadCapacityAutoScalingUpdate = provisionedReadCapacityAutoScalingUpdate != null ? provisionedReadCapacityAutoScalingUpdate
                    .build() : null;
        }

        @Override
        public final Builder provisionedReadCapacityAutoScalingUpdate(
                AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingUpdate) {
            this.provisionedReadCapacityAutoScalingUpdate = provisionedReadCapacityAutoScalingUpdate;
            return this;
        }

        @Override
        public ReplicaGlobalSecondaryIndexAutoScalingUpdate build() {
            return new ReplicaGlobalSecondaryIndexAutoScalingUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
