/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the continuous backups and point in time recovery settings on the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinuousBackupsDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ContinuousBackupsDescription.Builder, ContinuousBackupsDescription> {
    private static final SdkField<String> CONTINUOUS_BACKUPS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContinuousBackupsStatus").getter(getter(ContinuousBackupsDescription::continuousBackupsStatusAsString))
            .setter(setter(Builder::continuousBackupsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousBackupsStatus").build())
            .build();

    private static final SdkField<PointInTimeRecoveryDescription> POINT_IN_TIME_RECOVERY_DESCRIPTION_FIELD = SdkField
            .<PointInTimeRecoveryDescription> builder(MarshallingType.SDK_POJO)
            .memberName("PointInTimeRecoveryDescription")
            .getter(getter(ContinuousBackupsDescription::pointInTimeRecoveryDescription))
            .setter(setter(Builder::pointInTimeRecoveryDescription))
            .constructor(PointInTimeRecoveryDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointInTimeRecoveryDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTINUOUS_BACKUPS_STATUS_FIELD, POINT_IN_TIME_RECOVERY_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String continuousBackupsStatus;

    private final PointInTimeRecoveryDescription pointInTimeRecoveryDescription;

    private ContinuousBackupsDescription(BuilderImpl builder) {
        this.continuousBackupsStatus = builder.continuousBackupsStatus;
        this.pointInTimeRecoveryDescription = builder.pointInTimeRecoveryDescription;
    }

    /**
     * <p>
     * <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #continuousBackupsStatus} will return {@link ContinuousBackupsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #continuousBackupsStatusAsString}.
     * </p>
     * 
     * @return <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED
     * @see ContinuousBackupsStatus
     */
    public final ContinuousBackupsStatus continuousBackupsStatus() {
        return ContinuousBackupsStatus.fromValue(continuousBackupsStatus);
    }

    /**
     * <p>
     * <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #continuousBackupsStatus} will return {@link ContinuousBackupsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #continuousBackupsStatusAsString}.
     * </p>
     * 
     * @return <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED
     * @see ContinuousBackupsStatus
     */
    public final String continuousBackupsStatusAsString() {
        return continuousBackupsStatus;
    }

    /**
     * <p>
     * The description of the point in time recovery settings applied to the table.
     * </p>
     * 
     * @return The description of the point in time recovery settings applied to the table.
     */
    public final PointInTimeRecoveryDescription pointInTimeRecoveryDescription() {
        return pointInTimeRecoveryDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continuousBackupsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeRecoveryDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousBackupsDescription)) {
            return false;
        }
        ContinuousBackupsDescription other = (ContinuousBackupsDescription) obj;
        return Objects.equals(continuousBackupsStatusAsString(), other.continuousBackupsStatusAsString())
                && Objects.equals(pointInTimeRecoveryDescription(), other.pointInTimeRecoveryDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContinuousBackupsDescription").add("ContinuousBackupsStatus", continuousBackupsStatusAsString())
                .add("PointInTimeRecoveryDescription", pointInTimeRecoveryDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinuousBackupsStatus":
            return Optional.ofNullable(clazz.cast(continuousBackupsStatusAsString()));
        case "PointInTimeRecoveryDescription":
            return Optional.ofNullable(clazz.cast(pointInTimeRecoveryDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContinuousBackupsDescription, T> g) {
        return obj -> g.apply((ContinuousBackupsDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContinuousBackupsDescription> {
        /**
         * <p>
         * <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED
         * </p>
         * 
         * @param continuousBackupsStatus
         *        <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED
         * @see ContinuousBackupsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContinuousBackupsStatus
         */
        Builder continuousBackupsStatus(String continuousBackupsStatus);

        /**
         * <p>
         * <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED
         * </p>
         * 
         * @param continuousBackupsStatus
         *        <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED
         * @see ContinuousBackupsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContinuousBackupsStatus
         */
        Builder continuousBackupsStatus(ContinuousBackupsStatus continuousBackupsStatus);

        /**
         * <p>
         * The description of the point in time recovery settings applied to the table.
         * </p>
         * 
         * @param pointInTimeRecoveryDescription
         *        The description of the point in time recovery settings applied to the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointInTimeRecoveryDescription(PointInTimeRecoveryDescription pointInTimeRecoveryDescription);

        /**
         * <p>
         * The description of the point in time recovery settings applied to the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link PointInTimeRecoveryDescription.Builder}
         * avoiding the need to create one manually via {@link PointInTimeRecoveryDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PointInTimeRecoveryDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #pointInTimeRecoveryDescription(PointInTimeRecoveryDescription)}.
         * 
         * @param pointInTimeRecoveryDescription
         *        a consumer that will call methods on {@link PointInTimeRecoveryDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointInTimeRecoveryDescription(PointInTimeRecoveryDescription)
         */
        default Builder pointInTimeRecoveryDescription(
                Consumer<PointInTimeRecoveryDescription.Builder> pointInTimeRecoveryDescription) {
            return pointInTimeRecoveryDescription(PointInTimeRecoveryDescription.builder()
                    .applyMutation(pointInTimeRecoveryDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String continuousBackupsStatus;

        private PointInTimeRecoveryDescription pointInTimeRecoveryDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousBackupsDescription model) {
            continuousBackupsStatus(model.continuousBackupsStatus);
            pointInTimeRecoveryDescription(model.pointInTimeRecoveryDescription);
        }

        public final String getContinuousBackupsStatus() {
            return continuousBackupsStatus;
        }

        public final void setContinuousBackupsStatus(String continuousBackupsStatus) {
            this.continuousBackupsStatus = continuousBackupsStatus;
        }

        @Override
        public final Builder continuousBackupsStatus(String continuousBackupsStatus) {
            this.continuousBackupsStatus = continuousBackupsStatus;
            return this;
        }

        @Override
        public final Builder continuousBackupsStatus(ContinuousBackupsStatus continuousBackupsStatus) {
            this.continuousBackupsStatus(continuousBackupsStatus == null ? null : continuousBackupsStatus.toString());
            return this;
        }

        public final PointInTimeRecoveryDescription.Builder getPointInTimeRecoveryDescription() {
            return pointInTimeRecoveryDescription != null ? pointInTimeRecoveryDescription.toBuilder() : null;
        }

        public final void setPointInTimeRecoveryDescription(
                PointInTimeRecoveryDescription.BuilderImpl pointInTimeRecoveryDescription) {
            this.pointInTimeRecoveryDescription = pointInTimeRecoveryDescription != null ? pointInTimeRecoveryDescription.build()
                    : null;
        }

        @Override
        public final Builder pointInTimeRecoveryDescription(PointInTimeRecoveryDescription pointInTimeRecoveryDescription) {
            this.pointInTimeRecoveryDescription = pointInTimeRecoveryDescription;
            return this;
        }

        @Override
        public ContinuousBackupsDescription build() {
            return new ContinuousBackupsDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
