/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enables updating the configuration for Kinesis Streaming.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKinesisStreamingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateKinesisStreamingConfiguration.Builder, UpdateKinesisStreamingConfiguration> {
    private static final SdkField<String> APPROXIMATE_CREATION_DATE_TIME_PRECISION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApproximateCreationDateTimePrecision")
            .getter(getter(UpdateKinesisStreamingConfiguration::approximateCreationDateTimePrecisionAsString))
            .setter(setter(Builder::approximateCreationDateTimePrecision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApproximateCreationDateTimePrecision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPROXIMATE_CREATION_DATE_TIME_PRECISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ApproximateCreationDateTimePrecision", APPROXIMATE_CREATION_DATE_TIME_PRECISION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String approximateCreationDateTimePrecision;

    private UpdateKinesisStreamingConfiguration(BuilderImpl builder) {
        this.approximateCreationDateTimePrecision = builder.approximateCreationDateTimePrecision;
    }

    /**
     * <p>
     * Enables updating the precision of Kinesis data stream timestamp.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approximateCreationDateTimePrecision} will return
     * {@link ApproximateCreationDateTimePrecision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #approximateCreationDateTimePrecisionAsString}.
     * </p>
     * 
     * @return Enables updating the precision of Kinesis data stream timestamp.
     * @see ApproximateCreationDateTimePrecision
     */
    public final ApproximateCreationDateTimePrecision approximateCreationDateTimePrecision() {
        return ApproximateCreationDateTimePrecision.fromValue(approximateCreationDateTimePrecision);
    }

    /**
     * <p>
     * Enables updating the precision of Kinesis data stream timestamp.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approximateCreationDateTimePrecision} will return
     * {@link ApproximateCreationDateTimePrecision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #approximateCreationDateTimePrecisionAsString}.
     * </p>
     * 
     * @return Enables updating the precision of Kinesis data stream timestamp.
     * @see ApproximateCreationDateTimePrecision
     */
    public final String approximateCreationDateTimePrecisionAsString() {
        return approximateCreationDateTimePrecision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approximateCreationDateTimePrecisionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKinesisStreamingConfiguration)) {
            return false;
        }
        UpdateKinesisStreamingConfiguration other = (UpdateKinesisStreamingConfiguration) obj;
        return Objects.equals(approximateCreationDateTimePrecisionAsString(),
                other.approximateCreationDateTimePrecisionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKinesisStreamingConfiguration")
                .add("ApproximateCreationDateTimePrecision", approximateCreationDateTimePrecisionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApproximateCreationDateTimePrecision":
            return Optional.ofNullable(clazz.cast(approximateCreationDateTimePrecisionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKinesisStreamingConfiguration, T> g) {
        return obj -> g.apply((UpdateKinesisStreamingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateKinesisStreamingConfiguration> {
        /**
         * <p>
         * Enables updating the precision of Kinesis data stream timestamp.
         * </p>
         * 
         * @param approximateCreationDateTimePrecision
         *        Enables updating the precision of Kinesis data stream timestamp.
         * @see ApproximateCreationDateTimePrecision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApproximateCreationDateTimePrecision
         */
        Builder approximateCreationDateTimePrecision(String approximateCreationDateTimePrecision);

        /**
         * <p>
         * Enables updating the precision of Kinesis data stream timestamp.
         * </p>
         * 
         * @param approximateCreationDateTimePrecision
         *        Enables updating the precision of Kinesis data stream timestamp.
         * @see ApproximateCreationDateTimePrecision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApproximateCreationDateTimePrecision
         */
        Builder approximateCreationDateTimePrecision(ApproximateCreationDateTimePrecision approximateCreationDateTimePrecision);
    }

    static final class BuilderImpl implements Builder {
        private String approximateCreationDateTimePrecision;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKinesisStreamingConfiguration model) {
            approximateCreationDateTimePrecision(model.approximateCreationDateTimePrecision);
        }

        public final String getApproximateCreationDateTimePrecision() {
            return approximateCreationDateTimePrecision;
        }

        public final void setApproximateCreationDateTimePrecision(String approximateCreationDateTimePrecision) {
            this.approximateCreationDateTimePrecision = approximateCreationDateTimePrecision;
        }

        @Override
        public final Builder approximateCreationDateTimePrecision(String approximateCreationDateTimePrecision) {
            this.approximateCreationDateTimePrecision = approximateCreationDateTimePrecision;
            return this;
        }

        @Override
        public final Builder approximateCreationDateTimePrecision(
                ApproximateCreationDateTimePrecision approximateCreationDateTimePrecision) {
            this.approximateCreationDateTimePrecision(approximateCreationDateTimePrecision == null ? null
                    : approximateCreationDateTimePrecision.toString());
            return this;
        }

        @Override
        public UpdateKinesisStreamingConfiguration build() {
            return new UpdateKinesisStreamingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
