/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImportResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DescribeImportResponse.Builder, DescribeImportResponse> {
    private static final SdkField<ImportTableDescription> IMPORT_TABLE_DESCRIPTION_FIELD = SdkField
            .<ImportTableDescription> builder(MarshallingType.SDK_POJO).memberName("ImportTableDescription")
            .getter(getter(DescribeImportResponse::importTableDescription)).setter(setter(Builder::importTableDescription))
            .constructor(ImportTableDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTableDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IMPORT_TABLE_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ImportTableDescription", IMPORT_TABLE_DESCRIPTION_FIELD);
                }
            });

    private final ImportTableDescription importTableDescription;

    private DescribeImportResponse(BuilderImpl builder) {
        super(builder);
        this.importTableDescription = builder.importTableDescription;
    }

    /**
     * <p>
     * Represents the properties of the table created for the import, and parameters of the import. The import
     * parameters include import status, how many items were processed, and how many errors were encountered.
     * </p>
     * 
     * @return Represents the properties of the table created for the import, and parameters of the import. The import
     *         parameters include import status, how many items were processed, and how many errors were encountered.
     */
    public final ImportTableDescription importTableDescription() {
        return importTableDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importTableDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportResponse)) {
            return false;
        }
        DescribeImportResponse other = (DescribeImportResponse) obj;
        return Objects.equals(importTableDescription(), other.importTableDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImportResponse").add("ImportTableDescription", importTableDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportTableDescription":
            return Optional.ofNullable(clazz.cast(importTableDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportResponse, T> g) {
        return obj -> g.apply((DescribeImportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImportResponse> {
        /**
         * <p>
         * Represents the properties of the table created for the import, and parameters of the import. The import
         * parameters include import status, how many items were processed, and how many errors were encountered.
         * </p>
         * 
         * @param importTableDescription
         *        Represents the properties of the table created for the import, and parameters of the import. The
         *        import parameters include import status, how many items were processed, and how many errors were
         *        encountered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTableDescription(ImportTableDescription importTableDescription);

        /**
         * <p>
         * Represents the properties of the table created for the import, and parameters of the import. The import
         * parameters include import status, how many items were processed, and how many errors were encountered.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportTableDescription.Builder} avoiding
         * the need to create one manually via {@link ImportTableDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportTableDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #importTableDescription(ImportTableDescription)}.
         * 
         * @param importTableDescription
         *        a consumer that will call methods on {@link ImportTableDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importTableDescription(ImportTableDescription)
         */
        default Builder importTableDescription(Consumer<ImportTableDescription.Builder> importTableDescription) {
            return importTableDescription(ImportTableDescription.builder().applyMutation(importTableDescription).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private ImportTableDescription importTableDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportResponse model) {
            super(model);
            importTableDescription(model.importTableDescription);
        }

        public final ImportTableDescription.Builder getImportTableDescription() {
            return importTableDescription != null ? importTableDescription.toBuilder() : null;
        }

        public final void setImportTableDescription(ImportTableDescription.BuilderImpl importTableDescription) {
            this.importTableDescription = importTableDescription != null ? importTableDescription.build() : null;
        }

        @Override
        public final Builder importTableDescription(ImportTableDescription importTableDescription) {
            this.importTableDescription = importTableDescription;
            return this;
        }

        @Override
        public DescribeImportResponse build() {
            return new DescribeImportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
