/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sets the maximum number of read and write units for the specified on-demand table. If you use this parameter, you
 * must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnDemandThroughput implements SdkPojo, Serializable,
        ToCopyableBuilder<OnDemandThroughput.Builder, OnDemandThroughput> {
    private static final SdkField<Long> MAX_READ_REQUEST_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxReadRequestUnits").getter(getter(OnDemandThroughput::maxReadRequestUnits))
            .setter(setter(Builder::maxReadRequestUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxReadRequestUnits").build())
            .build();

    private static final SdkField<Long> MAX_WRITE_REQUEST_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxWriteRequestUnits").getter(getter(OnDemandThroughput::maxWriteRequestUnits))
            .setter(setter(Builder::maxWriteRequestUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWriteRequestUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_READ_REQUEST_UNITS_FIELD,
            MAX_WRITE_REQUEST_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MaxReadRequestUnits", MAX_READ_REQUEST_UNITS_FIELD);
                    put("MaxWriteRequestUnits", MAX_WRITE_REQUEST_UNITS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long maxReadRequestUnits;

    private final Long maxWriteRequestUnits;

    private OnDemandThroughput(BuilderImpl builder) {
        this.maxReadRequestUnits = builder.maxReadRequestUnits;
        this.maxWriteRequestUnits = builder.maxWriteRequestUnits;
    }

    /**
     * <p>
     * Maximum number of read request units for the specified table.
     * </p>
     * <p>
     * To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of
     * <code>MaxReadRequestUnits</code> as greater than or equal to 1. To remove the maximum
     * <code>OnDemandThroughput</code> that is currently set on your table, set the value of
     * <code>MaxReadRequestUnits</code> to -1.
     * </p>
     * 
     * @return Maximum number of read request units for the specified table.</p>
     *         <p>
     *         To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of
     *         <code>MaxReadRequestUnits</code> as greater than or equal to 1. To remove the maximum
     *         <code>OnDemandThroughput</code> that is currently set on your table, set the value of
     *         <code>MaxReadRequestUnits</code> to -1.
     */
    public final Long maxReadRequestUnits() {
        return maxReadRequestUnits;
    }

    /**
     * <p>
     * Maximum number of write request units for the specified table.
     * </p>
     * <p>
     * To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of
     * <code>MaxWriteRequestUnits</code> as greater than or equal to 1. To remove the maximum
     * <code>OnDemandThroughput</code> that is currently set on your table, set the value of
     * <code>MaxWriteRequestUnits</code> to -1.
     * </p>
     * 
     * @return Maximum number of write request units for the specified table.</p>
     *         <p>
     *         To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of
     *         <code>MaxWriteRequestUnits</code> as greater than or equal to 1. To remove the maximum
     *         <code>OnDemandThroughput</code> that is currently set on your table, set the value of
     *         <code>MaxWriteRequestUnits</code> to -1.
     */
    public final Long maxWriteRequestUnits() {
        return maxWriteRequestUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxReadRequestUnits());
        hashCode = 31 * hashCode + Objects.hashCode(maxWriteRequestUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandThroughput)) {
            return false;
        }
        OnDemandThroughput other = (OnDemandThroughput) obj;
        return Objects.equals(maxReadRequestUnits(), other.maxReadRequestUnits())
                && Objects.equals(maxWriteRequestUnits(), other.maxWriteRequestUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnDemandThroughput").add("MaxReadRequestUnits", maxReadRequestUnits())
                .add("MaxWriteRequestUnits", maxWriteRequestUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxReadRequestUnits":
            return Optional.ofNullable(clazz.cast(maxReadRequestUnits()));
        case "MaxWriteRequestUnits":
            return Optional.ofNullable(clazz.cast(maxWriteRequestUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandThroughput, T> g) {
        return obj -> g.apply((OnDemandThroughput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnDemandThroughput> {
        /**
         * <p>
         * Maximum number of read request units for the specified table.
         * </p>
         * <p>
         * To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of
         * <code>MaxReadRequestUnits</code> as greater than or equal to 1. To remove the maximum
         * <code>OnDemandThroughput</code> that is currently set on your table, set the value of
         * <code>MaxReadRequestUnits</code> to -1.
         * </p>
         * 
         * @param maxReadRequestUnits
         *        Maximum number of read request units for the specified table.</p>
         *        <p>
         *        To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of
         *        <code>MaxReadRequestUnits</code> as greater than or equal to 1. To remove the maximum
         *        <code>OnDemandThroughput</code> that is currently set on your table, set the value of
         *        <code>MaxReadRequestUnits</code> to -1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxReadRequestUnits(Long maxReadRequestUnits);

        /**
         * <p>
         * Maximum number of write request units for the specified table.
         * </p>
         * <p>
         * To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of
         * <code>MaxWriteRequestUnits</code> as greater than or equal to 1. To remove the maximum
         * <code>OnDemandThroughput</code> that is currently set on your table, set the value of
         * <code>MaxWriteRequestUnits</code> to -1.
         * </p>
         * 
         * @param maxWriteRequestUnits
         *        Maximum number of write request units for the specified table.</p>
         *        <p>
         *        To specify a maximum <code>OnDemandThroughput</code> on your table, set the value of
         *        <code>MaxWriteRequestUnits</code> as greater than or equal to 1. To remove the maximum
         *        <code>OnDemandThroughput</code> that is currently set on your table, set the value of
         *        <code>MaxWriteRequestUnits</code> to -1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWriteRequestUnits(Long maxWriteRequestUnits);
    }

    static final class BuilderImpl implements Builder {
        private Long maxReadRequestUnits;

        private Long maxWriteRequestUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandThroughput model) {
            maxReadRequestUnits(model.maxReadRequestUnits);
            maxWriteRequestUnits(model.maxWriteRequestUnits);
        }

        public final Long getMaxReadRequestUnits() {
            return maxReadRequestUnits;
        }

        public final void setMaxReadRequestUnits(Long maxReadRequestUnits) {
            this.maxReadRequestUnits = maxReadRequestUnits;
        }

        @Override
        public final Builder maxReadRequestUnits(Long maxReadRequestUnits) {
            this.maxReadRequestUnits = maxReadRequestUnits;
            return this;
        }

        public final Long getMaxWriteRequestUnits() {
            return maxWriteRequestUnits;
        }

        public final void setMaxWriteRequestUnits(Long maxWriteRequestUnits) {
            this.maxWriteRequestUnits = maxWriteRequestUnits;
        }

        @Override
        public final Builder maxWriteRequestUnits(Long maxWriteRequestUnits) {
            this.maxWriteRequestUnits = maxWriteRequestUnits;
            return this;
        }

        @Override
        public OnDemandThroughput build() {
            return new OnDemandThroughput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
