/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the warm throughput value (in read units per second and write units per second) of the base table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableWarmThroughputDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<TableWarmThroughputDescription.Builder, TableWarmThroughputDescription> {
    private static final SdkField<Long> READ_UNITS_PER_SECOND_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ReadUnitsPerSecond").getter(getter(TableWarmThroughputDescription::readUnitsPerSecond))
            .setter(setter(Builder::readUnitsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadUnitsPerSecond").build())
            .build();

    private static final SdkField<Long> WRITE_UNITS_PER_SECOND_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WriteUnitsPerSecond").getter(getter(TableWarmThroughputDescription::writeUnitsPerSecond))
            .setter(setter(Builder::writeUnitsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteUnitsPerSecond").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TableWarmThroughputDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_UNITS_PER_SECOND_FIELD,
            WRITE_UNITS_PER_SECOND_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ReadUnitsPerSecond", READ_UNITS_PER_SECOND_FIELD);
                    put("WriteUnitsPerSecond", WRITE_UNITS_PER_SECOND_FIELD);
                    put("Status", STATUS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long readUnitsPerSecond;

    private final Long writeUnitsPerSecond;

    private final String status;

    private TableWarmThroughputDescription(BuilderImpl builder) {
        this.readUnitsPerSecond = builder.readUnitsPerSecond;
        this.writeUnitsPerSecond = builder.writeUnitsPerSecond;
        this.status = builder.status;
    }

    /**
     * <p>
     * Represents the base table's warm throughput value in read units per second.
     * </p>
     * 
     * @return Represents the base table's warm throughput value in read units per second.
     */
    public final Long readUnitsPerSecond() {
        return readUnitsPerSecond;
    }

    /**
     * <p>
     * Represents the base table's warm throughput value in write units per second.
     * </p>
     * 
     * @return Represents the base table's warm throughput value in write units per second.
     */
    public final Long writeUnitsPerSecond() {
        return writeUnitsPerSecond;
    }

    /**
     * <p>
     * Represents warm throughput value of the base table..
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Represents warm throughput value of the base table..
     * @see TableStatus
     */
    public final TableStatus status() {
        return TableStatus.fromValue(status);
    }

    /**
     * <p>
     * Represents warm throughput value of the base table..
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Represents warm throughput value of the base table..
     * @see TableStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readUnitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(writeUnitsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableWarmThroughputDescription)) {
            return false;
        }
        TableWarmThroughputDescription other = (TableWarmThroughputDescription) obj;
        return Objects.equals(readUnitsPerSecond(), other.readUnitsPerSecond())
                && Objects.equals(writeUnitsPerSecond(), other.writeUnitsPerSecond())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableWarmThroughputDescription").add("ReadUnitsPerSecond", readUnitsPerSecond())
                .add("WriteUnitsPerSecond", writeUnitsPerSecond()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadUnitsPerSecond":
            return Optional.ofNullable(clazz.cast(readUnitsPerSecond()));
        case "WriteUnitsPerSecond":
            return Optional.ofNullable(clazz.cast(writeUnitsPerSecond()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableWarmThroughputDescription, T> g) {
        return obj -> g.apply((TableWarmThroughputDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableWarmThroughputDescription> {
        /**
         * <p>
         * Represents the base table's warm throughput value in read units per second.
         * </p>
         * 
         * @param readUnitsPerSecond
         *        Represents the base table's warm throughput value in read units per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readUnitsPerSecond(Long readUnitsPerSecond);

        /**
         * <p>
         * Represents the base table's warm throughput value in write units per second.
         * </p>
         * 
         * @param writeUnitsPerSecond
         *        Represents the base table's warm throughput value in write units per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeUnitsPerSecond(Long writeUnitsPerSecond);

        /**
         * <p>
         * Represents warm throughput value of the base table..
         * </p>
         * 
         * @param status
         *        Represents warm throughput value of the base table..
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Represents warm throughput value of the base table..
         * </p>
         * 
         * @param status
         *        Represents warm throughput value of the base table..
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder status(TableStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Long readUnitsPerSecond;

        private Long writeUnitsPerSecond;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(TableWarmThroughputDescription model) {
            readUnitsPerSecond(model.readUnitsPerSecond);
            writeUnitsPerSecond(model.writeUnitsPerSecond);
            status(model.status);
        }

        public final Long getReadUnitsPerSecond() {
            return readUnitsPerSecond;
        }

        public final void setReadUnitsPerSecond(Long readUnitsPerSecond) {
            this.readUnitsPerSecond = readUnitsPerSecond;
        }

        @Override
        public final Builder readUnitsPerSecond(Long readUnitsPerSecond) {
            this.readUnitsPerSecond = readUnitsPerSecond;
            return this;
        }

        public final Long getWriteUnitsPerSecond() {
            return writeUnitsPerSecond;
        }

        public final void setWriteUnitsPerSecond(Long writeUnitsPerSecond) {
            this.writeUnitsPerSecond = writeUnitsPerSecond;
        }

        @Override
        public final Builder writeUnitsPerSecond(Long writeUnitsPerSecond) {
            this.writeUnitsPerSecond = writeUnitsPerSecond;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TableStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public TableWarmThroughputDescription build() {
            return new TableWarmThroughputDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
