/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchWriteItemRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, BatchWriteItemRequest> {
    private static final SdkField<Map<String, List<WriteRequest>>> REQUEST_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RequestItems").getter(BatchWriteItemRequest.getter(BatchWriteItemRequest::requestItems)).setter(BatchWriteItemRequest.setter(Builder::requestItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WriteRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnConsumedCapacity").getter(BatchWriteItemRequest.getter(BatchWriteItemRequest::returnConsumedCapacityAsString)).setter(BatchWriteItemRequest.setter(Builder::returnConsumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build()}).build();
    private static final SdkField<String> RETURN_ITEM_COLLECTION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnItemCollectionMetrics").getter(BatchWriteItemRequest.getter(BatchWriteItemRequest::returnItemCollectionMetricsAsString)).setter(BatchWriteItemRequest.setter(Builder::returnItemCollectionMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnItemCollectionMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ITEMS_FIELD, RETURN_CONSUMED_CAPACITY_FIELD, RETURN_ITEM_COLLECTION_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RequestItems", REQUEST_ITEMS_FIELD);
            this.put("ReturnConsumedCapacity", RETURN_CONSUMED_CAPACITY_FIELD);
            this.put("ReturnItemCollectionMetrics", RETURN_ITEM_COLLECTION_METRICS_FIELD);
        }
    });
    private final Map<String, List<WriteRequest>> requestItems;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;

    private BatchWriteItemRequest(BuilderImpl builder) {
        super(builder);
        this.requestItems = builder.requestItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
    }

    public final boolean hasRequestItems() {
        return this.requestItems != null && !(this.requestItems instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<WriteRequest>> requestItems() {
        return this.requestItems;
    }

    public final ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public final String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public final ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue(this.returnItemCollectionMetrics);
    }

    public final String returnItemCollectionMetricsAsString() {
        return this.returnItemCollectionMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestItems() ? this.requestItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnItemCollectionMetricsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemRequest)) {
            return false;
        }
        BatchWriteItemRequest other = (BatchWriteItemRequest)((Object)obj);
        return this.hasRequestItems() == other.hasRequestItems() && Objects.equals(this.requestItems(), other.requestItems()) && Objects.equals(this.returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString()) && Objects.equals(this.returnItemCollectionMetricsAsString(), other.returnItemCollectionMetricsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchWriteItemRequest").add("RequestItems", this.hasRequestItems() ? this.requestItems() : null).add("ReturnConsumedCapacity", (Object)this.returnConsumedCapacityAsString()).add("ReturnItemCollectionMetrics", (Object)this.returnItemCollectionMetricsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestItems": {
                return Optional.ofNullable(clazz.cast(this.requestItems()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.returnConsumedCapacityAsString()));
            }
            case "ReturnItemCollectionMetrics": {
                return Optional.ofNullable(clazz.cast(this.returnItemCollectionMetricsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteItemRequest, T> g) {
        return obj -> g.apply((BatchWriteItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private Map<String, List<WriteRequest>> requestItems = DefaultSdkAutoConstructMap.getInstance();
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemRequest model) {
            super(model);
            this.requestItems(model.requestItems);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.returnItemCollectionMetrics(model.returnItemCollectionMetrics);
        }

        public final Map<String, List<WriteRequest.Builder>> getRequestItems() {
            Map<String, List<WriteRequest.Builder>> result = BatchWriteItemRequestMapCopier.copyToBuilder(this.requestItems);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRequestItems(Map<String, ? extends Collection<WriteRequest.BuilderImpl>> requestItems) {
            this.requestItems = BatchWriteItemRequestMapCopier.copyFromBuilder(requestItems);
        }

        @Override
        public final Builder requestItems(Map<String, ? extends Collection<WriteRequest>> requestItems) {
            this.requestItems = BatchWriteItemRequestMapCopier.copy(requestItems);
            return this;
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final String getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics == null ? null : returnItemCollectionMetrics.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchWriteItemRequest build() {
            return new BatchWriteItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchWriteItemRequest> {
        public Builder requestItems(Map<String, ? extends Collection<WriteRequest>> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder returnItemCollectionMetrics(String var1);

        public Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

