/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * A new global secondary index to be added to an existing table.
 * </p>
 * </li>
 * <li>
 * <p>
 * New provisioned throughput parameters for an existing global secondary index.
 * </p>
 * </li>
 * <li>
 * <p>
 * An existing global secondary index to be removed from an existing table.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalSecondaryIndexUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalSecondaryIndexUpdate.Builder, GlobalSecondaryIndexUpdate> {
    private static final SdkField<UpdateGlobalSecondaryIndexAction> UPDATE_FIELD = SdkField
            .<UpdateGlobalSecondaryIndexAction> builder(MarshallingType.SDK_POJO)
            .getter(getter(GlobalSecondaryIndexUpdate::update)).setter(setter(Builder::update))
            .constructor(UpdateGlobalSecondaryIndexAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Update").build()).build();

    private static final SdkField<CreateGlobalSecondaryIndexAction> CREATE_FIELD = SdkField
            .<CreateGlobalSecondaryIndexAction> builder(MarshallingType.SDK_POJO)
            .getter(getter(GlobalSecondaryIndexUpdate::create)).setter(setter(Builder::create))
            .constructor(CreateGlobalSecondaryIndexAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Create").build()).build();

    private static final SdkField<DeleteGlobalSecondaryIndexAction> DELETE_FIELD = SdkField
            .<DeleteGlobalSecondaryIndexAction> builder(MarshallingType.SDK_POJO)
            .getter(getter(GlobalSecondaryIndexUpdate::delete)).setter(setter(Builder::delete))
            .constructor(DeleteGlobalSecondaryIndexAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_FIELD, CREATE_FIELD,
            DELETE_FIELD));

    private static final long serialVersionUID = 1L;

    private final UpdateGlobalSecondaryIndexAction update;

    private final CreateGlobalSecondaryIndexAction create;

    private final DeleteGlobalSecondaryIndexAction delete;

    private GlobalSecondaryIndexUpdate(BuilderImpl builder) {
        this.update = builder.update;
        this.create = builder.create;
        this.delete = builder.delete;
    }

    /**
     * <p>
     * The name of an existing global secondary index, along with new provisioned throughput settings to be applied to
     * that index.
     * </p>
     * 
     * @return The name of an existing global secondary index, along with new provisioned throughput settings to be
     *         applied to that index.
     */
    public UpdateGlobalSecondaryIndexAction update() {
        return update;
    }

    /**
     * <p>
     * The parameters required for creating a global secondary index on an existing table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IndexName </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KeySchema </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AttributeDefinitions </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Projection </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProvisionedThroughput </code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The parameters required for creating a global secondary index on an existing table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IndexName </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KeySchema </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AttributeDefinitions </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Projection </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProvisionedThroughput </code>
     *         </p>
     *         </li>
     */
    public CreateGlobalSecondaryIndexAction create() {
        return create;
    }

    /**
     * <p>
     * The name of an existing global secondary index to be removed.
     * </p>
     * 
     * @return The name of an existing global secondary index to be removed.
     */
    public DeleteGlobalSecondaryIndexAction delete() {
        return delete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(update());
        hashCode = 31 * hashCode + Objects.hashCode(create());
        hashCode = 31 * hashCode + Objects.hashCode(delete());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndexUpdate)) {
            return false;
        }
        GlobalSecondaryIndexUpdate other = (GlobalSecondaryIndexUpdate) obj;
        return Objects.equals(update(), other.update()) && Objects.equals(create(), other.create())
                && Objects.equals(delete(), other.delete());
    }

    @Override
    public String toString() {
        return ToString.builder("GlobalSecondaryIndexUpdate").add("Update", update()).add("Create", create())
                .add("Delete", delete()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Update":
            return Optional.ofNullable(clazz.cast(update()));
        case "Create":
            return Optional.ofNullable(clazz.cast(create()));
        case "Delete":
            return Optional.ofNullable(clazz.cast(delete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalSecondaryIndexUpdate, T> g) {
        return obj -> g.apply((GlobalSecondaryIndexUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalSecondaryIndexUpdate> {
        /**
         * <p>
         * The name of an existing global secondary index, along with new provisioned throughput settings to be applied
         * to that index.
         * </p>
         * 
         * @param update
         *        The name of an existing global secondary index, along with new provisioned throughput settings to be
         *        applied to that index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder update(UpdateGlobalSecondaryIndexAction update);

        /**
         * <p>
         * The name of an existing global secondary index, along with new provisioned throughput settings to be applied
         * to that index.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateGlobalSecondaryIndexAction.Builder}
         * avoiding the need to create one manually via {@link UpdateGlobalSecondaryIndexAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateGlobalSecondaryIndexAction.Builder#build()} is called
         * immediately and its result is passed to {@link #update(UpdateGlobalSecondaryIndexAction)}.
         * 
         * @param update
         *        a consumer that will call methods on {@link UpdateGlobalSecondaryIndexAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #update(UpdateGlobalSecondaryIndexAction)
         */
        default Builder update(Consumer<UpdateGlobalSecondaryIndexAction.Builder> update) {
            return update(UpdateGlobalSecondaryIndexAction.builder().applyMutation(update).build());
        }

        /**
         * <p>
         * The parameters required for creating a global secondary index on an existing table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeySchema </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AttributeDefinitions </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput </code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param create
         *        The parameters required for creating a global secondary index on an existing table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeySchema </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AttributeDefinitions </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProvisionedThroughput </code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder create(CreateGlobalSecondaryIndexAction create);

        /**
         * <p>
         * The parameters required for creating a global secondary index on an existing table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeySchema </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AttributeDefinitions </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput </code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link CreateGlobalSecondaryIndexAction.Builder}
         * avoiding the need to create one manually via {@link CreateGlobalSecondaryIndexAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateGlobalSecondaryIndexAction.Builder#build()} is called
         * immediately and its result is passed to {@link #create(CreateGlobalSecondaryIndexAction)}.
         * 
         * @param create
         *        a consumer that will call methods on {@link CreateGlobalSecondaryIndexAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #create(CreateGlobalSecondaryIndexAction)
         */
        default Builder create(Consumer<CreateGlobalSecondaryIndexAction.Builder> create) {
            return create(CreateGlobalSecondaryIndexAction.builder().applyMutation(create).build());
        }

        /**
         * <p>
         * The name of an existing global secondary index to be removed.
         * </p>
         * 
         * @param delete
         *        The name of an existing global secondary index to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delete(DeleteGlobalSecondaryIndexAction delete);

        /**
         * <p>
         * The name of an existing global secondary index to be removed.
         * </p>
         * This is a convenience that creates an instance of the {@link DeleteGlobalSecondaryIndexAction.Builder}
         * avoiding the need to create one manually via {@link DeleteGlobalSecondaryIndexAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteGlobalSecondaryIndexAction.Builder#build()} is called
         * immediately and its result is passed to {@link #delete(DeleteGlobalSecondaryIndexAction)}.
         * 
         * @param delete
         *        a consumer that will call methods on {@link DeleteGlobalSecondaryIndexAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delete(DeleteGlobalSecondaryIndexAction)
         */
        default Builder delete(Consumer<DeleteGlobalSecondaryIndexAction.Builder> delete) {
            return delete(DeleteGlobalSecondaryIndexAction.builder().applyMutation(delete).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateGlobalSecondaryIndexAction update;

        private CreateGlobalSecondaryIndexAction create;

        private DeleteGlobalSecondaryIndexAction delete;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalSecondaryIndexUpdate model) {
            update(model.update);
            create(model.create);
            delete(model.delete);
        }

        public final UpdateGlobalSecondaryIndexAction.Builder getUpdate() {
            return update != null ? update.toBuilder() : null;
        }

        @Override
        public final Builder update(UpdateGlobalSecondaryIndexAction update) {
            this.update = update;
            return this;
        }

        public final void setUpdate(UpdateGlobalSecondaryIndexAction.BuilderImpl update) {
            this.update = update != null ? update.build() : null;
        }

        public final CreateGlobalSecondaryIndexAction.Builder getCreate() {
            return create != null ? create.toBuilder() : null;
        }

        @Override
        public final Builder create(CreateGlobalSecondaryIndexAction create) {
            this.create = create;
            return this;
        }

        public final void setCreate(CreateGlobalSecondaryIndexAction.BuilderImpl create) {
            this.create = create != null ? create.build() : null;
        }

        public final DeleteGlobalSecondaryIndexAction.Builder getDelete() {
            return delete != null ? delete.toBuilder() : null;
        }

        @Override
        public final Builder delete(DeleteGlobalSecondaryIndexAction delete) {
            this.delete = delete;
            return this;
        }

        public final void setDelete(DeleteGlobalSecondaryIndexAction.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        @Override
        public GlobalSecondaryIndexUpdate build() {
            return new GlobalSecondaryIndexUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
