/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of requests that can perform update, put, delete, or check operations on multiple items in one or more tables
 * atomically.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactWriteItem implements SdkPojo, Serializable,
        ToCopyableBuilder<TransactWriteItem.Builder, TransactWriteItem> {
    private static final SdkField<ConditionCheck> CONDITION_CHECK_FIELD = SdkField
            .<ConditionCheck> builder(MarshallingType.SDK_POJO).getter(getter(TransactWriteItem::conditionCheck))
            .setter(setter(Builder::conditionCheck)).constructor(ConditionCheck::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionCheck").build()).build();

    private static final SdkField<Put> PUT_FIELD = SdkField.<Put> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransactWriteItem::put)).setter(setter(Builder::put)).constructor(Put::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Put").build()).build();

    private static final SdkField<Delete> DELETE_FIELD = SdkField.<Delete> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransactWriteItem::delete)).setter(setter(Builder::delete)).constructor(Delete::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delete").build()).build();

    private static final SdkField<Update> UPDATE_FIELD = SdkField.<Update> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransactWriteItem::update)).setter(setter(Builder::update)).constructor(Update::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Update").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_CHECK_FIELD,
            PUT_FIELD, DELETE_FIELD, UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ConditionCheck conditionCheck;

    private final Put put;

    private final Delete delete;

    private final Update update;

    private TransactWriteItem(BuilderImpl builder) {
        this.conditionCheck = builder.conditionCheck;
        this.put = builder.put;
        this.delete = builder.delete;
        this.update = builder.update;
    }

    /**
     * <p>
     * A request to perform a check item operation.
     * </p>
     * 
     * @return A request to perform a check item operation.
     */
    public ConditionCheck conditionCheck() {
        return conditionCheck;
    }

    /**
     * <p>
     * A request to perform a <code>PutItem</code> operation.
     * </p>
     * 
     * @return A request to perform a <code>PutItem</code> operation.
     */
    public Put put() {
        return put;
    }

    /**
     * <p>
     * A request to perform a <code>DeleteItem</code> operation.
     * </p>
     * 
     * @return A request to perform a <code>DeleteItem</code> operation.
     */
    public Delete delete() {
        return delete;
    }

    /**
     * <p>
     * A request to perform an <code>UpdateItem</code> operation.
     * </p>
     * 
     * @return A request to perform an <code>UpdateItem</code> operation.
     */
    public Update update() {
        return update;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conditionCheck());
        hashCode = 31 * hashCode + Objects.hashCode(put());
        hashCode = 31 * hashCode + Objects.hashCode(delete());
        hashCode = 31 * hashCode + Objects.hashCode(update());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactWriteItem)) {
            return false;
        }
        TransactWriteItem other = (TransactWriteItem) obj;
        return Objects.equals(conditionCheck(), other.conditionCheck()) && Objects.equals(put(), other.put())
                && Objects.equals(delete(), other.delete()) && Objects.equals(update(), other.update());
    }

    @Override
    public String toString() {
        return ToString.builder("TransactWriteItem").add("ConditionCheck", conditionCheck()).add("Put", put())
                .add("Delete", delete()).add("Update", update()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConditionCheck":
            return Optional.ofNullable(clazz.cast(conditionCheck()));
        case "Put":
            return Optional.ofNullable(clazz.cast(put()));
        case "Delete":
            return Optional.ofNullable(clazz.cast(delete()));
        case "Update":
            return Optional.ofNullable(clazz.cast(update()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactWriteItem, T> g) {
        return obj -> g.apply((TransactWriteItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransactWriteItem> {
        /**
         * <p>
         * A request to perform a check item operation.
         * </p>
         * 
         * @param conditionCheck
         *        A request to perform a check item operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionCheck(ConditionCheck conditionCheck);

        /**
         * <p>
         * A request to perform a check item operation.
         * </p>
         * This is a convenience that creates an instance of the {@link ConditionCheck.Builder} avoiding the need to
         * create one manually via {@link ConditionCheck#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConditionCheck.Builder#build()} is called immediately and its
         * result is passed to {@link #conditionCheck(ConditionCheck)}.
         * 
         * @param conditionCheck
         *        a consumer that will call methods on {@link ConditionCheck.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionCheck(ConditionCheck)
         */
        default Builder conditionCheck(Consumer<ConditionCheck.Builder> conditionCheck) {
            return conditionCheck(ConditionCheck.builder().applyMutation(conditionCheck).build());
        }

        /**
         * <p>
         * A request to perform a <code>PutItem</code> operation.
         * </p>
         * 
         * @param put
         *        A request to perform a <code>PutItem</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder put(Put put);

        /**
         * <p>
         * A request to perform a <code>PutItem</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link Put.Builder} avoiding the need to create one
         * manually via {@link Put#builder()}.
         *
         * When the {@link Consumer} completes, {@link Put.Builder#build()} is called immediately and its result is
         * passed to {@link #put(Put)}.
         * 
         * @param put
         *        a consumer that will call methods on {@link Put.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #put(Put)
         */
        default Builder put(Consumer<Put.Builder> put) {
            return put(Put.builder().applyMutation(put).build());
        }

        /**
         * <p>
         * A request to perform a <code>DeleteItem</code> operation.
         * </p>
         * 
         * @param delete
         *        A request to perform a <code>DeleteItem</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delete(Delete delete);

        /**
         * <p>
         * A request to perform a <code>DeleteItem</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link Delete.Builder} avoiding the need to create one
         * manually via {@link Delete#builder()}.
         *
         * When the {@link Consumer} completes, {@link Delete.Builder#build()} is called immediately and its result is
         * passed to {@link #delete(Delete)}.
         * 
         * @param delete
         *        a consumer that will call methods on {@link Delete.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delete(Delete)
         */
        default Builder delete(Consumer<Delete.Builder> delete) {
            return delete(Delete.builder().applyMutation(delete).build());
        }

        /**
         * <p>
         * A request to perform an <code>UpdateItem</code> operation.
         * </p>
         * 
         * @param update
         *        A request to perform an <code>UpdateItem</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder update(Update update);

        /**
         * <p>
         * A request to perform an <code>UpdateItem</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link Update.Builder} avoiding the need to create one
         * manually via {@link Update#builder()}.
         *
         * When the {@link Consumer} completes, {@link Update.Builder#build()} is called immediately and its result is
         * passed to {@link #update(Update)}.
         * 
         * @param update
         *        a consumer that will call methods on {@link Update.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #update(Update)
         */
        default Builder update(Consumer<Update.Builder> update) {
            return update(Update.builder().applyMutation(update).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConditionCheck conditionCheck;

        private Put put;

        private Delete delete;

        private Update update;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactWriteItem model) {
            conditionCheck(model.conditionCheck);
            put(model.put);
            delete(model.delete);
            update(model.update);
        }

        public final ConditionCheck.Builder getConditionCheck() {
            return conditionCheck != null ? conditionCheck.toBuilder() : null;
        }

        @Override
        public final Builder conditionCheck(ConditionCheck conditionCheck) {
            this.conditionCheck = conditionCheck;
            return this;
        }

        public final void setConditionCheck(ConditionCheck.BuilderImpl conditionCheck) {
            this.conditionCheck = conditionCheck != null ? conditionCheck.build() : null;
        }

        public final Put.Builder getPut() {
            return put != null ? put.toBuilder() : null;
        }

        @Override
        public final Builder put(Put put) {
            this.put = put;
            return this;
        }

        public final void setPut(Put.BuilderImpl put) {
            this.put = put != null ? put.build() : null;
        }

        public final Delete.Builder getDelete() {
            return delete != null ? delete.toBuilder() : null;
        }

        @Override
        public final Builder delete(Delete delete) {
            this.delete = delete;
            return this;
        }

        public final void setDelete(Delete.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        public final Update.Builder getUpdate() {
            return update != null ? update.toBuilder() : null;
        }

        @Override
        public final Builder update(Update update) {
            this.update = update;
            return this;
        }

        public final void setUpdate(Update.BuilderImpl update) {
            this.update = update != null ? update.build() : null;
        }

        @Override
        public TransactWriteItem build() {
            return new TransactWriteItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
