/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchGetItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetItemResponse extends DynamoDbResponse implements
        ToCopyableBuilder<BatchGetItemResponse.Builder, BatchGetItemResponse> {
    private static final SdkField<Map<String, List<Map<String, AttributeValue>>>> RESPONSES_FIELD = SdkField
            .<Map<String, List<Map<String, AttributeValue>>>> builder(MarshallingType.MAP)
            .memberName("Responses")
            .getter(getter(BatchGetItemResponse::responses))
            .setter(setter(Builder::responses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Responses").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<Map<String, AttributeValue>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Map<String, AttributeValue>> builder(
                                                                            MarshallingType.MAP)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    MapTrait.builder()
                                                                                            .keyLocationName("key")
                                                                                            .valueLocationName("value")
                                                                                            .valueFieldInfo(
                                                                                                    SdkField.<AttributeValue> builder(
                                                                                                            MarshallingType.SDK_POJO)
                                                                                                            .constructor(
                                                                                                                    AttributeValue::builder)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "value")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<Map<String, KeysAndAttributes>> UNPROCESSED_KEYS_FIELD = SdkField
            .<Map<String, KeysAndAttributes>> builder(MarshallingType.MAP)
            .memberName("UnprocessedKeys")
            .getter(getter(BatchGetItemResponse::unprocessedKeys))
            .setter(setter(Builder::unprocessedKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedKeys").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<KeysAndAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeysAndAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ConsumedCapacity>> CONSUMED_CAPACITY_FIELD = SdkField
            .<List<ConsumedCapacity>> builder(MarshallingType.LIST)
            .memberName("ConsumedCapacity")
            .getter(getter(BatchGetItemResponse::consumedCapacity))
            .setter(setter(Builder::consumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConsumedCapacity> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConsumedCapacity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSES_FIELD,
            UNPROCESSED_KEYS_FIELD, CONSUMED_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, List<Map<String, AttributeValue>>> responses;

    private final Map<String, KeysAndAttributes> unprocessedKeys;

    private final List<ConsumedCapacity> consumedCapacity;

    private BatchGetItemResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
        this.unprocessedKeys = builder.unprocessedKeys;
        this.consumedCapacity = builder.consumedCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Responses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResponses() {
        return responses != null && !(responses instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of table name or table ARN to a list of items. Each object in <code>Responses</code> consists of a table
     * name or ARN, along with a map of attribute data consisting of the data type and attribute value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponses} method.
     * </p>
     * 
     * @return A map of table name or table ARN to a list of items. Each object in <code>Responses</code> consists of a
     *         table name or ARN, along with a map of attribute data consisting of the data type and attribute value.
     */
    public final Map<String, List<Map<String, AttributeValue>>> responses() {
        return responses;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedKeys() {
        return unprocessedKeys != null && !(unprocessedKeys instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of tables and their respective keys that were not processed with the current response. The
     * <code>UnprocessedKeys</code> value is in the same form as <code>RequestItems</code>, so the value can be provided
     * directly to a subsequent <code>BatchGetItem</code> operation. For more information, see <code>RequestItems</code>
     * in the Request Parameters section.
     * </p>
     * <p>
     * Each element consists of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Keys</code> - An array of primary key attribute values that define specific items in the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProjectionExpression</code> - One or more attributes to be retrieved from the table or index. By default,
     * all attributes are returned. If a requested attribute is not found, it does not appear in the result.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConsistentRead</code> - The consistency of a read operation. If set to <code>true</code>, then a strongly
     * consistent read is used; otherwise, an eventually consistent read is used.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If there are no unprocessed keys remaining, the response contains an empty <code>UnprocessedKeys</code> map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedKeys} method.
     * </p>
     * 
     * @return A map of tables and their respective keys that were not processed with the current response. The
     *         <code>UnprocessedKeys</code> value is in the same form as <code>RequestItems</code>, so the value can be
     *         provided directly to a subsequent <code>BatchGetItem</code> operation. For more information, see
     *         <code>RequestItems</code> in the Request Parameters section.</p>
     *         <p>
     *         Each element consists of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Keys</code> - An array of primary key attribute values that define specific items in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProjectionExpression</code> - One or more attributes to be retrieved from the table or index. By
     *         default, all attributes are returned. If a requested attribute is not found, it does not appear in the
     *         result.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConsistentRead</code> - The consistency of a read operation. If set to <code>true</code>, then a
     *         strongly consistent read is used; otherwise, an eventually consistent read is used.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If there are no unprocessed keys remaining, the response contains an empty <code>UnprocessedKeys</code>
     *         map.
     */
    public final Map<String, KeysAndAttributes> unprocessedKeys() {
        return unprocessedKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConsumedCapacity property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConsumedCapacity() {
        return consumedCapacity != null && !(consumedCapacity instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The read capacity units consumed by the entire <code>BatchGetItem</code> operation.
     * </p>
     * <p>
     * Each element consists of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TableName</code> - The table that consumed the provisioned throughput.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CapacityUnits</code> - The total number of capacity units consumed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConsumedCapacity} method.
     * </p>
     * 
     * @return The read capacity units consumed by the entire <code>BatchGetItem</code> operation.</p>
     *         <p>
     *         Each element consists of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TableName</code> - The table that consumed the provisioned throughput.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CapacityUnits</code> - The total number of capacity units consumed.
     *         </p>
     *         </li>
     */
    public final List<ConsumedCapacity> consumedCapacity() {
        return consumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResponses() ? responses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedKeys() ? unprocessedKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConsumedCapacity() ? consumedCapacity() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemResponse)) {
            return false;
        }
        BatchGetItemResponse other = (BatchGetItemResponse) obj;
        return hasResponses() == other.hasResponses() && Objects.equals(responses(), other.responses())
                && hasUnprocessedKeys() == other.hasUnprocessedKeys()
                && Objects.equals(unprocessedKeys(), other.unprocessedKeys())
                && hasConsumedCapacity() == other.hasConsumedCapacity()
                && Objects.equals(consumedCapacity(), other.consumedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetItemResponse").add("Responses", hasResponses() ? responses() : null)
                .add("UnprocessedKeys", hasUnprocessedKeys() ? unprocessedKeys() : null)
                .add("ConsumedCapacity", hasConsumedCapacity() ? consumedCapacity() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Responses":
            return Optional.ofNullable(clazz.cast(responses()));
        case "UnprocessedKeys":
            return Optional.ofNullable(clazz.cast(unprocessedKeys()));
        case "ConsumedCapacity":
            return Optional.ofNullable(clazz.cast(consumedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Responses", RESPONSES_FIELD);
        map.put("UnprocessedKeys", UNPROCESSED_KEYS_FIELD);
        map.put("ConsumedCapacity", CONSUMED_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetItemResponse, T> g) {
        return obj -> g.apply((BatchGetItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetItemResponse> {
        /**
         * <p>
         * A map of table name or table ARN to a list of items. Each object in <code>Responses</code> consists of a
         * table name or ARN, along with a map of attribute data consisting of the data type and attribute value.
         * </p>
         * 
         * @param responses
         *        A map of table name or table ARN to a list of items. Each object in <code>Responses</code> consists of
         *        a table name or ARN, along with a map of attribute data consisting of the data type and attribute
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(Map<String, ? extends Collection<? extends Map<String, AttributeValue>>> responses);

        /**
         * <p>
         * A map of tables and their respective keys that were not processed with the current response. The
         * <code>UnprocessedKeys</code> value is in the same form as <code>RequestItems</code>, so the value can be
         * provided directly to a subsequent <code>BatchGetItem</code> operation. For more information, see
         * <code>RequestItems</code> in the Request Parameters section.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Keys</code> - An array of primary key attribute values that define specific items in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProjectionExpression</code> - One or more attributes to be retrieved from the table or index. By
         * default, all attributes are returned. If a requested attribute is not found, it does not appear in the
         * result.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConsistentRead</code> - The consistency of a read operation. If set to <code>true</code>, then a
         * strongly consistent read is used; otherwise, an eventually consistent read is used.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If there are no unprocessed keys remaining, the response contains an empty <code>UnprocessedKeys</code> map.
         * </p>
         * 
         * @param unprocessedKeys
         *        A map of tables and their respective keys that were not processed with the current response. The
         *        <code>UnprocessedKeys</code> value is in the same form as <code>RequestItems</code>, so the value can
         *        be provided directly to a subsequent <code>BatchGetItem</code> operation. For more information, see
         *        <code>RequestItems</code> in the Request Parameters section.</p>
         *        <p>
         *        Each element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Keys</code> - An array of primary key attribute values that define specific items in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProjectionExpression</code> - One or more attributes to be retrieved from the table or index. By
         *        default, all attributes are returned. If a requested attribute is not found, it does not appear in the
         *        result.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConsistentRead</code> - The consistency of a read operation. If set to <code>true</code>, then a
         *        strongly consistent read is used; otherwise, an eventually consistent read is used.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If there are no unprocessed keys remaining, the response contains an empty
         *        <code>UnprocessedKeys</code> map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys);

        /**
         * <p>
         * The read capacity units consumed by the entire <code>BatchGetItem</code> operation.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TableName</code> - The table that consumed the provisioned throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityUnits</code> - The total number of capacity units consumed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param consumedCapacity
         *        The read capacity units consumed by the entire <code>BatchGetItem</code> operation.</p>
         *        <p>
         *        Each element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TableName</code> - The table that consumed the provisioned throughput.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CapacityUnits</code> - The total number of capacity units consumed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity);

        /**
         * <p>
         * The read capacity units consumed by the entire <code>BatchGetItem</code> operation.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TableName</code> - The table that consumed the provisioned throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityUnits</code> - The total number of capacity units consumed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param consumedCapacity
         *        The read capacity units consumed by the entire <code>BatchGetItem</code> operation.</p>
         *        <p>
         *        Each element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TableName</code> - The table that consumed the provisioned throughput.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CapacityUnits</code> - The total number of capacity units consumed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity... consumedCapacity);

        /**
         * <p>
         * The read capacity units consumed by the entire <code>BatchGetItem</code> operation.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TableName</code> - The table that consumed the provisioned throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityUnits</code> - The total number of capacity units consumed.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity.Builder#build()} is called immediately
         * and its result is passed to {@link #consumedCapacity(List<ConsumedCapacity>)}.
         * 
         * @param consumedCapacity
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedCapacity(java.util.Collection<ConsumedCapacity>)
         */
        Builder consumedCapacity(Consumer<ConsumedCapacity.Builder>... consumedCapacity);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private Map<String, List<Map<String, AttributeValue>>> responses = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, KeysAndAttributes> unprocessedKeys = DefaultSdkAutoConstructMap.getInstance();

        private List<ConsumedCapacity> consumedCapacity = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetItemResponse model) {
            super(model);
            responses(model.responses);
            unprocessedKeys(model.unprocessedKeys);
            consumedCapacity(model.consumedCapacity);
        }

        public final Map<String, List<Map<String, AttributeValue.Builder>>> getResponses() {
            Map<String, List<Map<String, AttributeValue.Builder>>> result = BatchGetResponseMapCopier
                    .copyToBuilder(this.responses);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResponses(
                Map<String, ? extends Collection<? extends Map<String, AttributeValue.BuilderImpl>>> responses) {
            this.responses = BatchGetResponseMapCopier.copyFromBuilder(responses);
        }

        @Override
        public final Builder responses(Map<String, ? extends Collection<? extends Map<String, AttributeValue>>> responses) {
            this.responses = BatchGetResponseMapCopier.copy(responses);
            return this;
        }

        public final Map<String, KeysAndAttributes.Builder> getUnprocessedKeys() {
            Map<String, KeysAndAttributes.Builder> result = BatchGetRequestMapCopier.copyToBuilder(this.unprocessedKeys);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedKeys(Map<String, KeysAndAttributes.BuilderImpl> unprocessedKeys) {
            this.unprocessedKeys = BatchGetRequestMapCopier.copyFromBuilder(unprocessedKeys);
        }

        @Override
        public final Builder unprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
            this.unprocessedKeys = BatchGetRequestMapCopier.copy(unprocessedKeys);
            return this;
        }

        public final List<ConsumedCapacity.Builder> getConsumedCapacity() {
            List<ConsumedCapacity.Builder> result = ConsumedCapacityMultipleCopier.copyToBuilder(this.consumedCapacity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity... consumedCapacity) {
            consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder>... consumedCapacity) {
            consumedCapacity(Stream.of(consumedCapacity).map(c -> ConsumedCapacity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetItemResponse build() {
            return new BatchGetItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
