/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyRequest extends DynamoDbRequest implements
        ToCopyableBuilder<PutResourcePolicyRequest.Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(PutResourcePolicyRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(PutResourcePolicyRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<String> EXPECTED_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpectedRevisionId").getter(getter(PutResourcePolicyRequest::expectedRevisionId))
            .setter(setter(Builder::expectedRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedRevisionId").build())
            .build();

    private static final SdkField<Boolean> CONFIRM_REMOVE_SELF_RESOURCE_ACCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ConfirmRemoveSelfResourceAccess")
            .getter(getter(PutResourcePolicyRequest::confirmRemoveSelfResourceAccess))
            .setter(setter(Builder::confirmRemoveSelfResourceAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfirmRemoveSelfResourceAccess")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            POLICY_FIELD, EXPECTED_REVISION_ID_FIELD, CONFIRM_REMOVE_SELF_RESOURCE_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final String policy;

    private final String expectedRevisionId;

    private final Boolean confirmRemoveSelfResourceAccess;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.policy = builder.policy;
        this.expectedRevisionId = builder.expectedRevisionId;
        this.confirmRemoveSelfResourceAccess = builder.confirmRemoveSelfResourceAccess;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DynamoDB resource to which the policy will be attached. The resources you
     * can specify include tables and streams.
     * </p>
     * <p>
     * You can control index permissions using the base table's policy. To specify the same permission level for your
     * table and its indexes, you can provide both the table and index Amazon Resource Name (ARN)s in the
     * <code>Resource</code> field of a given <code>Statement</code> in your policy document. Alternatively, to specify
     * different permissions for your table, indexes, or both, you can define multiple <code>Statement</code> fields in
     * your policy document.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DynamoDB resource to which the policy will be attached. The
     *         resources you can specify include tables and streams.</p>
     *         <p>
     *         You can control index permissions using the base table's policy. To specify the same permission level for
     *         your table and its indexes, you can provide both the table and index Amazon Resource Name (ARN)s in the
     *         <code>Resource</code> field of a given <code>Statement</code> in your policy document. Alternatively, to
     *         specify different permissions for your table, indexes, or both, you can define multiple
     *         <code>Statement</code> fields in your policy document.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * An Amazon Web Services resource-based policy document in JSON format.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces when
     * calculating the size of a policy against this limit.
     * </p>
     * </li>
     * <li>
     * <p>
     * Within a resource-based policy, if the action for a DynamoDB service-linked role (SLR) to replicate data for a
     * global table is denied, adding or deleting a replica will fail with an error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a full list of all considerations that apply while attaching a resource-based policy, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html">Resource-based
     * policy considerations</a>.
     * </p>
     * 
     * @return An Amazon Web Services resource-based policy document in JSON format.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces
     *         when calculating the size of a policy against this limit.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Within a resource-based policy, if the action for a DynamoDB service-linked role (SLR) to replicate data
     *         for a global table is denied, adding or deleting a replica will fail with an error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For a full list of all considerations that apply while attaching a resource-based policy, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html"
     *         >Resource-based policy considerations</a>.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * A string value that you can use to conditionally update your policy. You can provide the revision ID of your
     * existing policy to make mutating requests against that policy.
     * </p>
     * <note>
     * <p>
     * When you provide an expected revision ID, if the revision ID of the existing policy on the resource doesn't match
     * or if there's no policy attached to the resource, your request will be rejected with a
     * <code>PolicyNotFoundException</code>.
     * </p>
     * </note>
     * <p>
     * To conditionally attach a policy when no policy exists for the resource, specify <code>NO_POLICY</code> for the
     * revision ID.
     * </p>
     * 
     * @return A string value that you can use to conditionally update your policy. You can provide the revision ID of
     *         your existing policy to make mutating requests against that policy.</p> <note>
     *         <p>
     *         When you provide an expected revision ID, if the revision ID of the existing policy on the resource
     *         doesn't match or if there's no policy attached to the resource, your request will be rejected with a
     *         <code>PolicyNotFoundException</code>.
     *         </p>
     *         </note>
     *         <p>
     *         To conditionally attach a policy when no policy exists for the resource, specify <code>NO_POLICY</code>
     *         for the revision ID.
     */
    public final String expectedRevisionId() {
        return expectedRevisionId;
    }

    /**
     * <p>
     * Set this parameter to <code>true</code> to confirm that you want to remove your permissions to change the policy
     * of this resource in the future.
     * </p>
     * 
     * @return Set this parameter to <code>true</code> to confirm that you want to remove your permissions to change the
     *         policy of this resource in the future.
     */
    public final Boolean confirmRemoveSelfResourceAccess() {
        return confirmRemoveSelfResourceAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(expectedRevisionId());
        hashCode = 31 * hashCode + Objects.hashCode(confirmRemoveSelfResourceAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(policy(), other.policy())
                && Objects.equals(expectedRevisionId(), other.expectedRevisionId())
                && Objects.equals(confirmRemoveSelfResourceAccess(), other.confirmRemoveSelfResourceAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResourcePolicyRequest").add("ResourceArn", resourceArn()).add("Policy", policy())
                .add("ExpectedRevisionId", expectedRevisionId())
                .add("ConfirmRemoveSelfResourceAccess", confirmRemoveSelfResourceAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "ExpectedRevisionId":
            return Optional.ofNullable(clazz.cast(expectedRevisionId()));
        case "ConfirmRemoveSelfResourceAccess":
            return Optional.ofNullable(clazz.cast(confirmRemoveSelfResourceAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Policy", POLICY_FIELD);
        map.put("ExpectedRevisionId", EXPECTED_REVISION_ID_FIELD);
        map.put("ConfirmRemoveSelfResourceAccess", CONFIRM_REMOVE_SELF_RESOURCE_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DynamoDB resource to which the policy will be attached. The resources
         * you can specify include tables and streams.
         * </p>
         * <p>
         * You can control index permissions using the base table's policy. To specify the same permission level for
         * your table and its indexes, you can provide both the table and index Amazon Resource Name (ARN)s in the
         * <code>Resource</code> field of a given <code>Statement</code> in your policy document. Alternatively, to
         * specify different permissions for your table, indexes, or both, you can define multiple
         * <code>Statement</code> fields in your policy document.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the DynamoDB resource to which the policy will be attached. The
         *        resources you can specify include tables and streams.</p>
         *        <p>
         *        You can control index permissions using the base table's policy. To specify the same permission level
         *        for your table and its indexes, you can provide both the table and index Amazon Resource Name (ARN)s
         *        in the <code>Resource</code> field of a given <code>Statement</code> in your policy document.
         *        Alternatively, to specify different permissions for your table, indexes, or both, you can define
         *        multiple <code>Statement</code> fields in your policy document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * An Amazon Web Services resource-based policy document in JSON format.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces when
         * calculating the size of a policy against this limit.
         * </p>
         * </li>
         * <li>
         * <p>
         * Within a resource-based policy, if the action for a DynamoDB service-linked role (SLR) to replicate data for
         * a global table is denied, adding or deleting a replica will fail with an error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For a full list of all considerations that apply while attaching a resource-based policy, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html"
         * >Resource-based policy considerations</a>.
         * </p>
         * 
         * @param policy
         *        An Amazon Web Services resource-based policy document in JSON format.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The maximum size supported for a resource-based policy document is 20 KB. DynamoDB counts whitespaces
         *        when calculating the size of a policy against this limit.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Within a resource-based policy, if the action for a DynamoDB service-linked role (SLR) to replicate
         *        data for a global table is denied, adding or deleting a replica will fail with an error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For a full list of all considerations that apply while attaching a resource-based policy, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html"
         *        >Resource-based policy considerations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * A string value that you can use to conditionally update your policy. You can provide the revision ID of your
         * existing policy to make mutating requests against that policy.
         * </p>
         * <note>
         * <p>
         * When you provide an expected revision ID, if the revision ID of the existing policy on the resource doesn't
         * match or if there's no policy attached to the resource, your request will be rejected with a
         * <code>PolicyNotFoundException</code>.
         * </p>
         * </note>
         * <p>
         * To conditionally attach a policy when no policy exists for the resource, specify <code>NO_POLICY</code> for
         * the revision ID.
         * </p>
         * 
         * @param expectedRevisionId
         *        A string value that you can use to conditionally update your policy. You can provide the revision ID
         *        of your existing policy to make mutating requests against that policy.</p> <note>
         *        <p>
         *        When you provide an expected revision ID, if the revision ID of the existing policy on the resource
         *        doesn't match or if there's no policy attached to the resource, your request will be rejected with a
         *        <code>PolicyNotFoundException</code>.
         *        </p>
         *        </note>
         *        <p>
         *        To conditionally attach a policy when no policy exists for the resource, specify
         *        <code>NO_POLICY</code> for the revision ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRevisionId(String expectedRevisionId);

        /**
         * <p>
         * Set this parameter to <code>true</code> to confirm that you want to remove your permissions to change the
         * policy of this resource in the future.
         * </p>
         * 
         * @param confirmRemoveSelfResourceAccess
         *        Set this parameter to <code>true</code> to confirm that you want to remove your permissions to change
         *        the policy of this resource in the future.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmRemoveSelfResourceAccess(Boolean confirmRemoveSelfResourceAccess);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String policy;

        private String expectedRevisionId;

        private Boolean confirmRemoveSelfResourceAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            policy(model.policy);
            expectedRevisionId(model.expectedRevisionId);
            confirmRemoveSelfResourceAccess(model.confirmRemoveSelfResourceAccess);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getExpectedRevisionId() {
            return expectedRevisionId;
        }

        public final void setExpectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
        }

        @Override
        public final Builder expectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
            return this;
        }

        public final Boolean getConfirmRemoveSelfResourceAccess() {
            return confirmRemoveSelfResourceAccess;
        }

        public final void setConfirmRemoveSelfResourceAccess(Boolean confirmRemoveSelfResourceAccess) {
            this.confirmRemoveSelfResourceAccess = confirmRemoveSelfResourceAccess;
        }

        @Override
        public final Builder confirmRemoveSelfResourceAccess(Boolean confirmRemoveSelfResourceAccess) {
            this.confirmRemoveSelfResourceAccess = confirmRemoveSelfResourceAccess;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
