/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a PartiQL statement that uses parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterizedStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterizedStatement.Builder, ParameterizedStatement> {
    private static final SdkField<String> STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Statement").getter(getter(ParameterizedStatement::statement)).setter(setter(Builder::statement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statement").build()).build();

    private static final SdkField<List<AttributeValue>> PARAMETERS_FIELD = SdkField
            .<List<AttributeValue>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(ParameterizedStatement::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReturnValuesOnConditionCheckFailure")
            .getter(getter(ParameterizedStatement::returnValuesOnConditionCheckFailureAsString))
            .setter(setter(Builder::returnValuesOnConditionCheckFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReturnValuesOnConditionCheckFailure").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_FIELD,
            PARAMETERS_FIELD, RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String statement;

    private final List<AttributeValue> parameters;

    private final String returnValuesOnConditionCheckFailure;

    private ParameterizedStatement(BuilderImpl builder) {
        this.statement = builder.statement;
        this.parameters = builder.parameters;
        this.returnValuesOnConditionCheckFailure = builder.returnValuesOnConditionCheckFailure;
    }

    /**
     * <p>
     * A PartiQL statement that uses parameters.
     * </p>
     * 
     * @return A PartiQL statement that uses parameters.
     */
    public final String statement() {
        return statement;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameter values.
     */
    public final List<AttributeValue> parameters() {
        return parameters;
    }

    /**
     * <p>
     * An optional parameter that returns the item attributes for a PartiQL <code>ParameterizedStatement</code>
     * operation that failed a condition check.
     * </p>
     * <p>
     * There is no additional cost associated with requesting a return value aside from the small network and processing
     * overhead of receiving a larger response. No read capacity units are consumed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnValuesOnConditionCheckFailure} will return
     * {@link ReturnValuesOnConditionCheckFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #returnValuesOnConditionCheckFailureAsString}.
     * </p>
     * 
     * @return An optional parameter that returns the item attributes for a PartiQL <code>ParameterizedStatement</code>
     *         operation that failed a condition check.</p>
     *         <p>
     *         There is no additional cost associated with requesting a return value aside from the small network and
     *         processing overhead of receiving a larger response. No read capacity units are consumed.
     * @see ReturnValuesOnConditionCheckFailure
     */
    public final ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure() {
        return ReturnValuesOnConditionCheckFailure.fromValue(returnValuesOnConditionCheckFailure);
    }

    /**
     * <p>
     * An optional parameter that returns the item attributes for a PartiQL <code>ParameterizedStatement</code>
     * operation that failed a condition check.
     * </p>
     * <p>
     * There is no additional cost associated with requesting a return value aside from the small network and processing
     * overhead of receiving a larger response. No read capacity units are consumed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnValuesOnConditionCheckFailure} will return
     * {@link ReturnValuesOnConditionCheckFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #returnValuesOnConditionCheckFailureAsString}.
     * </p>
     * 
     * @return An optional parameter that returns the item attributes for a PartiQL <code>ParameterizedStatement</code>
     *         operation that failed a condition check.</p>
     *         <p>
     *         There is no additional cost associated with requesting a return value aside from the small network and
     *         processing overhead of receiving a larger response. No read capacity units are consumed.
     * @see ReturnValuesOnConditionCheckFailure
     */
    public final String returnValuesOnConditionCheckFailureAsString() {
        return returnValuesOnConditionCheckFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statement());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(returnValuesOnConditionCheckFailureAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterizedStatement)) {
            return false;
        }
        ParameterizedStatement other = (ParameterizedStatement) obj;
        return Objects.equals(statement(), other.statement())
                && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(returnValuesOnConditionCheckFailureAsString(),
                        other.returnValuesOnConditionCheckFailureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterizedStatement").add("Statement", statement())
                .add("Parameters", hasParameters() ? parameters() : null)
                .add("ReturnValuesOnConditionCheckFailure", returnValuesOnConditionCheckFailureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statement":
            return Optional.ofNullable(clazz.cast(statement()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ReturnValuesOnConditionCheckFailure":
            return Optional.ofNullable(clazz.cast(returnValuesOnConditionCheckFailureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Statement", STATEMENT_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("ReturnValuesOnConditionCheckFailure", RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterizedStatement, T> g) {
        return obj -> g.apply((ParameterizedStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterizedStatement> {
        /**
         * <p>
         * A PartiQL statement that uses parameters.
         * </p>
         * 
         * @param statement
         *        A PartiQL statement that uses parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statement(String statement);

        /**
         * <p>
         * The parameter values.
         * </p>
         * 
         * @param parameters
         *        The parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<AttributeValue> parameters);

        /**
         * <p>
         * The parameter values.
         * </p>
         * 
         * @param parameters
         *        The parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(AttributeValue... parameters);

        /**
         * <p>
         * The parameter values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.AttributeValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.dynamodb.model.AttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.AttributeValue.Builder#build()} is called immediately
         * and its result is passed to {@link #parameters(List<AttributeValue>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<AttributeValue>)
         */
        Builder parameters(Consumer<AttributeValue.Builder>... parameters);

        /**
         * <p>
         * An optional parameter that returns the item attributes for a PartiQL <code>ParameterizedStatement</code>
         * operation that failed a condition check.
         * </p>
         * <p>
         * There is no additional cost associated with requesting a return value aside from the small network and
         * processing overhead of receiving a larger response. No read capacity units are consumed.
         * </p>
         * 
         * @param returnValuesOnConditionCheckFailure
         *        An optional parameter that returns the item attributes for a PartiQL
         *        <code>ParameterizedStatement</code> operation that failed a condition check.</p>
         *        <p>
         *        There is no additional cost associated with requesting a return value aside from the small network and
         *        processing overhead of receiving a larger response. No read capacity units are consumed.
         * @see ReturnValuesOnConditionCheckFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValuesOnConditionCheckFailure
         */
        Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure);

        /**
         * <p>
         * An optional parameter that returns the item attributes for a PartiQL <code>ParameterizedStatement</code>
         * operation that failed a condition check.
         * </p>
         * <p>
         * There is no additional cost associated with requesting a return value aside from the small network and
         * processing overhead of receiving a larger response. No read capacity units are consumed.
         * </p>
         * 
         * @param returnValuesOnConditionCheckFailure
         *        An optional parameter that returns the item attributes for a PartiQL
         *        <code>ParameterizedStatement</code> operation that failed a condition check.</p>
         *        <p>
         *        There is no additional cost associated with requesting a return value aside from the small network and
         *        processing overhead of receiving a larger response. No read capacity units are consumed.
         * @see ReturnValuesOnConditionCheckFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValuesOnConditionCheckFailure
         */
        Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure);
    }

    static final class BuilderImpl implements Builder {
        private String statement;

        private List<AttributeValue> parameters = DefaultSdkAutoConstructList.getInstance();

        private String returnValuesOnConditionCheckFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterizedStatement model) {
            statement(model.statement);
            parameters(model.parameters);
            returnValuesOnConditionCheckFailure(model.returnValuesOnConditionCheckFailure);
        }

        public final String getStatement() {
            return statement;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        @Override
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        public final List<AttributeValue.Builder> getParameters() {
            List<AttributeValue.Builder> result = PreparedStatementParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<AttributeValue.BuilderImpl> parameters) {
            this.parameters = PreparedStatementParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<AttributeValue> parameters) {
            this.parameters = PreparedStatementParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(AttributeValue... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<AttributeValue.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> AttributeValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReturnValuesOnConditionCheckFailure() {
            return returnValuesOnConditionCheckFailure;
        }

        public final void setReturnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
            return this;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(
                ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure == null ? null
                    : returnValuesOnConditionCheckFailure.toString());
            return this;
        }

        @Override
        public ParameterizedStatement build() {
            return new ParameterizedStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
