/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * A new witness to be added to a new global table.
 * </p>
 * </li>
 * <li>
 * <p>
 * An existing witness to be removed from an existing global table.
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can configure one witness per MRSC global table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalTableWitnessGroupUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalTableWitnessGroupUpdate.Builder, GlobalTableWitnessGroupUpdate> {
    private static final SdkField<CreateGlobalTableWitnessGroupMemberAction> CREATE_FIELD = SdkField
            .<CreateGlobalTableWitnessGroupMemberAction> builder(MarshallingType.SDK_POJO).memberName("Create")
            .getter(getter(GlobalTableWitnessGroupUpdate::create)).setter(setter(Builder::create))
            .constructor(CreateGlobalTableWitnessGroupMemberAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Create").build()).build();

    private static final SdkField<DeleteGlobalTableWitnessGroupMemberAction> DELETE_FIELD = SdkField
            .<DeleteGlobalTableWitnessGroupMemberAction> builder(MarshallingType.SDK_POJO).memberName("Delete")
            .getter(getter(GlobalTableWitnessGroupUpdate::delete)).setter(setter(Builder::delete))
            .constructor(DeleteGlobalTableWitnessGroupMemberAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_FIELD, DELETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CreateGlobalTableWitnessGroupMemberAction create;

    private final DeleteGlobalTableWitnessGroupMemberAction delete;

    private GlobalTableWitnessGroupUpdate(BuilderImpl builder) {
        this.create = builder.create;
        this.delete = builder.delete;
    }

    /**
     * <p>
     * Specifies a witness Region to be added to a new MRSC global table. The witness must be added when creating the
     * MRSC global table.
     * </p>
     * 
     * @return Specifies a witness Region to be added to a new MRSC global table. The witness must be added when
     *         creating the MRSC global table.
     */
    public final CreateGlobalTableWitnessGroupMemberAction create() {
        return create;
    }

    /**
     * <p>
     * Specifies a witness Region to be removed from an existing global table. Must be done in conjunction with removing
     * a replica. The deletion of both a witness and replica converts the remaining replica to a single-Region DynamoDB
     * table.
     * </p>
     * 
     * @return Specifies a witness Region to be removed from an existing global table. Must be done in conjunction with
     *         removing a replica. The deletion of both a witness and replica converts the remaining replica to a
     *         single-Region DynamoDB table.
     */
    public final DeleteGlobalTableWitnessGroupMemberAction delete() {
        return delete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(create());
        hashCode = 31 * hashCode + Objects.hashCode(delete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTableWitnessGroupUpdate)) {
            return false;
        }
        GlobalTableWitnessGroupUpdate other = (GlobalTableWitnessGroupUpdate) obj;
        return Objects.equals(create(), other.create()) && Objects.equals(delete(), other.delete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalTableWitnessGroupUpdate").add("Create", create()).add("Delete", delete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Create":
            return Optional.ofNullable(clazz.cast(create()));
        case "Delete":
            return Optional.ofNullable(clazz.cast(delete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Create", CREATE_FIELD);
        map.put("Delete", DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalTableWitnessGroupUpdate, T> g) {
        return obj -> g.apply((GlobalTableWitnessGroupUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalTableWitnessGroupUpdate> {
        /**
         * <p>
         * Specifies a witness Region to be added to a new MRSC global table. The witness must be added when creating
         * the MRSC global table.
         * </p>
         * 
         * @param create
         *        Specifies a witness Region to be added to a new MRSC global table. The witness must be added when
         *        creating the MRSC global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder create(CreateGlobalTableWitnessGroupMemberAction create);

        /**
         * <p>
         * Specifies a witness Region to be added to a new MRSC global table. The witness must be added when creating
         * the MRSC global table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateGlobalTableWitnessGroupMemberAction.Builder} avoiding the need to create one manually via
         * {@link CreateGlobalTableWitnessGroupMemberAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateGlobalTableWitnessGroupMemberAction.Builder#build()} is
         * called immediately and its result is passed to {@link #create(CreateGlobalTableWitnessGroupMemberAction)}.
         * 
         * @param create
         *        a consumer that will call methods on {@link CreateGlobalTableWitnessGroupMemberAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #create(CreateGlobalTableWitnessGroupMemberAction)
         */
        default Builder create(Consumer<CreateGlobalTableWitnessGroupMemberAction.Builder> create) {
            return create(CreateGlobalTableWitnessGroupMemberAction.builder().applyMutation(create).build());
        }

        /**
         * <p>
         * Specifies a witness Region to be removed from an existing global table. Must be done in conjunction with
         * removing a replica. The deletion of both a witness and replica converts the remaining replica to a
         * single-Region DynamoDB table.
         * </p>
         * 
         * @param delete
         *        Specifies a witness Region to be removed from an existing global table. Must be done in conjunction
         *        with removing a replica. The deletion of both a witness and replica converts the remaining replica to
         *        a single-Region DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delete(DeleteGlobalTableWitnessGroupMemberAction delete);

        /**
         * <p>
         * Specifies a witness Region to be removed from an existing global table. Must be done in conjunction with
         * removing a replica. The deletion of both a witness and replica converts the remaining replica to a
         * single-Region DynamoDB table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DeleteGlobalTableWitnessGroupMemberAction.Builder} avoiding the need to create one manually via
         * {@link DeleteGlobalTableWitnessGroupMemberAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteGlobalTableWitnessGroupMemberAction.Builder#build()} is
         * called immediately and its result is passed to {@link #delete(DeleteGlobalTableWitnessGroupMemberAction)}.
         * 
         * @param delete
         *        a consumer that will call methods on {@link DeleteGlobalTableWitnessGroupMemberAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delete(DeleteGlobalTableWitnessGroupMemberAction)
         */
        default Builder delete(Consumer<DeleteGlobalTableWitnessGroupMemberAction.Builder> delete) {
            return delete(DeleteGlobalTableWitnessGroupMemberAction.builder().applyMutation(delete).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CreateGlobalTableWitnessGroupMemberAction create;

        private DeleteGlobalTableWitnessGroupMemberAction delete;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTableWitnessGroupUpdate model) {
            create(model.create);
            delete(model.delete);
        }

        public final CreateGlobalTableWitnessGroupMemberAction.Builder getCreate() {
            return create != null ? create.toBuilder() : null;
        }

        public final void setCreate(CreateGlobalTableWitnessGroupMemberAction.BuilderImpl create) {
            this.create = create != null ? create.build() : null;
        }

        @Override
        public final Builder create(CreateGlobalTableWitnessGroupMemberAction create) {
            this.create = create;
            return this;
        }

        public final DeleteGlobalTableWitnessGroupMemberAction.Builder getDelete() {
            return delete != null ? delete.toBuilder() : null;
        }

        public final void setDelete(DeleteGlobalTableWitnessGroupMemberAction.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        @Override
        public final Builder delete(DeleteGlobalTableWitnessGroupMemberAction delete) {
            this.delete = delete;
            return this;
        }

        @Override
        public GlobalTableWitnessGroupUpdate build() {
            return new GlobalTableWitnessGroupUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
