/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the source file for the import.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportSummary implements SdkPojo, Serializable, ToCopyableBuilder<ImportSummary.Builder, ImportSummary> {
    private static final SdkField<String> IMPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportArn").getter(getter(ImportSummary::importArn)).setter(setter(Builder::importArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportArn").build()).build();

    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportStatus").getter(getter(ImportSummary::importStatusAsString)).setter(setter(Builder::importStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportStatus").build()).build();

    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableArn").getter(getter(ImportSummary::tableArn)).setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()).build();

    private static final SdkField<S3BucketSource> S3_BUCKET_SOURCE_FIELD = SdkField
            .<S3BucketSource> builder(MarshallingType.SDK_POJO).memberName("S3BucketSource")
            .getter(getter(ImportSummary::s3BucketSource)).setter(setter(Builder::s3BucketSource))
            .constructor(S3BucketSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketSource").build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupArn").getter(getter(ImportSummary::cloudWatchLogGroupArn))
            .setter(setter(Builder::cloudWatchLogGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build())
            .build();

    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputFormat").getter(getter(ImportSummary::inputFormatAsString)).setter(setter(Builder::inputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ImportSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ImportSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ARN_FIELD,
            IMPORT_STATUS_FIELD, TABLE_ARN_FIELD, S3_BUCKET_SOURCE_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, INPUT_FORMAT_FIELD,
            START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String importArn;

    private final String importStatus;

    private final String tableArn;

    private final S3BucketSource s3BucketSource;

    private final String cloudWatchLogGroupArn;

    private final String inputFormat;

    private final Instant startTime;

    private final Instant endTime;

    private ImportSummary(BuilderImpl builder) {
        this.importArn = builder.importArn;
        this.importStatus = builder.importStatus;
        this.tableArn = builder.tableArn;
        this.s3BucketSource = builder.s3BucketSource;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.inputFormat = builder.inputFormat;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) corresponding to the import request.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) corresponding to the import request.
     */
    public final String importArn() {
        return importArn;
    }

    /**
     * <p>
     * The status of the import operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import operation.
     * @see ImportStatus
     */
    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(importStatus);
    }

    /**
     * <p>
     * The status of the import operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import operation.
     * @see ImportStatus
     */
    public final String importStatusAsString() {
        return importStatus;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the table being imported into.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the table being imported into.
     */
    public final String tableArn() {
        return tableArn;
    }

    /**
     * <p>
     * The path and S3 bucket of the source file that is being imported. This includes the S3Bucket (required),
     * S3KeyPrefix (optional) and S3BucketOwner (optional if the bucket is owned by the requester).
     * </p>
     * 
     * @return The path and S3 bucket of the source file that is being imported. This includes the S3Bucket (required),
     *         S3KeyPrefix (optional) and S3BucketOwner (optional if the bucket is owned by the requester).
     */
    public final S3BucketSource s3BucketSource() {
        return s3BucketSource;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with this import task.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with this import task.
     */
    public final String cloudWatchLogGroupArn() {
        return cloudWatchLogGroupArn;
    }

    /**
     * <p>
     * The format of the source data. Valid values are <code>CSV</code>, <code>DYNAMODB_JSON</code> or <code>ION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFormat} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFormatAsString}.
     * </p>
     * 
     * @return The format of the source data. Valid values are <code>CSV</code>, <code>DYNAMODB_JSON</code> or
     *         <code>ION</code>.
     * @see InputFormat
     */
    public final InputFormat inputFormat() {
        return InputFormat.fromValue(inputFormat);
    }

    /**
     * <p>
     * The format of the source data. Valid values are <code>CSV</code>, <code>DYNAMODB_JSON</code> or <code>ION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFormat} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFormatAsString}.
     * </p>
     * 
     * @return The format of the source data. Valid values are <code>CSV</code>, <code>DYNAMODB_JSON</code> or
     *         <code>ION</code>.
     * @see InputFormat
     */
    public final String inputFormatAsString() {
        return inputFormat;
    }

    /**
     * <p>
     * The time at which this import task began.
     * </p>
     * 
     * @return The time at which this import task began.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time at which this import task ended. (Does this include the successful complete creation of the table it was
     * imported to?)
     * </p>
     * 
     * @return The time at which this import task ended. (Does this include the successful complete creation of the
     *         table it was imported to?)
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importArn());
        hashCode = 31 * hashCode + Objects.hashCode(importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketSource());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSummary)) {
            return false;
        }
        ImportSummary other = (ImportSummary) obj;
        return Objects.equals(importArn(), other.importArn())
                && Objects.equals(importStatusAsString(), other.importStatusAsString())
                && Objects.equals(tableArn(), other.tableArn()) && Objects.equals(s3BucketSource(), other.s3BucketSource())
                && Objects.equals(cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn())
                && Objects.equals(inputFormatAsString(), other.inputFormatAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportSummary").add("ImportArn", importArn()).add("ImportStatus", importStatusAsString())
                .add("TableArn", tableArn()).add("S3BucketSource", s3BucketSource())
                .add("CloudWatchLogGroupArn", cloudWatchLogGroupArn()).add("InputFormat", inputFormatAsString())
                .add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportArn":
            return Optional.ofNullable(clazz.cast(importArn()));
        case "ImportStatus":
            return Optional.ofNullable(clazz.cast(importStatusAsString()));
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        case "S3BucketSource":
            return Optional.ofNullable(clazz.cast(s3BucketSource()));
        case "CloudWatchLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupArn()));
        case "InputFormat":
            return Optional.ofNullable(clazz.cast(inputFormatAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImportArn", IMPORT_ARN_FIELD);
        map.put("ImportStatus", IMPORT_STATUS_FIELD);
        map.put("TableArn", TABLE_ARN_FIELD);
        map.put("S3BucketSource", S3_BUCKET_SOURCE_FIELD);
        map.put("CloudWatchLogGroupArn", CLOUD_WATCH_LOG_GROUP_ARN_FIELD);
        map.put("InputFormat", INPUT_FORMAT_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportSummary, T> g) {
        return obj -> g.apply((ImportSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportSummary> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) corresponding to the import request.
         * </p>
         * 
         * @param importArn
         *        The Amazon Resource Number (ARN) corresponding to the import request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importArn(String importArn);

        /**
         * <p>
         * The status of the import operation.
         * </p>
         * 
         * @param importStatus
         *        The status of the import operation.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(String importStatus);

        /**
         * <p>
         * The status of the import operation.
         * </p>
         * 
         * @param importStatus
         *        The status of the import operation.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(ImportStatus importStatus);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the table being imported into.
         * </p>
         * 
         * @param tableArn
         *        The Amazon Resource Number (ARN) of the table being imported into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);

        /**
         * <p>
         * The path and S3 bucket of the source file that is being imported. This includes the S3Bucket (required),
         * S3KeyPrefix (optional) and S3BucketOwner (optional if the bucket is owned by the requester).
         * </p>
         * 
         * @param s3BucketSource
         *        The path and S3 bucket of the source file that is being imported. This includes the S3Bucket
         *        (required), S3KeyPrefix (optional) and S3BucketOwner (optional if the bucket is owned by the
         *        requester).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketSource(S3BucketSource s3BucketSource);

        /**
         * <p>
         * The path and S3 bucket of the source file that is being imported. This includes the S3Bucket (required),
         * S3KeyPrefix (optional) and S3BucketOwner (optional if the bucket is owned by the requester).
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BucketSource.Builder} avoiding the need
         * to create one manually via {@link S3BucketSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3BucketSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3BucketSource(S3BucketSource)}.
         * 
         * @param s3BucketSource
         *        a consumer that will call methods on {@link S3BucketSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BucketSource(S3BucketSource)
         */
        default Builder s3BucketSource(Consumer<S3BucketSource.Builder> s3BucketSource) {
            return s3BucketSource(S3BucketSource.builder().applyMutation(s3BucketSource).build());
        }

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with this import task.
         * </p>
         * 
         * @param cloudWatchLogGroupArn
         *        The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with this import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn);

        /**
         * <p>
         * The format of the source data. Valid values are <code>CSV</code>, <code>DYNAMODB_JSON</code> or
         * <code>ION</code>.
         * </p>
         * 
         * @param inputFormat
         *        The format of the source data. Valid values are <code>CSV</code>, <code>DYNAMODB_JSON</code> or
         *        <code>ION</code>.
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder inputFormat(String inputFormat);

        /**
         * <p>
         * The format of the source data. Valid values are <code>CSV</code>, <code>DYNAMODB_JSON</code> or
         * <code>ION</code>.
         * </p>
         * 
         * @param inputFormat
         *        The format of the source data. Valid values are <code>CSV</code>, <code>DYNAMODB_JSON</code> or
         *        <code>ION</code>.
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder inputFormat(InputFormat inputFormat);

        /**
         * <p>
         * The time at which this import task began.
         * </p>
         * 
         * @param startTime
         *        The time at which this import task began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time at which this import task ended. (Does this include the successful complete creation of the table it
         * was imported to?)
         * </p>
         * 
         * @param endTime
         *        The time at which this import task ended. (Does this include the successful complete creation of the
         *        table it was imported to?)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String importArn;

        private String importStatus;

        private String tableArn;

        private S3BucketSource s3BucketSource;

        private String cloudWatchLogGroupArn;

        private String inputFormat;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSummary model) {
            importArn(model.importArn);
            importStatus(model.importStatus);
            tableArn(model.tableArn);
            s3BucketSource(model.s3BucketSource);
            cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            inputFormat(model.inputFormat);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getImportArn() {
            return importArn;
        }

        public final void setImportArn(String importArn) {
            this.importArn = importArn;
        }

        @Override
        public final Builder importArn(String importArn) {
            this.importArn = importArn;
            return this;
        }

        public final String getImportStatus() {
            return importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final String getTableArn() {
            return tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final S3BucketSource.Builder getS3BucketSource() {
            return s3BucketSource != null ? s3BucketSource.toBuilder() : null;
        }

        public final void setS3BucketSource(S3BucketSource.BuilderImpl s3BucketSource) {
            this.s3BucketSource = s3BucketSource != null ? s3BucketSource.build() : null;
        }

        @Override
        public final Builder s3BucketSource(S3BucketSource s3BucketSource) {
            this.s3BucketSource = s3BucketSource;
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final String getInputFormat() {
            return inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public ImportSummary build() {
            return new ImportSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
