/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an <code>UpdateTimeToLive</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTimeToLiveRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateTimeToLiveRequest.Builder, UpdateTimeToLiveRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTimeToLiveRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<TimeToLiveSpecification> TIME_TO_LIVE_SPECIFICATION_FIELD = SdkField
            .<TimeToLiveSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateTimeToLiveRequest::timeToLiveSpecification)).setter(setter(Builder::timeToLiveSpecification))
            .constructor(TimeToLiveSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLiveSpecification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            TIME_TO_LIVE_SPECIFICATION_FIELD));

    private final String tableName;

    private final TimeToLiveSpecification timeToLiveSpecification;

    private UpdateTimeToLiveRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.timeToLiveSpecification = builder.timeToLiveSpecification;
    }

    /**
     * <p>
     * The name of the table to be configured.
     * </p>
     * 
     * @return The name of the table to be configured.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Represents the settings used to enable or disable Time to Live for the specified table.
     * </p>
     * 
     * @return Represents the settings used to enable or disable Time to Live for the specified table.
     */
    public TimeToLiveSpecification timeToLiveSpecification() {
        return timeToLiveSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLiveSpecification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTimeToLiveRequest)) {
            return false;
        }
        UpdateTimeToLiveRequest other = (UpdateTimeToLiveRequest) obj;
        return Objects.equals(tableName(), other.tableName())
                && Objects.equals(timeToLiveSpecification(), other.timeToLiveSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTimeToLiveRequest").add("TableName", tableName())
                .add("TimeToLiveSpecification", timeToLiveSpecification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TimeToLiveSpecification":
            return Optional.ofNullable(clazz.cast(timeToLiveSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTimeToLiveRequest, T> g) {
        return obj -> g.apply((UpdateTimeToLiveRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTimeToLiveRequest> {
        /**
         * <p>
         * The name of the table to be configured.
         * </p>
         * 
         * @param tableName
         *        The name of the table to be configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Represents the settings used to enable or disable Time to Live for the specified table.
         * </p>
         * 
         * @param timeToLiveSpecification
         *        Represents the settings used to enable or disable Time to Live for the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification);

        /**
         * <p>
         * Represents the settings used to enable or disable Time to Live for the specified table.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeToLiveSpecification.Builder} avoiding the
         * need to create one manually via {@link TimeToLiveSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeToLiveSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #timeToLiveSpecification(TimeToLiveSpecification)}.
         * 
         * @param timeToLiveSpecification
         *        a consumer that will call methods on {@link TimeToLiveSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeToLiveSpecification(TimeToLiveSpecification)
         */
        default Builder timeToLiveSpecification(Consumer<TimeToLiveSpecification.Builder> timeToLiveSpecification) {
            return timeToLiveSpecification(TimeToLiveSpecification.builder().applyMutation(timeToLiveSpecification).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableName;

        private TimeToLiveSpecification timeToLiveSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTimeToLiveRequest model) {
            super(model);
            tableName(model.tableName);
            timeToLiveSpecification(model.timeToLiveSpecification);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final TimeToLiveSpecification.Builder getTimeToLiveSpecification() {
            return timeToLiveSpecification != null ? timeToLiveSpecification.toBuilder() : null;
        }

        @Override
        public final Builder timeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        public final void setTimeToLiveSpecification(TimeToLiveSpecification.BuilderImpl timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification != null ? timeToLiveSpecification.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTimeToLiveRequest build() {
            return new UpdateTimeToLiveRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
