/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTableFromBackupRequest extends DynamoDbRequest implements
        ToCopyableBuilder<RestoreTableFromBackupRequest.Builder, RestoreTableFromBackupRequest> {
    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreTableFromBackupRequest::targetTableName)).setter(setter(Builder::targetTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()).build();

    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreTableFromBackupRequest::backupArn)).setter(setter(Builder::backupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TABLE_NAME_FIELD,
            BACKUP_ARN_FIELD));

    private final String targetTableName;

    private final String backupArn;

    private RestoreTableFromBackupRequest(BuilderImpl builder) {
        super(builder);
        this.targetTableName = builder.targetTableName;
        this.backupArn = builder.backupArn;
    }

    /**
     * <p>
     * The name of the new table to which the backup must be restored.
     * </p>
     * 
     * @return The name of the new table to which the backup must be restored.
     */
    public String targetTableName() {
        return targetTableName;
    }

    /**
     * <p>
     * The ARN associated with the backup.
     * </p>
     * 
     * @return The ARN associated with the backup.
     */
    public String backupArn() {
        return backupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(backupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromBackupRequest)) {
            return false;
        }
        RestoreTableFromBackupRequest other = (RestoreTableFromBackupRequest) obj;
        return Objects.equals(targetTableName(), other.targetTableName()) && Objects.equals(backupArn(), other.backupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RestoreTableFromBackupRequest").add("TargetTableName", targetTableName())
                .add("BackupArn", backupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetTableName":
            return Optional.ofNullable(clazz.cast(targetTableName()));
        case "BackupArn":
            return Optional.ofNullable(clazz.cast(backupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableFromBackupRequest, T> g) {
        return obj -> g.apply((RestoreTableFromBackupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreTableFromBackupRequest> {
        /**
         * <p>
         * The name of the new table to which the backup must be restored.
         * </p>
         * 
         * @param targetTableName
         *        The name of the new table to which the backup must be restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTableName(String targetTableName);

        /**
         * <p>
         * The ARN associated with the backup.
         * </p>
         * 
         * @param backupArn
         *        The ARN associated with the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupArn(String backupArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String targetTableName;

        private String backupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromBackupRequest model) {
            super(model);
            targetTableName(model.targetTableName);
            backupArn(model.backupArn);
        }

        public final String getTargetTableName() {
            return targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        public final String getBackupArn() {
            return backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableFromBackupRequest build() {
            return new RestoreTableFromBackupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
