/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details for the read/write capacity mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillingModeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BillingModeSummary.Builder, BillingModeSummary> {
    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BillingModeSummary::billingModeAsString)).setter(setter(Builder::billingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TO_PAY_PER_REQUEST_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(BillingModeSummary::lastUpdateToPayPerRequestDateTime))
            .setter(setter(Builder::lastUpdateToPayPerRequestDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateToPayPerRequestDateTime")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_MODE_FIELD,
            LAST_UPDATE_TO_PAY_PER_REQUEST_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String billingMode;

    private final Instant lastUpdateToPayPerRequestDateTime;

    private BillingModeSummary(BuilderImpl builder) {
        this.billingMode = builder.billingMode;
        this.lastUpdateToPayPerRequestDateTime = builder.lastUpdateToPayPerRequestDateTime;
    }

    /**
     * <p>
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
     * changed later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using
     * <code>PROVISIONED</code> for predictable workloads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend
     * using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return Controls how you are charged for read and write throughput and how you manage capacity. This setting can
     *         be changed later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend
     *         using <code>PROVISIONED</code> for predictable workloads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
     *         recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public BillingMode billingMode() {
        return BillingMode.fromValue(billingMode);
    }

    /**
     * <p>
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
     * changed later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using
     * <code>PROVISIONED</code> for predictable workloads.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend
     * using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return Controls how you are charged for read and write throughput and how you manage capacity. This setting can
     *         be changed later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend
     *         using <code>PROVISIONED</code> for predictable workloads.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
     *         recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public String billingModeAsString() {
        return billingMode;
    }

    /**
     * <p>
     * Represents the time when <code>PAY_PER_REQUEST</code> was last set as the read/write capacity mode.
     * </p>
     * 
     * @return Represents the time when <code>PAY_PER_REQUEST</code> was last set as the read/write capacity mode.
     */
    public Instant lastUpdateToPayPerRequestDateTime() {
        return lastUpdateToPayPerRequestDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(billingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateToPayPerRequestDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingModeSummary)) {
            return false;
        }
        BillingModeSummary other = (BillingModeSummary) obj;
        return Objects.equals(billingModeAsString(), other.billingModeAsString())
                && Objects.equals(lastUpdateToPayPerRequestDateTime(), other.lastUpdateToPayPerRequestDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BillingModeSummary").add("BillingMode", billingModeAsString())
                .add("LastUpdateToPayPerRequestDateTime", lastUpdateToPayPerRequestDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingMode":
            return Optional.ofNullable(clazz.cast(billingModeAsString()));
        case "LastUpdateToPayPerRequestDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateToPayPerRequestDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BillingModeSummary, T> g) {
        return obj -> g.apply((BillingModeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillingModeSummary> {
        /**
         * <p>
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
         * changed later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using
         * <code>PROVISIONED</code> for predictable workloads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
         * recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         * </p>
         * </li>
         * </ul>
         * 
         * @param billingMode
         *        Controls how you are charged for read and write throughput and how you manage capacity. This setting
         *        can be changed later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend
         *        using <code>PROVISIONED</code> for predictable workloads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
         *        recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(String billingMode);

        /**
         * <p>
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
         * changed later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using
         * <code>PROVISIONED</code> for predictable workloads.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
         * recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         * </p>
         * </li>
         * </ul>
         * 
         * @param billingMode
         *        Controls how you are charged for read and write throughput and how you manage capacity. This setting
         *        can be changed later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend
         *        using <code>PROVISIONED</code> for predictable workloads.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We
         *        recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(BillingMode billingMode);

        /**
         * <p>
         * Represents the time when <code>PAY_PER_REQUEST</code> was last set as the read/write capacity mode.
         * </p>
         * 
         * @param lastUpdateToPayPerRequestDateTime
         *        Represents the time when <code>PAY_PER_REQUEST</code> was last set as the read/write capacity mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateToPayPerRequestDateTime(Instant lastUpdateToPayPerRequestDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String billingMode;

        private Instant lastUpdateToPayPerRequestDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingModeSummary model) {
            billingMode(model.billingMode);
            lastUpdateToPayPerRequestDateTime(model.lastUpdateToPayPerRequestDateTime);
        }

        public final String getBillingModeAsString() {
            return billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode.toString());
            return this;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        public final Instant getLastUpdateToPayPerRequestDateTime() {
            return lastUpdateToPayPerRequestDateTime;
        }

        @Override
        public final Builder lastUpdateToPayPerRequestDateTime(Instant lastUpdateToPayPerRequestDateTime) {
            this.lastUpdateToPayPerRequestDateTime = lastUpdateToPayPerRequestDateTime;
            return this;
        }

        public final void setLastUpdateToPayPerRequestDateTime(Instant lastUpdateToPayPerRequestDateTime) {
            this.lastUpdateToPayPerRequestDateTime = lastUpdateToPayPerRequestDateTime;
        }

        @Override
        public BillingModeSummary build() {
            return new BillingModeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
