/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTableToPointInTimeRequest extends DynamoDbRequest implements
        ToCopyableBuilder<RestoreTableToPointInTimeRequest.Builder, RestoreTableToPointInTimeRequest> {
    private static final SdkField<String> SOURCE_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreTableToPointInTimeRequest::sourceTableName)).setter(setter(Builder::sourceTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableName").build()).build();

    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreTableToPointInTimeRequest::targetTableName)).setter(setter(Builder::targetTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()).build();

    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_TIME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RestoreTableToPointInTimeRequest::useLatestRestorableTime))
            .setter(setter(Builder::useLatestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLatestRestorableTime").build())
            .build();

    private static final SdkField<Instant> RESTORE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(RestoreTableToPointInTimeRequest::restoreDateTime)).setter(setter(Builder::restoreDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TABLE_NAME_FIELD,
            TARGET_TABLE_NAME_FIELD, USE_LATEST_RESTORABLE_TIME_FIELD, RESTORE_DATE_TIME_FIELD));

    private final String sourceTableName;

    private final String targetTableName;

    private final Boolean useLatestRestorableTime;

    private final Instant restoreDateTime;

    private RestoreTableToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.sourceTableName = builder.sourceTableName;
        this.targetTableName = builder.targetTableName;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.restoreDateTime = builder.restoreDateTime;
    }

    /**
     * <p>
     * Name of the source table that is being restored.
     * </p>
     * 
     * @return Name of the source table that is being restored.
     */
    public String sourceTableName() {
        return sourceTableName;
    }

    /**
     * <p>
     * The name of the new table to which it must be restored to.
     * </p>
     * 
     * @return The name of the new table to which it must be restored to.
     */
    public String targetTableName() {
        return targetTableName;
    }

    /**
     * <p>
     * Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5 minutes
     * before the current time.
     * </p>
     * 
     * @return Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5
     *         minutes before the current time.
     */
    public Boolean useLatestRestorableTime() {
        return useLatestRestorableTime;
    }

    /**
     * <p>
     * Time in the past to restore the table to.
     * </p>
     * 
     * @return Time in the past to restore the table to.
     */
    public Instant restoreDateTime() {
        return restoreDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(restoreDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableToPointInTimeRequest)) {
            return false;
        }
        RestoreTableToPointInTimeRequest other = (RestoreTableToPointInTimeRequest) obj;
        return Objects.equals(sourceTableName(), other.sourceTableName())
                && Objects.equals(targetTableName(), other.targetTableName())
                && Objects.equals(useLatestRestorableTime(), other.useLatestRestorableTime())
                && Objects.equals(restoreDateTime(), other.restoreDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RestoreTableToPointInTimeRequest").add("SourceTableName", sourceTableName())
                .add("TargetTableName", targetTableName()).add("UseLatestRestorableTime", useLatestRestorableTime())
                .add("RestoreDateTime", restoreDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceTableName":
            return Optional.ofNullable(clazz.cast(sourceTableName()));
        case "TargetTableName":
            return Optional.ofNullable(clazz.cast(targetTableName()));
        case "UseLatestRestorableTime":
            return Optional.ofNullable(clazz.cast(useLatestRestorableTime()));
        case "RestoreDateTime":
            return Optional.ofNullable(clazz.cast(restoreDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableToPointInTimeRequest, T> g) {
        return obj -> g.apply((RestoreTableToPointInTimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreTableToPointInTimeRequest> {
        /**
         * <p>
         * Name of the source table that is being restored.
         * </p>
         * 
         * @param sourceTableName
         *        Name of the source table that is being restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableName(String sourceTableName);

        /**
         * <p>
         * The name of the new table to which it must be restored to.
         * </p>
         * 
         * @param targetTableName
         *        The name of the new table to which it must be restored to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTableName(String targetTableName);

        /**
         * <p>
         * Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5 minutes
         * before the current time.
         * </p>
         * 
         * @param useLatestRestorableTime
         *        Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5
         *        minutes before the current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLatestRestorableTime(Boolean useLatestRestorableTime);

        /**
         * <p>
         * Time in the past to restore the table to.
         * </p>
         * 
         * @param restoreDateTime
         *        Time in the past to restore the table to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreDateTime(Instant restoreDateTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String sourceTableName;

        private String targetTableName;

        private Boolean useLatestRestorableTime;

        private Instant restoreDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableToPointInTimeRequest model) {
            super(model);
            sourceTableName(model.sourceTableName);
            targetTableName(model.targetTableName);
            useLatestRestorableTime(model.useLatestRestorableTime);
            restoreDateTime(model.restoreDateTime);
        }

        public final String getSourceTableName() {
            return sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        public final String getTargetTableName() {
            return targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        public final Boolean getUseLatestRestorableTime() {
            return useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        public final Instant getRestoreDateTime() {
            return restoreDateTime;
        }

        @Override
        public final Builder restoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
            return this;
        }

        public final void setRestoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableToPointInTimeRequest build() {
            return new RestoreTableToPointInTimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
