/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<ListBackupsResponse.Builder, ListBackupsResponse> {
    private static final SdkField<List<BackupSummary>> BACKUP_SUMMARIES_FIELD = SdkField
            .<List<BackupSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListBackupsResponse::backupSummaries))
            .setter(setter(Builder::backupSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_EVALUATED_BACKUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBackupsResponse::lastEvaluatedBackupArn)).setter(setter(Builder::lastEvaluatedBackupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedBackupArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_SUMMARIES_FIELD,
            LAST_EVALUATED_BACKUP_ARN_FIELD));

    private final List<BackupSummary> backupSummaries;

    private final String lastEvaluatedBackupArn;

    private ListBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.backupSummaries = builder.backupSummaries;
        this.lastEvaluatedBackupArn = builder.lastEvaluatedBackupArn;
    }

    /**
     * <p>
     * List of <code>BackupSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of <code>BackupSummary</code> objects.
     */
    public List<BackupSummary> backupSummaries() {
        return backupSummaries;
    }

    /**
     * <p>
     * The ARN of the backup last evaluated when the current page of results was returned, inclusive of the current page
     * of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a new
     * <code>ListBackups</code> operation in order to fetch the next page of results.
     * </p>
     * <p>
     * If <code>LastEvaluatedBackupArn</code> is empty, then the last page of results has been processed and there are
     * no more results to be retrieved.
     * </p>
     * <p>
     * If <code>LastEvaluatedBackupArn</code> is not empty, this may or may not indicate that there is more data to be
     * returned. All results are guaranteed to have been returned if and only if no value for
     * <code>LastEvaluatedBackupArn</code> is returned.
     * </p>
     * 
     * @return The ARN of the backup last evaluated when the current page of results was returned, inclusive of the
     *         current page of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a new
     *         <code>ListBackups</code> operation in order to fetch the next page of results. </p>
     *         <p>
     *         If <code>LastEvaluatedBackupArn</code> is empty, then the last page of results has been processed and
     *         there are no more results to be retrieved.
     *         </p>
     *         <p>
     *         If <code>LastEvaluatedBackupArn</code> is not empty, this may or may not indicate that there is more data
     *         to be returned. All results are guaranteed to have been returned if and only if no value for
     *         <code>LastEvaluatedBackupArn</code> is returned.
     */
    public String lastEvaluatedBackupArn() {
        return lastEvaluatedBackupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedBackupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupsResponse)) {
            return false;
        }
        ListBackupsResponse other = (ListBackupsResponse) obj;
        return Objects.equals(backupSummaries(), other.backupSummaries())
                && Objects.equals(lastEvaluatedBackupArn(), other.lastEvaluatedBackupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListBackupsResponse").add("BackupSummaries", backupSummaries())
                .add("LastEvaluatedBackupArn", lastEvaluatedBackupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupSummaries":
            return Optional.ofNullable(clazz.cast(backupSummaries()));
        case "LastEvaluatedBackupArn":
            return Optional.ofNullable(clazz.cast(lastEvaluatedBackupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupsResponse, T> g) {
        return obj -> g.apply((ListBackupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBackupsResponse> {
        /**
         * <p>
         * List of <code>BackupSummary</code> objects.
         * </p>
         * 
         * @param backupSummaries
         *        List of <code>BackupSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSummaries(Collection<BackupSummary> backupSummaries);

        /**
         * <p>
         * List of <code>BackupSummary</code> objects.
         * </p>
         * 
         * @param backupSummaries
         *        List of <code>BackupSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSummaries(BackupSummary... backupSummaries);

        /**
         * <p>
         * List of <code>BackupSummary</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackupSummary>.Builder} avoiding the need
         * to create one manually via {@link List<BackupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackupSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #backupSummaries(List<BackupSummary>)}.
         * 
         * @param backupSummaries
         *        a consumer that will call methods on {@link List<BackupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupSummaries(List<BackupSummary>)
         */
        Builder backupSummaries(Consumer<BackupSummary.Builder>... backupSummaries);

        /**
         * <p>
         * The ARN of the backup last evaluated when the current page of results was returned, inclusive of the current
         * page of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a new
         * <code>ListBackups</code> operation in order to fetch the next page of results.
         * </p>
         * <p>
         * If <code>LastEvaluatedBackupArn</code> is empty, then the last page of results has been processed and there
         * are no more results to be retrieved.
         * </p>
         * <p>
         * If <code>LastEvaluatedBackupArn</code> is not empty, this may or may not indicate that there is more data to
         * be returned. All results are guaranteed to have been returned if and only if no value for
         * <code>LastEvaluatedBackupArn</code> is returned.
         * </p>
         * 
         * @param lastEvaluatedBackupArn
         *        The ARN of the backup last evaluated when the current page of results was returned, inclusive of the
         *        current page of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a
         *        new <code>ListBackups</code> operation in order to fetch the next page of results. </p>
         *        <p>
         *        If <code>LastEvaluatedBackupArn</code> is empty, then the last page of results has been processed and
         *        there are no more results to be retrieved.
         *        </p>
         *        <p>
         *        If <code>LastEvaluatedBackupArn</code> is not empty, this may or may not indicate that there is more
         *        data to be returned. All results are guaranteed to have been returned if and only if no value for
         *        <code>LastEvaluatedBackupArn</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedBackupArn(String lastEvaluatedBackupArn);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<BackupSummary> backupSummaries = DefaultSdkAutoConstructList.getInstance();

        private String lastEvaluatedBackupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupsResponse model) {
            super(model);
            backupSummaries(model.backupSummaries);
            lastEvaluatedBackupArn(model.lastEvaluatedBackupArn);
        }

        public final Collection<BackupSummary.Builder> getBackupSummaries() {
            return backupSummaries != null ? backupSummaries.stream().map(BackupSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder backupSummaries(Collection<BackupSummary> backupSummaries) {
            this.backupSummaries = BackupSummariesCopier.copy(backupSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupSummaries(BackupSummary... backupSummaries) {
            backupSummaries(Arrays.asList(backupSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupSummaries(Consumer<BackupSummary.Builder>... backupSummaries) {
            backupSummaries(Stream.of(backupSummaries).map(c -> BackupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBackupSummaries(Collection<BackupSummary.BuilderImpl> backupSummaries) {
            this.backupSummaries = BackupSummariesCopier.copyFromBuilder(backupSummaries);
        }

        public final String getLastEvaluatedBackupArn() {
            return lastEvaluatedBackupArn;
        }

        @Override
        public final Builder lastEvaluatedBackupArn(String lastEvaluatedBackupArn) {
            this.lastEvaluatedBackupArn = lastEvaluatedBackupArn;
            return this;
        }

        public final void setLastEvaluatedBackupArn(String lastEvaluatedBackupArn) {
            this.lastEvaluatedBackupArn = lastEvaluatedBackupArn;
        }

        @Override
        public ListBackupsResponse build() {
            return new ListBackupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
